/* Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package java.nio.channels;


/**
 * A {@code ConnectionPendingException} is thrown when an attempt is made to
 * connect a {@link SocketChannel} that has a non-blocking connection already
 * underway.
 * 
 * @since Android 1.0
 */
public class ConnectionPendingException extends IllegalStateException {

    private static final long serialVersionUID = 2008393366501760879L;

    /**
     * Constructs a {@code ConnectionPendingException}.
     * 
     * @since Android 1.0
     */
    public ConnectionPendingException() {
        super();
    }

}
