/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * Table of Dalvik opcode names.
 *
 * IMPORTANT NOTE: The contents of this file are mostly generated
 * automatically by the opcode-gen tool. Any edits to the generated
 * sections will get wiped out the next time the tool is run.
 */

#include "DexOpcodes.h"
#include <assert.h>

/*
 * Dalvik opcode names.
 */
static const char* gOpNames[kNumPackedOpcodes] = {
    // BEGIN(libdex-opcode-names); GENERATED AUTOMATICALLY BY opcode-gen
    "nop",
    "move",
    "move/from16",
    "move/16",
    "move-wide",
    "move-wide/from16",
    "move-wide/16",
    "move-object",
    "move-object/from16",
    "move-object/16",
    "move-result",
    "move-result-wide",
    "move-result-object",
    "move-exception",
    "return-void",
    "return",
    "return-wide",
    "return-object",
    "const/4",
    "const/16",
    "const",
    "const/high16",
    "const-wide/16",
    "const-wide/32",
    "const-wide",
    "const-wide/high16",
    "const-string",
    "const-string/jumbo",
    "const-class",
    "monitor-enter",
    "monitor-exit",
    "check-cast",
    "instance-of",
    "array-length",
    "new-instance",
    "new-array",
    "filled-new-array",
    "filled-new-array/range",
    "fill-array-data",
    "throw",
    "goto",
    "goto/16",
    "goto/32",
    "packed-switch",
    "sparse-switch",
    "cmpl-float",
    "cmpg-float",
    "cmpl-double",
    "cmpg-double",
    "cmp-long",
    "if-eq",
    "if-ne",
    "if-lt",
    "if-ge",
    "if-gt",
    "if-le",
    "if-eqz",
    "if-nez",
    "if-ltz",
    "if-gez",
    "if-gtz",
    "if-lez",
    "unused-3e",
    "unused-3f",
    "unused-40",
    "unused-41",
    "unused-42",
    "unused-43",
    "aget",
    "aget-wide",
    "aget-object",
    "aget-boolean",
    "aget-byte",
    "aget-char",
    "aget-short",
    "aput",
    "aput-wide",
    "aput-object",
    "aput-boolean",
    "aput-byte",
    "aput-char",
    "aput-short",
    "iget",
    "iget-wide",
    "iget-object",
    "iget-boolean",
    "iget-byte",
    "iget-char",
    "iget-short",
    "iput",
    "iput-wide",
    "iput-object",
    "iput-boolean",
    "iput-byte",
    "iput-char",
    "iput-short",
    "sget",
    "sget-wide",
    "sget-object",
    "sget-boolean",
    "sget-byte",
    "sget-char",
    "sget-short",
    "sput",
    "sput-wide",
    "sput-object",
    "sput-boolean",
    "sput-byte",
    "sput-char",
    "sput-short",
    "invoke-virtual",
    "invoke-super",
    "invoke-direct",
    "invoke-static",
    "invoke-interface",
    "unused-73",
    "invoke-virtual/range",
    "invoke-super/range",
    "invoke-direct/range",
    "invoke-static/range",
    "invoke-interface/range",
    "unused-79",
    "unused-7a",
    "neg-int",
    "not-int",
    "neg-long",
    "not-long",
    "neg-float",
    "neg-double",
    "int-to-long",
    "int-to-float",
    "int-to-double",
    "long-to-int",
    "long-to-float",
    "long-to-double",
    "float-to-int",
    "float-to-long",
    "float-to-double",
    "double-to-int",
    "double-to-long",
    "double-to-float",
    "int-to-byte",
    "int-to-char",
    "int-to-short",
    "add-int",
    "sub-int",
    "mul-int",
    "div-int",
    "rem-int",
    "and-int",
    "or-int",
    "xor-int",
    "shl-int",
    "shr-int",
    "ushr-int",
    "add-long",
    "sub-long",
    "mul-long",
    "div-long",
    "rem-long",
    "and-long",
    "or-long",
    "xor-long",
    "shl-long",
    "shr-long",
    "ushr-long",
    "add-float",
    "sub-float",
    "mul-float",
    "div-float",
    "rem-float",
    "add-double",
    "sub-double",
    "mul-double",
    "div-double",
    "rem-double",
    "add-int/2addr",
    "sub-int/2addr",
    "mul-int/2addr",
    "div-int/2addr",
    "rem-int/2addr",
    "and-int/2addr",
    "or-int/2addr",
    "xor-int/2addr",
    "shl-int/2addr",
    "shr-int/2addr",
    "ushr-int/2addr",
    "add-long/2addr",
    "sub-long/2addr",
    "mul-long/2addr",
    "div-long/2addr",
    "rem-long/2addr",
    "and-long/2addr",
    "or-long/2addr",
    "xor-long/2addr",
    "shl-long/2addr",
    "shr-long/2addr",
    "ushr-long/2addr",
    "add-float/2addr",
    "sub-float/2addr",
    "mul-float/2addr",
    "div-float/2addr",
    "rem-float/2addr",
    "add-double/2addr",
    "sub-double/2addr",
    "mul-double/2addr",
    "div-double/2addr",
    "rem-double/2addr",
    "add-int/lit16",
    "rsub-int",
    "mul-int/lit16",
    "div-int/lit16",
    "rem-int/lit16",
    "and-int/lit16",
    "or-int/lit16",
    "xor-int/lit16",
    "add-int/lit8",
    "rsub-int/lit8",
    "mul-int/lit8",
    "div-int/lit8",
    "rem-int/lit8",
    "and-int/lit8",
    "or-int/lit8",
    "xor-int/lit8",
    "shl-int/lit8",
    "shr-int/lit8",
    "ushr-int/lit8",
    "+iget-volatile",
    "+iput-volatile",
    "+sget-volatile",
    "+sput-volatile",
    "+iget-object-volatile",
    "+iget-wide-volatile",
    "+iput-wide-volatile",
    "+sget-wide-volatile",
    "+sput-wide-volatile",
    "^breakpoint",
    "^throw-verification-error",
    "+execute-inline",
    "+execute-inline/range",
    "+invoke-object-init/range",
    "+return-void-barrier",
    "+iget-quick",
    "+iget-wide-quick",
    "+iget-object-quick",
    "+iput-quick",
    "+iput-wide-quick",
    "+iput-object-quick",
    "+invoke-virtual-quick",
    "+invoke-virtual-quick/range",
    "+invoke-super-quick",
    "+invoke-super-quick/range",
    "+iput-object-volatile",
    "+sget-object-volatile",
    "+sput-object-volatile",
    "dispatch-ff",
    "const-class/jumbo",
    "check-cast/jumbo",
    "instance-of/jumbo",
    "new-instance/jumbo",
    "new-array/jumbo",
    "filled-new-array/jumbo",
    "iget/jumbo",
    "iget-wide/jumbo",
    "iget-object/jumbo",
    "iget-boolean/jumbo",
    "iget-byte/jumbo",
    "iget-char/jumbo",
    "iget-short/jumbo",
    "iput/jumbo",
    "iput-wide/jumbo",
    "iput-object/jumbo",
    "iput-boolean/jumbo",
    "iput-byte/jumbo",
    "iput-char/jumbo",
    "iput-short/jumbo",
    "sget/jumbo",
    "sget-wide/jumbo",
    "sget-object/jumbo",
    "sget-boolean/jumbo",
    "sget-byte/jumbo",
    "sget-char/jumbo",
    "sget-short/jumbo",
    "sput/jumbo",
    "sput-wide/jumbo",
    "sput-object/jumbo",
    "sput-boolean/jumbo",
    "sput-byte/jumbo",
    "sput-char/jumbo",
    "sput-short/jumbo",
    "invoke-virtual/jumbo",
    "invoke-super/jumbo",
    "invoke-direct/jumbo",
    "invoke-static/jumbo",
    "invoke-interface/jumbo",
    "unused-27ff",
    "unused-28ff",
    "unused-29ff",
    "unused-2aff",
    "unused-2bff",
    "unused-2cff",
    "unused-2dff",
    "unused-2eff",
    "unused-2fff",
    "unused-30ff",
    "unused-31ff",
    "unused-32ff",
    "unused-33ff",
    "unused-34ff",
    "unused-35ff",
    "unused-36ff",
    "unused-37ff",
    "unused-38ff",
    "unused-39ff",
    "unused-3aff",
    "unused-3bff",
    "unused-3cff",
    "unused-3dff",
    "unused-3eff",
    "unused-3fff",
    "unused-40ff",
    "unused-41ff",
    "unused-42ff",
    "unused-43ff",
    "unused-44ff",
    "unused-45ff",
    "unused-46ff",
    "unused-47ff",
    "unused-48ff",
    "unused-49ff",
    "unused-4aff",
    "unused-4bff",
    "unused-4cff",
    "unused-4dff",
    "unused-4eff",
    "unused-4fff",
    "unused-50ff",
    "unused-51ff",
    "unused-52ff",
    "unused-53ff",
    "unused-54ff",
    "unused-55ff",
    "unused-56ff",
    "unused-57ff",
    "unused-58ff",
    "unused-59ff",
    "unused-5aff",
    "unused-5bff",
    "unused-5cff",
    "unused-5dff",
    "unused-5eff",
    "unused-5fff",
    "unused-60ff",
    "unused-61ff",
    "unused-62ff",
    "unused-63ff",
    "unused-64ff",
    "unused-65ff",
    "unused-66ff",
    "unused-67ff",
    "unused-68ff",
    "unused-69ff",
    "unused-6aff",
    "unused-6bff",
    "unused-6cff",
    "unused-6dff",
    "unused-6eff",
    "unused-6fff",
    "unused-70ff",
    "unused-71ff",
    "unused-72ff",
    "unused-73ff",
    "unused-74ff",
    "unused-75ff",
    "unused-76ff",
    "unused-77ff",
    "unused-78ff",
    "unused-79ff",
    "unused-7aff",
    "unused-7bff",
    "unused-7cff",
    "unused-7dff",
    "unused-7eff",
    "unused-7fff",
    "unused-80ff",
    "unused-81ff",
    "unused-82ff",
    "unused-83ff",
    "unused-84ff",
    "unused-85ff",
    "unused-86ff",
    "unused-87ff",
    "unused-88ff",
    "unused-89ff",
    "unused-8aff",
    "unused-8bff",
    "unused-8cff",
    "unused-8dff",
    "unused-8eff",
    "unused-8fff",
    "unused-90ff",
    "unused-91ff",
    "unused-92ff",
    "unused-93ff",
    "unused-94ff",
    "unused-95ff",
    "unused-96ff",
    "unused-97ff",
    "unused-98ff",
    "unused-99ff",
    "unused-9aff",
    "unused-9bff",
    "unused-9cff",
    "unused-9dff",
    "unused-9eff",
    "unused-9fff",
    "unused-a0ff",
    "unused-a1ff",
    "unused-a2ff",
    "unused-a3ff",
    "unused-a4ff",
    "unused-a5ff",
    "unused-a6ff",
    "unused-a7ff",
    "unused-a8ff",
    "unused-a9ff",
    "unused-aaff",
    "unused-abff",
    "unused-acff",
    "unused-adff",
    "unused-aeff",
    "unused-afff",
    "unused-b0ff",
    "unused-b1ff",
    "unused-b2ff",
    "unused-b3ff",
    "unused-b4ff",
    "unused-b5ff",
    "unused-b6ff",
    "unused-b7ff",
    "unused-b8ff",
    "unused-b9ff",
    "unused-baff",
    "unused-bbff",
    "unused-bcff",
    "unused-bdff",
    "unused-beff",
    "unused-bfff",
    "unused-c0ff",
    "unused-c1ff",
    "unused-c2ff",
    "unused-c3ff",
    "unused-c4ff",
    "unused-c5ff",
    "unused-c6ff",
    "unused-c7ff",
    "unused-c8ff",
    "unused-c9ff",
    "unused-caff",
    "unused-cbff",
    "unused-ccff",
    "unused-cdff",
    "unused-ceff",
    "unused-cfff",
    "unused-d0ff",
    "unused-d1ff",
    "unused-d2ff",
    "unused-d3ff",
    "unused-d4ff",
    "unused-d5ff",
    "unused-d6ff",
    "unused-d7ff",
    "unused-d8ff",
    "unused-d9ff",
    "unused-daff",
    "unused-dbff",
    "unused-dcff",
    "unused-ddff",
    "unused-deff",
    "unused-dfff",
    "unused-e0ff",
    "unused-e1ff",
    "unused-e2ff",
    "unused-e3ff",
    "unused-e4ff",
    "unused-e5ff",
    "unused-e6ff",
    "unused-e7ff",
    "unused-e8ff",
    "unused-e9ff",
    "unused-eaff",
    "unused-ebff",
    "unused-ecff",
    "unused-edff",
    "unused-eeff",
    "unused-efff",
    "unused-f0ff",
    "unused-f1ff",
    "+invoke-object-init/jumbo",
    "+iget-volatile/jumbo",
    "+iget-wide-volatile/jumbo",
    "+iget-object-volatile/jumbo",
    "+iput-volatile/jumbo",
    "+iput-wide-volatile/jumbo",
    "+iput-object-volatile/jumbo",
    "+sget-volatile/jumbo",
    "+sget-wide-volatile/jumbo",
    "+sget-object-volatile/jumbo",
    "+sput-volatile/jumbo",
    "+sput-wide-volatile/jumbo",
    "+sput-object-volatile/jumbo",
    "^throw-verification-error/jumbo",
    // END(libdex-opcode-names)
};

/*
 * Return the name of an opcode.
 */
const char* dexGetOpcodeName(Opcode op)
{
    assert(op >= 0 && op < kNumPackedOpcodes);
    return gOpNames[op];
}
