/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

static data_1_2_t<float, float, float> g_fdimf_intel_data[] = {
  { // Entry 0
    0x1.861861p-14,
    -0x1.86187ep-15,
    -0x1.249250p-13
  },
  { // Entry 1
    0x1.334d69p-2,
    -0x1.99999ep-3,
    -0x1.000d1cp-1
  },
  { // Entry 2
    0x1.99b3d1p-2,
    -0x1.99999ep-3,
    -0x1.334050p-1
  },
  { // Entry 3
    0x1.999999p-12,
    -0x1.99999ep-13,
    -0x1.333334p-11
  },
  { // Entry 4
    0x1.111e2bp-1,
    -0x1.dddde2p-2,
    -0x1.00068ep0
  },
  { // Entry 5
    0x1.111e29p-1,
    -0x1.dddde6p-2,
    -0x1.00068ep0
  },
  { // Entry 6
    0x1.04a781p-11,
    -0x1.f6b0fep-12,
    -0x1.p-10
  },
  { // Entry 7
    0x1.02960bp-11,
    -0x1.fad3eap-12,
    -0x1.p-10
  },
  { // Entry 8
    0x1.p1,
    0x1.p-149,
    -0x1.p1
  },
  { // Entry 9
    0x1.000001fffffffffffff286bac0p73,
    0x1.000002p73,
    0x1.af28a8p-4
  },
  { // Entry 10
    0x1.249269p-2,
    0x1.08p-21,
    -0x1.249248p-2
  },
  { // Entry 11
    0x1.af2851p-4,
    0x1.08p-23,
    -0x1.af2830p-4
  },
  { // Entry 12
    0x1.000021p-24,
    0x1.08p-43,
    -0x1.p-24
  },
  { // Entry 13
    0x1.4ff4d3p3,
    0x1.083d28p2,
    -0x1.97ac7ep2
  },
  { // Entry 14
    0x1.fffffcp127,
    0x1.fffffcp127,
    -0x1.90p-143
  },
  { // Entry 15
    0x1.fffffdffffffffffffffffffffffffffp127,
    0x1.fffffep127,
    0x1.p-149
  },
  { // Entry 16
    0.0,
    -0x1.40p3,
    -0x1.40p3
  },
  { // Entry 17
    0x1.p1,
    -0x1.p3,
    -0x1.40p3
  },
  { // Entry 18
    0x1.p2,
    -0x1.80p2,
    -0x1.40p3
  },
  { // Entry 19
    0x1.80p2,
    -0x1.p2,
    -0x1.40p3
  },
  { // Entry 20
    0x1.p3,
    -0x1.p1,
    -0x1.40p3
  },
  { // Entry 21
    0x1.40p3,
    0.0,
    -0x1.40p3
  },
  { // Entry 22
    0x1.80p3,
    0x1.p1,
    -0x1.40p3
  },
  { // Entry 23
    0x1.c0p3,
    0x1.p2,
    -0x1.40p3
  },
  { // Entry 24
    0x1.p4,
    0x1.80p2,
    -0x1.40p3
  },
  { // Entry 25
    0x1.20p4,
    0x1.p3,
    -0x1.40p3
  },
  { // Entry 26
    0x1.40p4,
    0x1.40p3,
    -0x1.40p3
  },
  { // Entry 27
    0.0,
    -0x1.80p-148,
    -0x1.80p-148
  },
  { // Entry 28
    0.0,
    -0x1.80p-148,
    -0x1.p-148
  },
  { // Entry 29
    0.0,
    -0x1.80p-148,
    -0x1.p-149
  },
  { // Entry 30
    0.0,
    -0x1.80p-148,
    0.0
  },
  { // Entry 31
    0.0,
    -0x1.80p-148,
    0x1.p-149
  },
  { // Entry 32
    0.0,
    -0x1.80p-148,
    0x1.p-148
  },
  { // Entry 33
    0.0,
    -0x1.80p-148,
    0x1.80p-148
  },
  { // Entry 34
    0x1.p-149,
    -0x1.p-148,
    -0x1.80p-148
  },
  { // Entry 35
    0.0,
    -0x1.p-148,
    -0x1.p-148
  },
  { // Entry 36
    0.0,
    -0x1.p-148,
    -0x1.p-149
  },
  { // Entry 37
    0.0,
    -0x1.p-148,
    0.0
  },
  { // Entry 38
    0.0,
    -0x1.p-148,
    0x1.p-149
  },
  { // Entry 39
    0.0,
    -0x1.p-148,
    0x1.p-148
  },
  { // Entry 40
    0.0,
    -0x1.p-148,
    0x1.80p-148
  },
  { // Entry 41
    0x1.p-148,
    -0x1.p-149,
    -0x1.80p-148
  },
  { // Entry 42
    0x1.p-149,
    -0x1.p-149,
    -0x1.p-148
  },
  { // Entry 43
    0.0,
    -0x1.p-149,
    -0x1.p-149
  },
  { // Entry 44
    0.0,
    -0x1.p-149,
    0.0
  },
  { // Entry 45
    0.0,
    -0x1.p-149,
    0x1.p-149
  },
  { // Entry 46
    0.0,
    -0x1.p-149,
    0x1.p-148
  },
  { // Entry 47
    0.0,
    -0x1.p-149,
    0x1.80p-148
  },
  { // Entry 48
    0x1.80p-148,
    0.0,
    -0x1.80p-148
  },
  { // Entry 49
    0x1.p-148,
    0.0,
    -0x1.p-148
  },
  { // Entry 50
    0x1.p-149,
    0.0,
    -0x1.p-149
  },
  { // Entry 51
    0.0,
    0.0,
    0.0
  },
  { // Entry 52
    0.0,
    0.0,
    0x1.p-149
  },
  { // Entry 53
    0.0,
    0.0,
    0x1.p-148
  },
  { // Entry 54
    0.0,
    0.0,
    0x1.80p-148
  },
  { // Entry 55
    0x1.p-147,
    0x1.p-149,
    -0x1.80p-148
  },
  { // Entry 56
    0x1.80p-148,
    0x1.p-149,
    -0x1.p-148
  },
  { // Entry 57
    0x1.p-148,
    0x1.p-149,
    -0x1.p-149
  },
  { // Entry 58
    0x1.p-149,
    0x1.p-149,
    0.0
  },
  { // Entry 59
    0.0,
    0x1.p-149,
    0x1.p-149
  },
  { // Entry 60
    0.0,
    0x1.p-149,
    0x1.p-148
  },
  { // Entry 61
    0.0,
    0x1.p-149,
    0x1.80p-148
  },
  { // Entry 62
    0x1.40p-147,
    0x1.p-148,
    -0x1.80p-148
  },
  { // Entry 63
    0x1.p-147,
    0x1.p-148,
    -0x1.p-148
  },
  { // Entry 64
    0x1.80p-148,
    0x1.p-148,
    -0x1.p-149
  },
  { // Entry 65
    0x1.p-148,
    0x1.p-148,
    0.0
  },
  { // Entry 66
    0x1.p-149,
    0x1.p-148,
    0x1.p-149
  },
  { // Entry 67
    0.0,
    0x1.p-148,
    0x1.p-148
  },
  { // Entry 68
    0.0,
    0x1.p-148,
    0x1.80p-148
  },
  { // Entry 69
    0x1.80p-147,
    0x1.80p-148,
    -0x1.80p-148
  },
  { // Entry 70
    0x1.40p-147,
    0x1.80p-148,
    -0x1.p-148
  },
  { // Entry 71
    0x1.p-147,
    0x1.80p-148,
    -0x1.p-149
  },
  { // Entry 72
    0x1.80p-148,
    0x1.80p-148,
    0.0
  },
  { // Entry 73
    0x1.p-148,
    0x1.80p-148,
    0x1.p-149
  },
  { // Entry 74
    0x1.p-149,
    0x1.80p-148,
    0x1.p-148
  },
  { // Entry 75
    0.0,
    0x1.80p-148,
    0x1.80p-148
  },
  { // Entry 76
    0.0,
    -0x1.fffffep127,
    -0x1.fffffep127
  },
  { // Entry 77
    0.0,
    0x1.fffffep127,
    0x1.fffffep127
  },
  { // Entry 78
    0.0,
    -0x1.p-149,
    -0x1.p-149
  },
  { // Entry 79
    0.0,
    0x1.p-149,
    0x1.p-149
  },
  { // Entry 80
    0x1.p-148,
    0x1.p-149,
    -0x1.p-149
  },
  { // Entry 81
    0x1.fffffep127,
    0x1.fffffep127,
    -0x1.p-149
  },
  { // Entry 82
    0x1.fffffep127,
    0x1.fffffep127,
    0.0
  },
  { // Entry 83
    0x1.fffffdffffffffffffffffffffffffffp127,
    0x1.fffffep127,
    0x1.p-149
  },
  { // Entry 84
    0.0,
    -0x1.p-149,
    0x1.fffffep127
  },
  { // Entry 85
    0.0,
    0.0,
    0x1.fffffep127
  },
  { // Entry 86
    0.0,
    0x1.p-149,
    0x1.fffffep127
  },
  { // Entry 87
    0x1.fffffep127,
    0x1.fffffep126,
    -0x1.fffffep126
  },
  { // Entry 88
    0.0,
    0x1.fffff8p-128,
    0x1.fffff8p-128
  },
  { // Entry 89
    0.0,
    0x1.fffff8p-128,
    0x1.p-127
  },
  { // Entry 90
    0.0,
    0x1.fffff8p-128,
    0x1.000004p-127
  },
  { // Entry 91
    0x1.p-149,
    0x1.p-127,
    0x1.fffff8p-128
  },
  { // Entry 92
    0.0,
    0x1.p-127,
    0x1.p-127
  },
  { // Entry 93
    0.0,
    0x1.p-127,
    0x1.000004p-127
  },
  { // Entry 94
    0x1.p-148,
    0x1.000004p-127,
    0x1.fffff8p-128
  },
  { // Entry 95
    0x1.p-149,
    0x1.000004p-127,
    0x1.p-127
  },
  { // Entry 96
    0.0,
    0x1.000004p-127,
    0x1.000004p-127
  },
  { // Entry 97
    0.0,
    0x1.fffffep-51,
    0x1.fffffep-51
  },
  { // Entry 98
    0.0,
    0x1.fffffep-51,
    0x1.p-50
  },
  { // Entry 99
    0.0,
    0x1.fffffep-51,
    0x1.000002p-50
  },
  { // Entry 100
    0x1.p-74,
    0x1.p-50,
    0x1.fffffep-51
  },
  { // Entry 101
    0.0,
    0x1.p-50,
    0x1.p-50
  },
  { // Entry 102
    0.0,
    0x1.p-50,
    0x1.000002p-50
  },
  { // Entry 103
    0x1.80p-73,
    0x1.000002p-50,
    0x1.fffffep-51
  },
  { // Entry 104
    0x1.p-73,
    0x1.000002p-50,
    0x1.p-50
  },
  { // Entry 105
    0.0,
    0x1.000002p-50,
    0x1.000002p-50
  },
  { // Entry 106
    0.0,
    0x1.fffffep-11,
    0x1.fffffep-11
  },
  { // Entry 107
    0.0,
    0x1.fffffep-11,
    0x1.p-10
  },
  { // Entry 108
    0.0,
    0x1.fffffep-11,
    0x1.000002p-10
  },
  { // Entry 109
    0x1.p-34,
    0x1.p-10,
    0x1.fffffep-11
  },
  { // Entry 110
    0.0,
    0x1.p-10,
    0x1.p-10
  },
  { // Entry 111
    0.0,
    0x1.p-10,
    0x1.000002p-10
  },
  { // Entry 112
    0x1.80p-33,
    0x1.000002p-10,
    0x1.fffffep-11
  },
  { // Entry 113
    0x1.p-33,
    0x1.000002p-10,
    0x1.p-10
  },
  { // Entry 114
    0.0,
    0x1.000002p-10,
    0x1.000002p-10
  },
  { // Entry 115
    0.0,
    0x1.fffffep-2,
    0x1.fffffep-2
  },
  { // Entry 116
    0.0,
    0x1.fffffep-2,
    0x1.p-1
  },
  { // Entry 117
    0.0,
    0x1.fffffep-2,
    0x1.000002p-1
  },
  { // Entry 118
    0x1.p-25,
    0x1.p-1,
    0x1.fffffep-2
  },
  { // Entry 119
    0.0,
    0x1.p-1,
    0x1.p-1
  },
  { // Entry 120
    0.0,
    0x1.p-1,
    0x1.000002p-1
  },
  { // Entry 121
    0x1.80p-24,
    0x1.000002p-1,
    0x1.fffffep-2
  },
  { // Entry 122
    0x1.p-24,
    0x1.000002p-1,
    0x1.p-1
  },
  { // Entry 123
    0.0,
    0x1.000002p-1,
    0x1.000002p-1
  },
  { // Entry 124
    0.0,
    0x1.fffffep0,
    0x1.fffffep0
  },
  { // Entry 125
    0.0,
    0x1.fffffep0,
    0x1.p1
  },
  { // Entry 126
    0.0,
    0x1.fffffep0,
    0x1.000002p1
  },
  { // Entry 127
    0x1.p-23,
    0x1.p1,
    0x1.fffffep0
  },
  { // Entry 128
    0.0,
    0x1.p1,
    0x1.p1
  },
  { // Entry 129
    0.0,
    0x1.p1,
    0x1.000002p1
  },
  { // Entry 130
    0x1.80p-22,
    0x1.000002p1,
    0x1.fffffep0
  },
  { // Entry 131
    0x1.p-22,
    0x1.000002p1,
    0x1.p1
  },
  { // Entry 132
    0.0,
    0x1.000002p1,
    0x1.000002p1
  },
  { // Entry 133
    0.0,
    0x1.fffffep9,
    0x1.fffffep9
  },
  { // Entry 134
    0.0,
    0x1.fffffep9,
    0x1.p10
  },
  { // Entry 135
    0.0,
    0x1.fffffep9,
    0x1.000002p10
  },
  { // Entry 136
    0x1.p-14,
    0x1.p10,
    0x1.fffffep9
  },
  { // Entry 137
    0.0,
    0x1.p10,
    0x1.p10
  },
  { // Entry 138
    0.0,
    0x1.p10,
    0x1.000002p10
  },
  { // Entry 139
    0x1.80p-13,
    0x1.000002p10,
    0x1.fffffep9
  },
  { // Entry 140
    0x1.p-13,
    0x1.000002p10,
    0x1.p10
  },
  { // Entry 141
    0.0,
    0x1.000002p10,
    0x1.000002p10
  },
  { // Entry 142
    0.0,
    0x1.fffffep49,
    0x1.fffffep49
  },
  { // Entry 143
    0.0,
    0x1.fffffep49,
    0x1.p50
  },
  { // Entry 144
    0.0,
    0x1.fffffep49,
    0x1.000002p50
  },
  { // Entry 145
    0x1.p26,
    0x1.p50,
    0x1.fffffep49
  },
  { // Entry 146
    0.0,
    0x1.p50,
    0x1.p50
  },
  { // Entry 147
    0.0,
    0x1.p50,
    0x1.000002p50
  },
  { // Entry 148
    0x1.80p27,
    0x1.000002p50,
    0x1.fffffep49
  },
  { // Entry 149
    0x1.p27,
    0x1.000002p50,
    0x1.p50
  },
  { // Entry 150
    0.0,
    0x1.000002p50,
    0x1.000002p50
  },
  { // Entry 151
    0.0,
    0x1.fffffep126,
    0x1.fffffep126
  },
  { // Entry 152
    0.0,
    0x1.fffffep126,
    0x1.p127
  },
  { // Entry 153
    0.0,
    0x1.fffffep126,
    0x1.000002p127
  },
  { // Entry 154
    0x1.p103,
    0x1.p127,
    0x1.fffffep126
  },
  { // Entry 155
    0.0,
    0x1.p127,
    0x1.p127
  },
  { // Entry 156
    0.0,
    0x1.p127,
    0x1.000002p127
  },
  { // Entry 157
    0x1.80p104,
    0x1.000002p127,
    0x1.fffffep126
  },
  { // Entry 158
    0x1.p104,
    0x1.000002p127,
    0x1.p127
  },
  { // Entry 159
    0.0,
    0x1.000002p127,
    0x1.000002p127
  },
  { // Entry 160
    0.0,
    HUGE_VALF,
    HUGE_VALF
  },
  { // Entry 161
    HUGE_VALF,
    HUGE_VALF,
    0x1.fffffep127
  },
  { // Entry 162
    HUGE_VALF,
    HUGE_VALF,
    0x1.p-126
  },
  { // Entry 163
    HUGE_VALF,
    HUGE_VALF,
    0x1.fffffcp-127
  },
  { // Entry 164
    HUGE_VALF,
    HUGE_VALF,
    0x1.p-149
  },
  { // Entry 165
    HUGE_VALF,
    HUGE_VALF,
    0.0f
  },
  { // Entry 166
    HUGE_VALF,
    HUGE_VALF,
    -0.0f
  },
  { // Entry 167
    HUGE_VALF,
    HUGE_VALF,
    -0x1.p-149
  },
  { // Entry 168
    HUGE_VALF,
    HUGE_VALF,
    -0x1.fffffcp-127
  },
  { // Entry 169
    HUGE_VALF,
    HUGE_VALF,
    -0x1.p-126
  },
  { // Entry 170
    HUGE_VALF,
    HUGE_VALF,
    -0x1.p0
  },
  { // Entry 171
    HUGE_VALF,
    HUGE_VALF,
    -0x1.fffffep127
  },
  { // Entry 172
    HUGE_VALF,
    HUGE_VALF,
    -HUGE_VALF
  },
  { // Entry 173
    0.0,
    0x1.fffffep127,
    HUGE_VALF
  },
  { // Entry 174
    0.0,
    0x1.fffffep127,
    0x1.fffffep127
  },
  { // Entry 175
    0x1.fffffdffffffffffffffffffffffffffp127,
    0x1.fffffep127,
    0x1.p-126
  },
  { // Entry 176
    0x1.fffffdffffffffffffffffffffffffffp127,
    0x1.fffffep127,
    0x1.fffffcp-127
  },
  { // Entry 177
    0x1.fffffdffffffffffffffffffffffffffp127,
    0x1.fffffep127,
    0x1.p-149
  },
  { // Entry 178
    0x1.fffffep127,
    0x1.fffffep127,
    0.0f
  },
  { // Entry 179
    0x1.fffffep127,
    0x1.fffffep127,
    -0.0f
  },
  { // Entry 180
    0x1.fffffep127,
    0x1.fffffep127,
    -0x1.p-149
  },
  { // Entry 181
    0x1.fffffep127,
    0x1.fffffep127,
    -0x1.fffffcp-127
  },
  { // Entry 182
    0x1.fffffep127,
    0x1.fffffep127,
    -0x1.p-126
  },
  { // Entry 183
    0x1.fffffe00000000000000000000000002p127,
    0x1.fffffep127,
    -0x1.p0
  },
  { // Entry 184
    HUGE_VALF,
    0x1.fffffep127,
    -0x1.fffffep127
  },
  { // Entry 185
    HUGE_VALF,
    0x1.fffffep127,
    -HUGE_VALF
  },
  { // Entry 186
    0.0,
    0x1.p-126,
    HUGE_VALF
  },
  { // Entry 187
    0.0,
    0x1.p-126,
    0x1.fffffep127
  },
  { // Entry 188
    0.0,
    0x1.p-126,
    0x1.p-126
  },
  { // Entry 189
    0x1.p-149,
    0x1.p-126,
    0x1.fffffcp-127
  },
  { // Entry 190
    0x1.fffffcp-127,
    0x1.p-126,
    0x1.p-149
  },
  { // Entry 191
    0x1.p-126,
    0x1.p-126,
    0.0f
  },
  { // Entry 192
    0x1.p-126,
    0x1.p-126,
    -0.0f
  },
  { // Entry 193
    0x1.000002p-126,
    0x1.p-126,
    -0x1.p-149
  },
  { // Entry 194
    0x1.fffffep-126,
    0x1.p-126,
    -0x1.fffffcp-127
  },
  { // Entry 195
    0x1.p-125,
    0x1.p-126,
    -0x1.p-126
  },
  { // Entry 196
    0x1.00000000000000000000000000000004p0,
    0x1.p-126,
    -0x1.p0
  },
  { // Entry 197
    0x1.fffffep127,
    0x1.p-126,
    -0x1.fffffep127
  },
  { // Entry 198
    HUGE_VALF,
    0x1.p-126,
    -HUGE_VALF
  },
  { // Entry 199
    0.0,
    0x1.fffffcp-127,
    HUGE_VALF
  },
  { // Entry 200
    0.0,
    0x1.fffffcp-127,
    0x1.fffffep127
  },
  { // Entry 201
    0.0,
    0x1.fffffcp-127,
    0x1.p-126
  },
  { // Entry 202
    0.0,
    0x1.fffffcp-127,
    0x1.fffffcp-127
  },
  { // Entry 203
    0x1.fffff8p-127,
    0x1.fffffcp-127,
    0x1.p-149
  },
  { // Entry 204
    0x1.fffffcp-127,
    0x1.fffffcp-127,
    0.0f
  },
  { // Entry 205
    0x1.fffffcp-127,
    0x1.fffffcp-127,
    -0.0f
  },
  { // Entry 206
    0x1.p-126,
    0x1.fffffcp-127,
    -0x1.p-149
  },
  { // Entry 207
    0x1.fffffcp-126,
    0x1.fffffcp-127,
    -0x1.fffffcp-127
  },
  { // Entry 208
    0x1.fffffep-126,
    0x1.fffffcp-127,
    -0x1.p-126
  },
  { // Entry 209
    0x1.00000000000000000000000000000003p0,
    0x1.fffffcp-127,
    -0x1.p0
  },
  { // Entry 210
    0x1.fffffep127,
    0x1.fffffcp-127,
    -0x1.fffffep127
  },
  { // Entry 211
    HUGE_VALF,
    0x1.fffffcp-127,
    -HUGE_VALF
  },
  { // Entry 212
    0.0,
    0x1.p-149,
    HUGE_VALF
  },
  { // Entry 213
    0.0,
    0x1.p-149,
    0x1.fffffep127
  },
  { // Entry 214
    0.0,
    0x1.p-149,
    0x1.p-126
  },
  { // Entry 215
    0.0,
    0x1.p-149,
    0x1.fffffcp-127
  },
  { // Entry 216
    0.0,
    0x1.p-149,
    0x1.p-149
  },
  { // Entry 217
    0x1.p-149,
    0x1.p-149,
    0.0f
  },
  { // Entry 218
    0x1.p-149,
    0x1.p-149,
    -0.0f
  },
  { // Entry 219
    0x1.p-148,
    0x1.p-149,
    -0x1.p-149
  },
  { // Entry 220
    0x1.p-126,
    0x1.p-149,
    -0x1.fffffcp-127
  },
  { // Entry 221
    0x1.000002p-126,
    0x1.p-149,
    -0x1.p-126
  },
  { // Entry 222
    0x1.p0,
    0x1.p-149,
    -0x1.p0
  },
  { // Entry 223
    0x1.fffffep127,
    0x1.p-149,
    -0x1.fffffep127
  },
  { // Entry 224
    HUGE_VALF,
    0x1.p-149,
    -HUGE_VALF
  },
  { // Entry 225
    0.0,
    0.0f,
    HUGE_VALF
  },
  { // Entry 226
    0.0,
    0.0f,
    0x1.fffffep127
  },
  { // Entry 227
    0.0,
    0.0f,
    0x1.p-126
  },
  { // Entry 228
    0.0,
    0.0f,
    0x1.fffffcp-127
  },
  { // Entry 229
    0.0,
    0.0f,
    0x1.p-149
  },
  { // Entry 230
    0.0,
    0.0f,
    0.0f
  },
  { // Entry 231
    0.0,
    0.0f,
    -0.0f
  },
  { // Entry 232
    0x1.p-149,
    0.0f,
    -0x1.p-149
  },
  { // Entry 233
    0x1.fffffcp-127,
    0.0f,
    -0x1.fffffcp-127
  },
  { // Entry 234
    0x1.p-126,
    0.0f,
    -0x1.p-126
  },
  { // Entry 235
    0x1.p0,
    0.0f,
    -0x1.p0
  },
  { // Entry 236
    0x1.fffffep127,
    0.0f,
    -0x1.fffffep127
  },
  { // Entry 237
    HUGE_VALF,
    0.0f,
    -HUGE_VALF
  },
  { // Entry 238
    0.0,
    -0.0f,
    HUGE_VALF
  },
  { // Entry 239
    0.0,
    -0.0f,
    0x1.fffffep127
  },
  { // Entry 240
    0.0,
    -0.0f,
    0x1.p-126
  },
  { // Entry 241
    0.0,
    -0.0f,
    0x1.fffffcp-127
  },
  { // Entry 242
    0.0,
    -0.0f,
    0x1.p-149
  },
  { // Entry 243
    0.0,
    -0.0f,
    0.0f
  },
  { // Entry 244
    0.0,
    -0.0f,
    -0.0f
  },
  { // Entry 245
    0x1.p-149,
    -0.0f,
    -0x1.p-149
  },
  { // Entry 246
    0x1.fffffcp-127,
    -0.0f,
    -0x1.fffffcp-127
  },
  { // Entry 247
    0x1.p-126,
    -0.0f,
    -0x1.p-126
  },
  { // Entry 248
    0x1.p0,
    -0.0f,
    -0x1.p0
  },
  { // Entry 249
    0x1.fffffep127,
    -0.0f,
    -0x1.fffffep127
  },
  { // Entry 250
    HUGE_VALF,
    -0.0f,
    -HUGE_VALF
  },
  { // Entry 251
    0.0,
    -0x1.p-149,
    HUGE_VALF
  },
  { // Entry 252
    0.0,
    -0x1.p-149,
    0x1.fffffep127
  },
  { // Entry 253
    0.0,
    -0x1.p-149,
    0x1.p-126
  },
  { // Entry 254
    0.0,
    -0x1.p-149,
    0x1.fffffcp-127
  },
  { // Entry 255
    0.0,
    -0x1.p-149,
    0x1.p-149
  },
  { // Entry 256
    0.0,
    -0x1.p-149,
    0.0f
  },
  { // Entry 257
    0.0,
    -0x1.p-149,
    -0.0f
  },
  { // Entry 258
    0.0,
    -0x1.p-149,
    -0x1.p-149
  },
  { // Entry 259
    0x1.fffff8p-127,
    -0x1.p-149,
    -0x1.fffffcp-127
  },
  { // Entry 260
    0x1.fffffcp-127,
    -0x1.p-149,
    -0x1.p-126
  },
  { // Entry 261
    0x1.ffffffffffffffffffffffffffffffffp-1,
    -0x1.p-149,
    -0x1.p0
  },
  { // Entry 262
    0x1.fffffdffffffffffffffffffffffffffp127,
    -0x1.p-149,
    -0x1.fffffep127
  },
  { // Entry 263
    HUGE_VALF,
    -0x1.p-149,
    -HUGE_VALF
  },
  { // Entry 264
    0.0,
    -0x1.fffffcp-127,
    HUGE_VALF
  },
  { // Entry 265
    0.0,
    -0x1.fffffcp-127,
    0x1.fffffep127
  },
  { // Entry 266
    0.0,
    -0x1.fffffcp-127,
    0x1.p-126
  },
  { // Entry 267
    0.0,
    -0x1.fffffcp-127,
    0x1.fffffcp-127
  },
  { // Entry 268
    0.0,
    -0x1.fffffcp-127,
    0x1.p-149
  },
  { // Entry 269
    0.0,
    -0x1.fffffcp-127,
    0.0f
  },
  { // Entry 270
    0.0,
    -0x1.fffffcp-127,
    -0.0f
  },
  { // Entry 271
    0.0,
    -0x1.fffffcp-127,
    -0x1.p-149
  },
  { // Entry 272
    0.0,
    -0x1.fffffcp-127,
    -0x1.fffffcp-127
  },
  { // Entry 273
    0x1.p-149,
    -0x1.fffffcp-127,
    -0x1.p-126
  },
  { // Entry 274
    0x1.fffffffffffffffffffffffffffffff8p-1,
    -0x1.fffffcp-127,
    -0x1.p0
  },
  { // Entry 275
    0x1.fffffdffffffffffffffffffffffffffp127,
    -0x1.fffffcp-127,
    -0x1.fffffep127
  },
  { // Entry 276
    HUGE_VALF,
    -0x1.fffffcp-127,
    -HUGE_VALF
  },
  { // Entry 277
    0.0,
    -0x1.p-126,
    HUGE_VALF
  },
  { // Entry 278
    0.0,
    -0x1.p-126,
    0x1.fffffep127
  },
  { // Entry 279
    0.0,
    -0x1.p-126,
    0x1.p-126
  },
  { // Entry 280
    0.0,
    -0x1.p-126,
    0x1.fffffcp-127
  },
  { // Entry 281
    0.0,
    -0x1.p-126,
    0x1.p-149
  },
  { // Entry 282
    0.0,
    -0x1.p-126,
    0.0f
  },
  { // Entry 283
    0.0,
    -0x1.p-126,
    -0.0f
  },
  { // Entry 284
    0.0,
    -0x1.p-126,
    -0x1.p-149
  },
  { // Entry 285
    0.0,
    -0x1.p-126,
    -0x1.fffffcp-127
  },
  { // Entry 286
    0.0,
    -0x1.p-126,
    -0x1.p-126
  },
  { // Entry 287
    0x1.fffffffffffffffffffffffffffffff8p-1,
    -0x1.p-126,
    -0x1.p0
  },
  { // Entry 288
    0x1.fffffdffffffffffffffffffffffffffp127,
    -0x1.p-126,
    -0x1.fffffep127
  },
  { // Entry 289
    HUGE_VALF,
    -0x1.p-126,
    -HUGE_VALF
  },
  { // Entry 290
    0.0,
    -0x1.fffffep-1,
    HUGE_VALF
  },
  { // Entry 291
    0.0,
    -0x1.fffffep-1,
    0x1.fffffep127
  },
  { // Entry 292
    0.0,
    -0x1.fffffep-1,
    0x1.p-126
  },
  { // Entry 293
    0.0,
    -0x1.fffffep-1,
    0x1.fffffcp-127
  },
  { // Entry 294
    0.0,
    -0x1.fffffep-1,
    0x1.p-149
  },
  { // Entry 295
    0.0,
    -0x1.fffffep-1,
    0.0f
  },
  { // Entry 296
    0.0,
    -0x1.fffffep-1,
    -0.0f
  },
  { // Entry 297
    0.0,
    -0x1.fffffep-1,
    -0x1.p-149
  },
  { // Entry 298
    0.0,
    -0x1.fffffep-1,
    -0x1.fffffcp-127
  },
  { // Entry 299
    0.0,
    -0x1.fffffep-1,
    -0x1.p-126
  },
  { // Entry 300
    0x1.p-24,
    -0x1.fffffep-1,
    -0x1.p0
  },
  { // Entry 301
    0x1.fffffdfffffffffffffffffffffffffep127,
    -0x1.fffffep-1,
    -0x1.fffffep127
  },
  { // Entry 302
    HUGE_VALF,
    -0x1.fffffep-1,
    -HUGE_VALF
  },
  { // Entry 303
    0.0,
    -0x1.p0,
    HUGE_VALF
  },
  { // Entry 304
    0.0,
    -0x1.p0,
    0x1.fffffep127
  },
  { // Entry 305
    0.0,
    -0x1.p0,
    0x1.p-126
  },
  { // Entry 306
    0.0,
    -0x1.p0,
    0x1.fffffcp-127
  },
  { // Entry 307
    0.0,
    -0x1.p0,
    0x1.p-149
  },
  { // Entry 308
    0.0,
    -0x1.p0,
    0.0f
  },
  { // Entry 309
    0.0,
    -0x1.p0,
    -0.0f
  },
  { // Entry 310
    0.0,
    -0x1.p0,
    -0x1.p-149
  },
  { // Entry 311
    0.0,
    -0x1.p0,
    -0x1.fffffcp-127
  },
  { // Entry 312
    0.0,
    -0x1.p0,
    -0x1.p-126
  },
  { // Entry 313
    0.0,
    -0x1.p0,
    -0x1.p0
  },
  { // Entry 314
    0x1.fffffdfffffffffffffffffffffffffep127,
    -0x1.p0,
    -0x1.fffffep127
  },
  { // Entry 315
    HUGE_VALF,
    -0x1.p0,
    -HUGE_VALF
  },
  { // Entry 316
    0.0,
    -0x1.000002p0,
    HUGE_VALF
  },
  { // Entry 317
    0.0,
    -0x1.000002p0,
    0x1.fffffep127
  },
  { // Entry 318
    0.0,
    -0x1.000002p0,
    0x1.p-126
  },
  { // Entry 319
    0.0,
    -0x1.000002p0,
    0x1.fffffcp-127
  },
  { // Entry 320
    0.0,
    -0x1.000002p0,
    0x1.p-149
  },
  { // Entry 321
    0.0,
    -0x1.000002p0,
    0.0f
  },
  { // Entry 322
    0.0,
    -0x1.000002p0,
    -0.0f
  },
  { // Entry 323
    0.0,
    -0x1.000002p0,
    -0x1.p-149
  },
  { // Entry 324
    0.0,
    -0x1.000002p0,
    -0x1.fffffcp-127
  },
  { // Entry 325
    0.0,
    -0x1.000002p0,
    -0x1.p-126
  },
  { // Entry 326
    0.0,
    -0x1.000002p0,
    -0x1.p0
  },
  { // Entry 327
    0x1.fffffdfffffffffffffffffffffffffdp127,
    -0x1.000002p0,
    -0x1.fffffep127
  },
  { // Entry 328
    HUGE_VALF,
    -0x1.000002p0,
    -HUGE_VALF
  },
  { // Entry 329
    0.0,
    -0x1.fffffep127,
    HUGE_VALF
  },
  { // Entry 330
    0.0,
    -0x1.fffffep127,
    0x1.fffffep127
  },
  { // Entry 331
    0.0,
    -0x1.fffffep127,
    0x1.p-126
  },
  { // Entry 332
    0.0,
    -0x1.fffffep127,
    0x1.fffffcp-127
  },
  { // Entry 333
    0.0,
    -0x1.fffffep127,
    0x1.p-149
  },
  { // Entry 334
    0.0,
    -0x1.fffffep127,
    0.0f
  },
  { // Entry 335
    0.0,
    -0x1.fffffep127,
    -0.0f
  },
  { // Entry 336
    0.0,
    -0x1.fffffep127,
    -0x1.p-149
  },
  { // Entry 337
    0.0,
    -0x1.fffffep127,
    -0x1.fffffcp-127
  },
  { // Entry 338
    0.0,
    -0x1.fffffep127,
    -0x1.p-126
  },
  { // Entry 339
    0.0,
    -0x1.fffffep127,
    -0x1.p0
  },
  { // Entry 340
    0.0,
    -0x1.fffffep127,
    -0x1.fffffep127
  },
  { // Entry 341
    HUGE_VALF,
    -0x1.fffffep127,
    -HUGE_VALF
  },
  { // Entry 342
    0.0,
    -HUGE_VALF,
    HUGE_VALF
  },
  { // Entry 343
    0.0,
    -HUGE_VALF,
    0x1.fffffep127
  },
  { // Entry 344
    0.0,
    -HUGE_VALF,
    0x1.p-126
  },
  { // Entry 345
    0.0,
    -HUGE_VALF,
    0x1.fffffcp-127
  },
  { // Entry 346
    0.0,
    -HUGE_VALF,
    0x1.p-149
  },
  { // Entry 347
    0.0,
    -HUGE_VALF,
    0.0f
  },
  { // Entry 348
    0.0,
    -HUGE_VALF,
    -0.0f
  },
  { // Entry 349
    0.0,
    -HUGE_VALF,
    -0x1.p-149
  },
  { // Entry 350
    0.0,
    -HUGE_VALF,
    -0x1.fffffcp-127
  },
  { // Entry 351
    0.0,
    -HUGE_VALF,
    -0x1.p-126
  },
  { // Entry 352
    0.0,
    -HUGE_VALF,
    -0x1.p0
  },
  { // Entry 353
    0.0,
    -HUGE_VALF,
    -0x1.fffffep127
  },
  { // Entry 354
    0.0,
    -HUGE_VALF,
    -HUGE_VALF
  }
};
