/*
 * Copyright (C) 2016 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

public class Main {
  public static void main(String[] args) throws Exception {
    System.loadLibrary(args[0]);
    // Loop enough to get Itf.foo JITed.
    for (int i = 0; i < 100000; i++) {
      Itf.foo(new Object());
    }

    ensureJitCompiled(Itf.class, "foo");

    if (!Itf.foo(new Object())) {
      throw new Error("Unexpected result");
    }
  }

  private static native void ensureJitCompiled(Class itf, String method_name);
}

interface Itf {
  public static boolean foo(Object o) {
    return o.equals(o);
  }
}
