/*
 * Copyright (c) 2012, ToshiakiAsazuma All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * ERedistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  
 * ERedistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation
 *  and/or other materials provided with the distribution.
 *  
 * ENeither the name of the ToshiakiAsazuma nor the names of its contributors
 *  may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *  
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 *  OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 *  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 *  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 *  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.sourceforge.android_ab.addressbook.history.adapter;

import java.util.List;

import jp.sourceforge.android_ab.addressbook.R;
import jp.sourceforge.android_ab.addressbook.common.adapter.ListAdapter;
import jp.sourceforge.android_ab.addressbook.history.data.ContactHistoryDataBean;
import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

public class ContactHistoryListDataAdapter extends ListAdapter<ContactHistoryDataBean> {

	public ContactHistoryListDataAdapter(Context context) {
		super(context);
	}

	public ContactHistoryListDataAdapter(Context context,
			List<ContactHistoryDataBean> dataList) {
		super(context, dataList);
	}

	public View getView(int position, View convertView, ViewGroup parent) {
		Log.d("jp.sourceforge.android_ab.addressbook.history", "ContactHistoryListDataAdapter#getView: start");
		
		LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		View row = (View) inflater.inflate(R.layout.historylistrow, null);
		
		ContactHistoryDataBean bean = (ContactHistoryDataBean) getItem(position);
		
		TextView displayName = (TextView) row.findViewById(R.id.displayName);
		displayName.setText(bean.getName());
		
		TextView displayNumber = (TextView) row.findViewById(R.id.otherInfo);
		displayNumber.setText(bean.getNumber());
		
		Log.d("jp.sourceforge.android_ab.addressbook.history", "ContactHistoryListDataAdapter#getView: end");
		return row;
	}
}
