package jp.sourceforge.android_ab.addressbook.common.helper;

import jp.sourceforge.android_ab.addressbook.common.data.ContactDetailDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.EmailDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.ImDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.PhoneDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.StructuredNameDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.impl.ContactDetailDataElementImpl;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract.CommonDataKinds.Email;
import android.provider.ContactsContract.CommonDataKinds.Event;
import android.provider.ContactsContract.CommonDataKinds.GroupMembership;
import android.provider.ContactsContract.CommonDataKinds.Im;
import android.provider.ContactsContract.CommonDataKinds.Nickname;
import android.provider.ContactsContract.CommonDataKinds.Note;
import android.provider.ContactsContract.CommonDataKinds.Organization;
import android.provider.ContactsContract.CommonDataKinds.Phone;
import android.provider.ContactsContract.CommonDataKinds.Photo;
import android.provider.ContactsContract.CommonDataKinds.Relation;
import android.provider.ContactsContract.CommonDataKinds.SipAddress;
import android.provider.ContactsContract.CommonDataKinds.StructuredName;
import android.provider.ContactsContract.CommonDataKinds.StructuredPostal;
import android.provider.ContactsContract.CommonDataKinds.Website;
import android.provider.ContactsContract.Data;
import android.util.Log;

public class ContactDetailDataHelper extends ContactDataHelper {
	public ContactDetailDataHelper(Context context) {
		super(context);
	}

	public ContactDetailDataElement findLookupUri(Uri lookupUri) {
		ContactDetailDataElementImpl result = new ContactDetailDataElementImpl();
		
		Cursor cursor = getContext().getContentResolver().query(lookupUri, null, null, null, null);
		cursor.moveToFirst();
		
		loadContactData(cursor, result);
		
		loadExtraInfo(result);
		
		return result;
	}
	
	private void loadExtraInfo(ContactDetailDataElement element) {
		Uri uri = Data.CONTENT_URI;
		String selection = Data.CONTACT_ID + " = ? ";
		String[] selectionArgs = new String[] {String.valueOf(element.getId())};
		
		Cursor cursor = getContext().getContentResolver().query(uri, null, selection, selectionArgs, null);
		
		while(cursor.moveToNext()) {
			dispatchDetailData(cursor, element);
		}
	}
	
	private void dispatchDetailData(Cursor row, ContactDetailDataElement element) {
		String mimeType = row.getString(row.getColumnIndex(Data.MIMETYPE));
		Log.d(getClass().getName(), "dispatchDetailData: mimeType: " + mimeType);
		if(StructuredName.CONTENT_ITEM_TYPE.equals(mimeType)) {
			StructuredNameDataElement nameData = new StructuredNameDataElement();
			nameData.setDisplayName(row.getString(row.getColumnIndex(StructuredName.DISPLAY_NAME)));
			nameData.setFamilyName(row.getString(row.getColumnIndex(StructuredName.FAMILY_NAME)));
			nameData.setMiddleName(row.getString(row.getColumnIndex(StructuredName.MIDDLE_NAME)));
			nameData.setGivenName(row.getString(row.getColumnIndex(StructuredName.GIVEN_NAME)));
			nameData.setPrefix(row.getString(row.getColumnIndex(StructuredName.PREFIX)));
			nameData.setSuffix(row.getString(row.getColumnIndex(StructuredName.SUFFIX)));
			nameData.setPhoneticFamilyName(row.getString(row.getColumnIndex(StructuredName.PHONETIC_FAMILY_NAME)));
			nameData.setPhoneticMiddleName(row.getString(row.getColumnIndex(StructuredName.PHONETIC_MIDDLE_NAME)));
			nameData.setPhoneticMiddleName(row.getString(row.getColumnIndex(StructuredName.PHONETIC_GIVEN_NAME)));

			element.addStructuredName(nameData);
		} else if(Phone.CONTENT_ITEM_TYPE.equals(mimeType)) {
			PhoneDataElement phoneData = new PhoneDataElement();
			phoneData.setNumber(row.getString(row.getColumnIndex(Phone.NUMBER)));
			phoneData.setType(row.getInt(row.getColumnIndex(Phone.TYPE)));
			phoneData.setLabel(row.getString(row.getColumnIndex(Phone.LABEL)));
			
			element.addPhone(phoneData);
		} else if(Email.CONTENT_ITEM_TYPE.equals(mimeType)) {
			EmailDataElement emailData = new EmailDataElement();
			emailData.setAddress(row.getString(row.getColumnIndex(Email.ADDRESS)));
			emailData.setType(row.getInt(row.getColumnIndex(Email.TYPE)));
			emailData.setLabel(row.getString(row.getColumnIndex(Email.LABEL)));
			
			element.addEmail(emailData);
		} else if(Photo.CONTENT_ITEM_TYPE.equals(mimeType)) {
			
		} else if(Organization.CONTENT_ITEM_TYPE.equals(mimeType)) {
			
		} else if(Im.CONTENT_ITEM_TYPE.equals(mimeType)) {
			ImDataElement imData = new ImDataElement();
			imData.setData(row.getString(row.getColumnIndex(Im.DATA)));
			imData.setType(row.getInt(row.getColumnIndex(Im.TYPE)));
			imData.setLabel(row.getString(row.getColumnIndex(Im.LABEL)));
			imData.setProtocol(row.getString(row.getColumnIndex(Im.PROTOCOL)));
			imData.setCustomProtocol(row.getString(row.getColumnIndex(Im.CUSTOM_PROTOCOL)));
			
			element.addIm(imData);
		} else if(Nickname.CONTENT_ITEM_TYPE.equals(mimeType)) {
			
		} else if(Note.CONTENT_ITEM_TYPE.equals(mimeType)) {
			
		} else if(StructuredPostal.CONTENT_ITEM_TYPE.equals(mimeType)) {
			
		} else if(GroupMembership.CONTENT_ITEM_TYPE.equals(mimeType)) {
			
		} else if(Website.CONTENT_ITEM_TYPE.equals(mimeType)) {
			
		} else if(Event.CONTENT_ITEM_TYPE.equals(mimeType)) {
			
		} else if(Relation.CONTENT_ITEM_TYPE.equals(mimeType)) {
			
		} else if(SipAddress.CONTENT_ITEM_TYPE.equals(mimeType)) {
			
		} else {
			Log.d(getClass().getName(), "dispatchDetailData: illegal mimeType: " + mimeType);
		}
	}

}
