package jp.sourceforge.android_ab.addressbook.groupaddresslist.adapter;

import java.util.List;

import jp.sourceforge.android_ab.addressbook.common.data.GroupDataElement;
import jp.sourceforge.android_ab.addressbook.groupaddresslist.view.GroupAddressListFragment;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;

public class GroupListFragmentAdapter extends FragmentStatePagerAdapter {
	private List<GroupDataElement> groupList;
	public GroupListFragmentAdapter(FragmentManager fm, List<GroupDataElement> groupList) {
		super(fm);
		this.groupList = groupList;
	}

	@Override
	public Fragment getItem(int position) {
		return GroupAddressListFragment.newInstance(groupList.get(position));
	}

	@Override
	public int getCount() {
		return groupList.size();
	}

}
