package jp.sourceforge.android_ab.addressbook.contactdetail.adapter;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.android_ab.addressbook.R;
import jp.sourceforge.android_ab.addressbook.common.data.ContactDetailDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.ContactDetailSimpleViewElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.EmailDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.ImDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.detail.PhoneDataElement;
import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

public class ContactDetailAdapter extends BaseAdapter {
	private Context context;
	
	private ContactDetailDataElement rootElement;
	
	private List<Object> itemList;
	
	public ContactDetailAdapter(Context context, ContactDetailDataElement element) {
		this.context = context;
		this.rootElement = element;
		
		initAdapter();
	}
	
	public int getCount() {
		return itemList.size();
	}

	public Object getItem(int arg0) {
		return itemList.get(arg0);
	}

	public long getItemId(int arg0) {
		// TODO ꂽ\bhEX^u
		return 0;
	}

	public View getView(int arg0, View arg1, ViewGroup arg2) {
		if (getItem(arg0) instanceof PhoneDataElement) {
			return getViewBySimpleView((ContactDetailSimpleViewElement) getItem(arg0));
		} else if(getItem(arg0) instanceof EmailDataElement) {
			return getViewBySimpleView((ContactDetailSimpleViewElement) getItem(arg0));
		} else if(getItem(arg0) instanceof ImDataElement) {
			
		} else if(getItem(arg0) instanceof ContactDetailHeaderElement) {
			return getViewByHeader((ContactDetailHeaderElement) getItem(arg0));
		}
		
		return null;
	}
	
	private void initAdapter() {
		itemList = new ArrayList<Object>();
		itemList.add(new ContactDetailHeaderElement("db"));
		Log.d(getClass().getName(), "phone count: " + rootElement.getPhone().size());
		itemList.addAll(rootElement.getPhone());
		itemList.add(new ContactDetailHeaderElement("["));
		Log.d(getClass().getName(), "email count: " + rootElement.getEmail().size());
		itemList.addAll(rootElement.getEmail());
//		itemList.add(new ContactDetailHeaderElement("bZW["));
		Log.d(getClass().getName(), "im count: " + rootElement.getIm().size());
//		itemList.addAll(rootElement.getIm());
	}
	
	private View getViewByHeader(ContactDetailHeaderElement element) {
		View titleView = inflate(R.layout.contact_detail_list_title);
		TextView title = (TextView) titleView.findViewById(R.id.detailInfoTitle);
		title.setText(element.getTitle());
		
		return titleView;
	}
	
	private View getViewBySimpleView(ContactDetailSimpleViewElement element) {
		View itemView = inflate(R.layout.contact_detail_list_simpleitem);
		TextView label = (TextView) itemView.findViewById(R.id.detailInfoLabel);
		TextView value = (TextView) itemView.findViewById(R.id.detailInfoValue);
		
		label.setText(element.getLabel());
		value.setText(element.getValue());
		
		return itemView;
	}
	
	private View inflate(int resource) {
		LayoutInflater inflate = LayoutInflater.from(context);
		return inflate.inflate(resource, null);
	}

}
