package jp.sourceforge.android_ab.addressbook.common.helper;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.android_ab.addressbook.common.data.AccountDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.ContactDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.GroupDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.impl.ContactDataElementImpl;
import jp.sourceforge.android_ab.addressbook.common.data.impl.GroupDataElementImpl;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract.CommonDataKinds.GroupMembership;
import android.provider.ContactsContract.Contacts;
import android.provider.ContactsContract.Data;
import android.provider.ContactsContract.Groups;
import android.provider.ContactsContract.RawContacts;
import android.util.Log;

public class GroupSearchDataHelper extends ContactDataHelper {

	public GroupSearchDataHelper(Context context) {
		super(context);
	}
	
	public List<GroupDataElement> getGroup(List<AccountDataElement> accountList) {
		List<GroupDataElement> resultGroupList = new ArrayList<GroupDataElement>();
		// O[vȂO[v
		GroupDataElementImpl defaultGroup = new GroupDataElementImpl(GroupDataElement.GROUP_TYPE_DEFAULT);
		defaultGroup.setTitle("o^");
		
		for(AccountDataElement account: accountList) {
			List<GroupDataElement> groupList = getGroup(account);
			
			// O[v݂ȂꍇAO[vȂO[vɒǉ
			if(groupList.isEmpty()) {
				defaultGroup.addAccount(account);
				continue;
			}
			
			// ȊȌꍇA擾O[vf[^ŃO[v𐶐
			for(GroupDataElement group: groupList) {
				GroupDataElementImpl groupImpl = (GroupDataElementImpl) group;
				groupImpl.addAccount(account);
			}
			
			resultGroupList.addAll(groupList);
		}
		
		resultGroupList.add(defaultGroup);
		
		return resultGroupList;

	}
	
	/**
	 * O[vꗗ̎擾
	 * @return
	 */
	public List<GroupDataElement> getGroup(AccountDataElement account) {
		ArrayList<GroupDataElement> resultList = new ArrayList<GroupDataElement>();
		String[] projection = new String[] {
				Groups._ID,
				Groups.ACCOUNT_NAME,
				Groups.ACCOUNT_TYPE,
				Groups.TITLE,
				Groups.NOTES,
				Groups.SYSTEM_ID,
				Groups.DELETED,
				Groups.GROUP_VISIBLE,
				Groups.SHOULD_SYNC
		};
		
		StringBuffer selectionBuffer = new StringBuffer();
		ArrayList<String> selectionArgs = new ArrayList<String>();

		selectionBuffer.append(Groups.DELETED + " = ? ");
		selectionArgs.add("0");

		selectionBuffer.append(" AND " + Groups.ACCOUNT_NAME + " = ? ");
		selectionBuffer.append(" AND " + Groups.ACCOUNT_TYPE + " = ? ");
		
		selectionArgs.add(account.getAccountName());
		selectionArgs.add(account.getAccountType());

		ContentResolver cr = getContext().getContentResolver();
		Cursor cursor = cr.query(Groups.CONTENT_URI, projection, selectionBuffer.toString(), selectionArgs.toArray(new String[0]), null);
		
		while(cursor.moveToNext()) {
			GroupDataElementImpl data = new GroupDataElementImpl(GroupDataElement.GROUP_TYPE_NORMAL);
			data.setId(cursor.getLong(cursor.getColumnIndex(Groups._ID)));
//			data.setAccountName(cursor.getString(cursor.getColumnIndex(Groups.ACCOUNT_NAME)));
//			data.setAccountType(cursor.getString(cursor.getColumnIndex(Groups.ACCOUNT_TYPE)));
			data.setTitle(cursor.getString(cursor.getColumnIndex(Groups.TITLE)));
			data.setNotes(cursor.getString(cursor.getColumnIndex(Groups.NOTES)));
			data.setSystemId(cursor.getString(cursor.getColumnIndex(Groups.SYSTEM_ID)));
			data.setDeleted(cursor.getInt(cursor.getColumnIndex(Groups.DELETED)));
			
			boolean groupVisivle = (0 == cursor.getInt(cursor.getColumnIndex(Groups.GROUP_VISIBLE)));
			data.setGroupVisivle(groupVisivle);
			boolean shouldSync = (0== cursor.getInt(cursor.getColumnIndex(Groups.SHOULD_SYNC)));
			data.setShouldSync(shouldSync);
			
			resultList.add(data);
			
			Log.d(getClass().getName(), "---- START -----------------------------------------------");
			for(int i = 0; i < cursor.getColumnCount(); i++) {
				Log.d(getClass().getName(), "columnName: " + cursor.getString(i) + "   columnValue: " + cursor.getString(i));
//				if(cursor.getType(i) == Cursor.FIELD_TYPE_BLOB) {
//					Log.d(getClass().getName(), "columnName: " + cursor.getString(i) + "   type as blob");
//				} else {
//					Log.d(getClass().getName(), "columnName: " + cursor.getString(i) + "   columnValue: " + cursor.getString(i));
//				}
			}
		}
		
		return resultList;
	}
	
	/**
	 * O[vf[^̎擾
	 * w肳ꂽO[vɏf[^擾܂B
	 * 
	 * @param group ΏۃO[v
	 * @return ΏۃO[vɏR^Ng
	 */
	public List<ContactDataElement> getContactList(GroupDataElement group) {
		Log.d(getClass().getName(), "getContactList: START");
		if(group.getGroupType() == GroupDataElement.GROUP_TYPE_DEFAULT) {
			return getNonGroupContactList(group);
		}
		
		Uri uri = Data.CONTENT_URI;
		
		String[] projection = new String[] {
				GroupMembership.CONTACT_ID,
				GroupMembership.LOOKUP_KEY,
				GroupMembership.DISPLAY_NAME,
				GroupMembership.PHOTO_ID,
				GroupMembership.IN_VISIBLE_GROUP,
//				GroupMembership.HAS_PHONE_NUMBER,
				GroupMembership.TIMES_CONTACTED,
				GroupMembership.LAST_TIME_CONTACTED,
				GroupMembership.STARRED,
				GroupMembership.CUSTOM_RINGTONE,
				GroupMembership.SEND_TO_VOICEMAIL,
				GroupMembership.CONTACT_PRESENCE,
				GroupMembership.CONTACT_STATUS,
				GroupMembership.CONTACT_STATUS_TIMESTAMP,
				GroupMembership.CONTACT_STATUS_RES_PACKAGE,
				GroupMembership.CONTACT_STATUS_LABEL,
				GroupMembership.CONTACT_STATUS_ICON,
		};

		String selection = null;
		String[] selectionArgs = null;
		
//		if(target.getId() == 0) {
//			selection = GroupMembership.MIMETYPE + " = ? AND " + GroupMembership.GROUP_ROW_ID + " = ? ";
//			selectionArgs = new String[] {GroupMembership.CONTENT_ITEM_TYPE, null};
//		} else {
			selection = GroupMembership.MIMETYPE + " = ? AND " + GroupMembership.GROUP_ROW_ID + " = ? ";
			selectionArgs = new String[] {GroupMembership.CONTENT_ITEM_TYPE, String.valueOf(group.getId())};
//		}
		
		
		ContentResolver cr = getContext().getContentResolver();
		Cursor cursor = cr.query(uri, null, selection, selectionArgs, "sort_key");
		
		ArrayList<ContactDataElement> resultList = new ArrayList<ContactDataElement>();
		
		while(cursor.moveToNext()) {
			ContactDataElementImpl data = new ContactDataElementImpl();
			data.setId(cursor.getLong(cursor.getColumnIndex(GroupMembership.CONTACT_ID)));
			data.setLookupKey(cursor.getString(cursor.getColumnIndex(GroupMembership.LOOKUP_KEY)));
			data.setDisplayName(cursor.getString(cursor.getColumnIndex(GroupMembership.DISPLAY_NAME)));
			data.setPhotoId(cursor.getLong(cursor.getColumnIndex(GroupMembership.PHOTO_ID)));
			data.setInVisibleGroup(cursor.getInt(cursor.getColumnIndex(GroupMembership.IN_VISIBLE_GROUP)));
//			data.setHasPhoneNumber(cursor.getInt(cursor.getColumnIndex(GroupMembership.HAS_PHONE_NUMBER)));
			data.setTimesContacted(cursor.getInt(cursor.getColumnIndex(GroupMembership.TIMES_CONTACTED)));
			data.setLastTimeContacted(cursor.getLong(cursor.getColumnIndex(GroupMembership.LAST_TIME_CONTACTED)));
			data.setStarred(cursor.getInt(cursor.getColumnIndex(GroupMembership.STARRED)));
			data.setCustomRingtone(cursor.getString(cursor.getColumnIndex(GroupMembership.CUSTOM_RINGTONE)));
			data.setSendToVoicemail(cursor.getInt(cursor.getColumnIndex(GroupMembership.SEND_TO_VOICEMAIL)));
			data.setContactPresence(cursor.getInt(cursor.getColumnIndex(GroupMembership.CONTACT_PRESENCE)));
			data.setContactStatus(cursor.getString(cursor.getColumnIndex(GroupMembership.CONTACT_STATUS)));
			data.setContactStatusTimestamp(cursor.getLong(cursor.getColumnIndex(GroupMembership.CONTACT_STATUS_TIMESTAMP)));
			data.setContactStatusResPackage(cursor.getString(cursor.getColumnIndex(GroupMembership.CONTACT_STATUS_RES_PACKAGE)));			
			data.setContactStatusLabel(cursor.getLong(cursor.getColumnIndex(GroupMembership.CONTACT_STATUS_LABEL)));
			data.setContactStatusIcon(cursor.getLong(cursor.getColumnIndex(GroupMembership.CONTACT_STATUS_ICON)));
//
//			data.setAccountName(cursor.getString(cursor.getColumnIndex(RawContacts.ACCOUNT_NAME)));
//			data.setAccountType(cursor.getString(cursor.getColumnIndex(RawContacts.ACCOUNT_TYPE)));
			
//			Log.d("RawContactsEntity", "---- Start ----------------------------------------------------------------");
//			for(int i = 0; i < cursor.getColumnCount(); i++) {
//				try {
//					Log.d("RawContactsEntity", "columnName: " + cursor.getColumnName(i) + "   columnValue: " + cursor.getString(i));
//				} catch (Exception e) {
//					Log.d("RawContactsEntity", "columnName: " + cursor.getColumnName(i) + "   columnValue: error");
//				}
//			}
//			Log.d("RawContactsEntity", "---- End   ----------------------------------------------------------------");
			
			resultList.add(data);
		}
		
		Log.d(getClass().getName(), "getContactList: END");
		return resultList;
	}
	
	public List<ContactDataElement> getNonGroupContactList(GroupDataElement group) {
		Uri uri = RawContacts.CONTENT_URI;
//		Uri uri = Uri.withAppendedPath(RawContacts.CONTENT_URI, RawContacts.Data.CONTENT_DIRECTORY);
		String[] projection = new String[] {
				Contacts._ID,
				Contacts.LOOKUP_KEY,
				Contacts.DISPLAY_NAME,
				Contacts.PHOTO_ID,
				Contacts.IN_VISIBLE_GROUP,
				Contacts.TIMES_CONTACTED,
				Contacts.HAS_PHONE_NUMBER,
				Contacts.LAST_TIME_CONTACTED,
				Contacts.STARRED,
				Contacts.CUSTOM_RINGTONE,
				Contacts.SEND_TO_VOICEMAIL,
				Contacts.CONTACT_PRESENCE,
				Contacts.CONTACT_STATUS,
				Contacts.CONTACT_STATUS_TIMESTAMP,
				Contacts.CONTACT_STATUS_RES_PACKAGE,
				Contacts.CONTACT_STATUS_LABEL,
				Contacts.CONTACT_STATUS_ICON,
		};

//		String selection = Data.MIMETYPE + " = ? AND account_type <> ?";
//		String[] selectionArgs = new String[] {StructuredName.CONTENT_ITEM_TYPE, "com.google"};
		StringBuffer selection = new StringBuffer();
		List<String> selectionArgs = new ArrayList<String>();
		
		Log.d(getClass().getName(), "---- Search Target Account START ------------------------------------------");
		List<AccountDataElement> accountList = group.getAccount();
		for(AccountDataElement account: accountList) {
			if(selection.length() > 0) {
				selection.append(" OR ");
			}
			
//			selection.append("(" + RawContacts.ACCOUNT_NAME + " = ? AND " + RawContacts.ACCOUNT_TYPE + " = ? ) ");
//			selectionArgs.add(account.getAccountName());
//			selectionArgs.add(account.getAccountType());
			Log.d(getClass().getName(), "targetAccount name: " + account.getAccountName());
			Log.d(getClass().getName(), "targetAccount type: " + account.getAccountType());
		}
		
		Log.d(getClass().getName(), "selection String: " + selection.toString());
		Log.d(getClass().getName(), "---- Search Target Account END   ------------------------------------------");
		
		ContentResolver cr = getContext().getContentResolver();
		Cursor cursor = cr.query(uri, null, selection.toString(), selectionArgs.toArray(new String[0]), "sort_key");
		
		ArrayList<ContactDataElement> resultList = new ArrayList<ContactDataElement>();
		
		Log.d(getClass().getName(), "result contacts count: " + cursor.getCount());

		
		while(cursor.moveToNext()) {
			ContactDataElementImpl data = new ContactDataElementImpl();
			data.setId(cursor.getLong(cursor.getColumnIndex(RawContacts.CONTACT_ID)));
//			data.setLookupKey(cursor.getString(cursor.getColumnIndex(Contacts.LOOKUP_KEY)));
			data.setDisplayName(cursor.getString(cursor.getColumnIndex(Contacts.DISPLAY_NAME)));
//			data.setPhotoId(cursor.getLong(cursor.getColumnIndex(Contacts.PHOTO_ID)));
//			data.setInVisibleGroup(cursor.getInt(cursor.getColumnIndex(Contacts.IN_VISIBLE_GROUP)));
////			data.setHasPhoneNumber(cursor.getInt(cursor.getColumnIndex(GroupMembership.HAS_PHONE_NUMBER)));
//			data.setTimesContacted(cursor.getInt(cursor.getColumnIndex(Data.TIMES_CONTACTED)));
//			data.setLastTimeContacted(cursor.getLong(cursor.getColumnIndex(Data.LAST_TIME_CONTACTED)));
//			data.setStarred(cursor.getInt(cursor.getColumnIndex(Data.STARRED)));
//			data.setCustomRingtone(cursor.getString(cursor.getColumnIndex(Data.CUSTOM_RINGTONE)));
//			data.setSendToVoicemail(cursor.getInt(cursor.getColumnIndex(Data.SEND_TO_VOICEMAIL)));
//			data.setContactPresence(cursor.getInt(cursor.getColumnIndex(Data.CONTACT_PRESENCE)));
//			data.setContactStatus(cursor.getString(cursor.getColumnIndex(Data.CONTACT_STATUS)));
//			data.setContactStatusTimestamp(cursor.getLong(cursor.getColumnIndex(Data.CONTACT_STATUS_TIMESTAMP)));
//			data.setContactStatusResPackage(cursor.getString(cursor.getColumnIndex(Data.CONTACT_STATUS_RES_PACKAGE)));			
//			data.setContactStatusLabel(cursor.getLong(cursor.getColumnIndex(Data.CONTACT_STATUS_LABEL)));
//			data.setContactStatusIcon(cursor.getLong(cursor.getColumnIndex(Data.CONTACT_STATUS_ICON)));
//
			data.setAccountName(cursor.getString(cursor.getColumnIndex(RawContacts.ACCOUNT_NAME)));
			data.setAccountType(cursor.getString(cursor.getColumnIndex(RawContacts.ACCOUNT_TYPE)));
			
			
			if(!data.getAccountType().equals("com.google")) { 
				
			Log.d("RawContactsEntity", "---- Start ----------------------------------------------------------------");
			for(int i = 0; i < cursor.getColumnCount(); i++) {
				try {
					Log.d("RawContactsEntity", "columnName: " + cursor.getColumnName(i) + "   columnValue: " + cursor.getString(i));
				} catch (Exception e) {
					Log.d("RawContactsEntity", "columnName: " + cursor.getColumnName(i) + "   columnValue: error");
				}
			}
			Log.d("RawContactsEntity", "---- End   ----------------------------------------------------------------");
			}
			resultList.add(data);
		}
		
		Log.d(getClass().getName(), "getContactList: END");
		return resultList;
	}
}
