package jp.sourceforge.android_ab.addressbook.common.helper;

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.android_ab.addressbook.common.data.AccountDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.impl.AccountDataElementImpl;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.Context;

public class AccountDataHelper {
	private Context context;
	public AccountDataHelper(Context context) {
		this.context = context;
	}
	
	public List<AccountDataElement> getAccount() {
		AccountManager manager = AccountManager.get(context);
		Account[] accounts = manager.getAccounts();
		ArrayList<AccountDataElement> resultAccounts = new ArrayList<AccountDataElement>();
		
		for(Account account: accounts) {
			AccountDataElementImpl element = new AccountDataElementImpl();
			element.setAccountName(account.name);
			element.setAccountType(account.type);
			
			resultAccounts.add(element);
		}
		
		return resultAccounts;
	}
}
