/*
 * Copyright (c) 2012, ToshiakiAsazuma All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * ERedistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  
 * ERedistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation
 *  and/or other materials provided with the distribution.
 *  
 * ENeither the name of the ToshiakiAsazuma nor the names of its contributors
 *  may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *  
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 *  OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 *  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 *  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 *  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.sourceforge.android_ab.addressbook.groupaddresslist.view;

import jp.sourceforge.android_ab.addressbook.R;
import jp.sourceforge.android_ab.addressbook.common.adapter.ListAdapter;
import jp.sourceforge.android_ab.addressbook.common.data.AddressDataBean;
import jp.sourceforge.android_ab.addressbook.common.data.ListPageDataBean;
import jp.sourceforge.android_ab.addressbook.common.data.PageDataBean;
import jp.sourceforge.android_ab.addressbook.common.helper.GroupAddressListDataHelper;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.provider.ContactsContract.Contacts;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ListView;

public class GroupAddressListFragment extends Fragment implements OnItemClickListener {
	private PageDataBean<AddressDataBean> m_menuBean;
	public GroupAddressListFragment() {
		super();
		Log.d("RXgN^", "start");
	}
	
	public static GroupAddressListFragment newInstance(int position) {
		Log.d("newInstance", "start");
		GroupAddressListFragment f = new GroupAddressListFragment();
		Bundle args = new Bundle();
		args.putInt("targetPosition", position);
		f.setArguments(args);
		Log.d("newInstance", "end");
		
		return f;
	}

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		
		Log.d("GroupAddressListFragment", "activity: " + getActivity());
		
		int position = getArguments().getInt("targetPosition");
		
		GroupAddressListDataHelper helper = GroupAddressListDataHelper.getInstance(getActivity());
		ListPageDataBean<AddressDataBean> menuBean = helper.getDataBean();
		String groupId = menuBean.getGroupIdArray()[position];
		m_menuBean = menuBean.getMenuBean(groupId);
	}
	
	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,Bundle savedInstanceState) {
		View view = (View) inflater.inflate(R.layout.groupaddresslistpage, null);
		
		// A\̈iXgr[j
		ListView addressList = (ListView) view.findViewById(R.id.addressList);
		addressList.setAdapter(getAdapter());
		addressList.setOnItemClickListener(this);
		
		
		return view;
	}
	
	private PageDataBean<AddressDataBean> getMenuBean() {
		return m_menuBean;
	}
	
	private ListAdapter<AddressDataBean> getAdapter() {
		return getMenuBean().getAdapter();
	}

	public void onItemClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
		ListView listView = (ListView) arg0;
		AddressDataBean bean = (AddressDataBean) listView.getItemAtPosition(arg2);
		
		Uri lookupUri = Contacts.getLookupUri(bean.getContactId(), bean.getLookupKey());
		Intent intent = new Intent(Intent.ACTION_VIEW, lookupUri);
		startActivity(intent);
	}
}