/*
 * Copyright (c) 2012, ToshiakiAsazuma All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * ERedistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  
 * ERedistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation
 *  and/or other materials provided with the distribution.
 *  
 * ENeither the name of the ToshiakiAsazuma nor the names of its contributors
 *  may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *  
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 *  OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 *  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 *  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 *  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package jp.sourceforge.android_ab.addressbook.common.helper;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import jp.sourceforge.android_ab.addressbook.common.data.AddressDataBean;
import jp.sourceforge.android_ab.addressbook.common.data.ListPageDataBean;
import jp.sourceforge.android_ab.addressbook.common.data.PageDataBean;
import jp.sourceforge.android_ab.addressbook.groupaddresslist.adapter.AddressListAdapter;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.provider.ContactsContract.CommonDataKinds.GroupMembership;
import android.provider.ContactsContract.CommonDataKinds.StructuredName;
import android.provider.ContactsContract.Data;
import android.provider.ContactsContract.Groups;
import android.util.Log;


/**
 * O[vʈꗗ擾pwp[.
 * 
 * @author toshiaki
 *
 */
public class GroupAddressListDataHelper extends BaseDataHelper<ListPageDataBean<AddressDataBean>> {
	private static GroupAddressListDataHelper instance;
	
	private static final String TITLE = "O[vʃR^Ng";
	
	private ListPageDataBean<AddressDataBean> menuDataBean;
	public static GroupAddressListDataHelper getInstance(Context context) {
		if(instance == null) {
			instance = new GroupAddressListDataHelper(context);
		}
		
		return instance;
	}
	
	protected GroupAddressListDataHelper(Context context) {
		super(context);
		menuDataBean = reloadMenuDataBean();
		menuDataBean.setMenuTitle(TITLE);
	}
	
	
	@Override
	public ListPageDataBean<AddressDataBean> getDataBean() {
		return menuDataBean;
	}

	public ListPageDataBean<AddressDataBean> reloadMenuDataBean() {
		Map<String, String> allGroupMap = initGroupList();
		Set<String> groupIdSet = allGroupMap.keySet();
		ListPageDataBean<AddressDataBean> menuDataBean = new ListPageDataBean<AddressDataBean>();
		for(String groupId: groupIdSet) {
			PageDataBean<AddressDataBean> groupMenuBean = new PageDataBean<AddressDataBean>(getContext(), new AddressListAdapter(getContext()));
			groupMenuBean.setMenuId(groupId);
			groupMenuBean.setMenuTitle(allGroupMap.get(groupId));
			menuDataBean.add(groupMenuBean);
		}
		createGroupData(menuDataBean);
		
		return menuDataBean;
	}
	
//    /**
//     * O[v}bv̏.
//     * SẴO[v擾AMapɕۑ܂B<br>
//     * {\bhł́ASẴO[v擾A擾O[vAf[^ۑ郊Xg𐶐ۊǂ܂B<br>
//     * ́A<{@linkplain #initGroupTab(Cursor, Map) O[v^ȕ}ŁA
//     * SĂ̘Af[^AO[vɈvf[^𒊏oۑ邽߂ɍsĂ܂A
//     * ́ACursoř@킩炸AJi\[goȂߎbIȏƂȂ܂B
//     * 
//     * @return O[v}bv
//     */
//    private Map<String, ArrayList<ContactDataBean>> initGroupMap() {
//    	Map<String, String> groupMap = getAllGroupMap();
//    	Map<String, ArrayList<ContactDataBean>> resultMap = new HashMap<String, ArrayList<ContactDataBean>>();
//    	
//    	Set<String> groupKeySet = groupMap.keySet();
//    	for(String groupId: groupKeySet) {
//    		groupMap.put(groupId, groupMap.get(groupId));
//    	}
//    	
//    	return resultMap;
//    }
//    
    /**
     * Groupꗗ.
     * O[v̈ꗗ擾J[\𐶐Ԃ܂B
     * @return O[vꗗ擾J[\
     */
    private Map<String, String> initGroupList() {
    	Map<String, String> groupMap = new LinkedHashMap<String, String>();;
    	
    	ContentResolver cr = getContentResolver();
    	Cursor cursor = cr.query(Groups.CONTENT_URI,
			    			 	new String[] {
				    				Groups._ID,
				    				Groups.TITLE},
			    				null, 
			    				null,
			    				null);
    	groupMap.put("1", "MyContacts");
    	
    	while(cursor.moveToNext()) {
    		String groupId = cursor.getString(cursor.getColumnIndex(Groups._ID));
    		String groupName = cursor.getString(cursor.getColumnIndex(Groups.TITLE));
    		groupMap.put(groupId, groupName);
    	}
    	
    	return groupMap;
    }
    
    /**
     * SĂ̘Aꗗ擾.
     * SĂ̘Aꗗ擾J[\𐶐Ԃ܂B
     * @return SĂ̘Aꗗ擾J[\
     */
    private Cursor getAllDataCursor() {
    	ContentResolver cr = getContentResolver();
    	Cursor cursor = cr.query(Data.CONTENT_URI,
    							new String[] {
    								StructuredName.CONTACT_ID,
    								StructuredName.LOOKUP_KEY,
    								StructuredName.PHOTO_ID,
    								StructuredName.DISPLAY_NAME,
									StructuredName.FAMILY_NAME,
									StructuredName.MIDDLE_NAME,
									StructuredName.GIVEN_NAME,
									StructuredName.PHONETIC_FAMILY_NAME,
									StructuredName.PHONETIC_MIDDLE_NAME,
									StructuredName.PHONETIC_GIVEN_NAME,
									StructuredName.CONTACT_STATUS_LABEL,
									},
    							StructuredName.MIMETYPE + " = ? ",
    							new String[] {StructuredName.CONTENT_ITEM_TYPE},
    							StructuredName.PHONETIC_FAMILY_NAME);
    							
    	return cursor;
    }
    
    /**
     * O[vʐU蕪.
     * SĂ̘AꗗƁAO[vʘAꗗgpO[ṽXg֐U蕪s܂B<br>
     * 
     * @param allDataCursor
     * @param groupDataMap
     */
    private void createGroupData(ListPageDataBean<AddressDataBean> menuDataBean) {
    	Cursor allDataCursor = getAllDataCursor();
    	Cursor groupCursor = getGroupCursor();
    	
    	while(allDataCursor.moveToNext()) {
    		String contactId = allDataCursor.getString(allDataCursor.getColumnIndex(StructuredName.CONTACT_ID));
    		List<String> groups = getMacthDataList(
    											contactId, 
							    				groupCursor, 
							    				groupCursor.getColumnIndex(GroupMembership.CONTACT_ID), 
							    				groupCursor.getColumnIndex(GroupMembership.GROUP_ROW_ID));
    		
    		for(int i = 0; i < groups.size(); i++) {
    			AddressDataBean resultBean = new AddressDataBean();
    			resultBean.setContactId(allDataCursor.getInt(allDataCursor.getColumnIndex(StructuredName.CONTACT_ID)));
    			resultBean.setLookupKey(allDataCursor.getString(allDataCursor.getColumnIndex(StructuredName.LOOKUP_KEY)));
    			resultBean.setPhotoId(allDataCursor.getInt(allDataCursor.getColumnIndex(StructuredName.PHOTO_ID)));
    			resultBean.setDisplayName(allDataCursor.getString(allDataCursor.getColumnIndex(StructuredName.DISPLAY_NAME)));
    			resultBean.setFamilyName(allDataCursor.getString(allDataCursor.getColumnIndex(StructuredName.FAMILY_NAME)));
    			resultBean.setMiddleName(allDataCursor.getString(allDataCursor.getColumnIndex(StructuredName.MIDDLE_NAME)));
    			resultBean.setGivenName(allDataCursor.getString(allDataCursor.getColumnIndex(StructuredName.GIVEN_NAME)));
    			resultBean.setPhoneticFamilyName(allDataCursor.getString(allDataCursor.getColumnIndex(StructuredName.PHONETIC_FAMILY_NAME)));
    			resultBean.setPhoneticMiddleName(allDataCursor.getString(allDataCursor.getColumnIndex(StructuredName.PHONETIC_MIDDLE_NAME)));
    			resultBean.setPhoneticGivenName(allDataCursor.getString(allDataCursor.getColumnIndex(StructuredName.PHONETIC_GIVEN_NAME)));
    			resultBean.setContactStatusLabel(allDataCursor.getString(allDataCursor.getColumnIndex(StructuredName.CONTACT_STATUS_LABEL)));
    			
    			Log.d("com.blogspot.started.a.newleaf.contactlist", "createGroupData: contactId: " + 
    					allDataCursor.getLong(allDataCursor.getColumnIndex(StructuredName.CONTACT_ID)) +  " groupId: " +
    					groups.get(i));
    			PageDataBean<AddressDataBean> groupMenuBean = menuDataBean.getMenuBean(groups.get(i));
    			groupMenuBean.add(resultBean);
    		}
    	}
    	groupCursor.close();
    	allDataCursor.close();
    }
    
    /**
     * vO[v̎擾.
     * targetIdɈvJ[\IDԂ܂B
     * @param targetId - ID
     * @param targetCursor - Ώۂ̃J[\
     * @param targetColumnIndex - J̃CfbNX
     * @param columnIndex - 擾J̃CfbNX
     * @return vf[^̃Xg
     */
    private List<String> getMacthDataList(String targetId, Cursor targetCursor, int targetColumnIndex, int columnIndex) {
    	targetCursor.moveToFirst();
    	ArrayList<String> resultList = new ArrayList<String>();
    	
    	while(targetCursor.moveToNext()) {
    		if(targetId.equals(targetCursor.getString(targetColumnIndex))){
	    		String id = targetCursor.getString(columnIndex);
	    		resultList.add(id);
    		}
    	}
    	
    	return resultList;
    }

    /**
     * SO[v̎擾.
     * O[vR^NgSĂ̏擾J[\Ԃ܂B
     * 
     * @return SO[v擾J[\
     */
    private Cursor getGroupCursor() {
    	ContentResolver cr = getContentResolver();
    	Cursor cursor = cr.query(Data.CONTENT_URI,
				    			new String[] {
    								GroupMembership._ID,
    								GroupMembership.CONTACT_ID,
    								GroupMembership.LOOKUP_KEY,
    								GroupMembership.PHOTO_ID,
    								GroupMembership.DISPLAY_NAME,
    								GroupMembership.GROUP_ROW_ID},
    							Data.MIMETYPE + " = ? ",
    							new String[] {
    								GroupMembership.CONTENT_ITEM_TYPE,
    								},
    							null);
    	return cursor;
    }

	
}
