package jp.sourceforge.android_ab.addressbook.contactdetail.view;

import java.io.InputStream;

import jp.sourceforge.android_ab.addressbook.R;
import jp.sourceforge.android_ab.addressbook.common.activity.ActionBarActivity;
import jp.sourceforge.android_ab.addressbook.common.data.ContactDetailDataElement;
import jp.sourceforge.android_ab.addressbook.common.helper.ContactDetailDataHelper;
import jp.sourceforge.android_ab.addressbook.contactdetail.adapter.ContactDetailAdapter;
import android.content.ContentUris;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.provider.ContactsContract.Contacts;
import android.util.Log;
import android.widget.ListView;
import android.widget.QuickContactBadge;
import android.widget.TextView;

public class ContactDetailInfoActivity extends ActionBarActivity {
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.contact_detail_activity);

		ContactDetailDataHelper helper = new ContactDetailDataHelper(this);
		ContactDetailDataElement element = helper.findLookupUri(getIntent().getData());
		
		initBaseInfo(element);
		
		ContactDetailAdapter adapter = new ContactDetailAdapter(this, element);
		
		ListView list = (ListView) findViewById(R.id.detailList);
		list.setAdapter(adapter);
		
	}
	
	private void initBaseInfo(ContactDetailDataElement bean) {
		Log.d("jp.sourceforge.android_ab.addressbook.contactdetail.view#ContactDetailInfoActivity", "start");
		QuickContactBadge badge = (QuickContactBadge) findViewById(R.id.badge);

		badge.assignContactUri(Contacts.getLookupUri(bean.getId(), bean.getLookupKey()));
		Uri photoUri = ContentUris.withAppendedId(Contacts.CONTENT_URI, bean.getId());
		InputStream photoIs = Contacts.openContactPhotoInputStream(getContentResolver(), photoUri);
		
		if(photoIs == null) {
			badge.setImageResource(R.drawable.ic_contact_picture);
		} else {
			badge.setImageBitmap(BitmapFactory.decodeStream(photoIs));
		}
		TextView displayName = (TextView) findViewById(R.id.basicInfoDisplayName);
		TextView basicInfoKana = (TextView) findViewById(R.id.basicInfoKana);
		
		displayName.setText(bean.getDisplayName());
		//basicInfoKana.setText(bean.getPhoneticName());
		Log.d("jp.sourceforge.android_ab.addressbook.contactdetail.view#ContactDetailInfoActivity", "end");
	}
}
