package jp.sourceforge.android_ab.addressbook.common.helper;

import jp.sourceforge.android_ab.addressbook.common.data.ContactDataElement;
import jp.sourceforge.android_ab.addressbook.common.data.impl.ContactDataElementImpl;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract.Contacts;

public class ContactDataHelper {
	private Context context;
	
	public ContactDataHelper(Context context) {
		this.context = context;
	}
	
	public Context getContext() {
		return context;
	}
	
	public ContactDataElement findById(long contactId, String lookupKey) {
		ContactDataElementImpl contact = new ContactDataElementImpl();
		
		return findById(contactId, lookupKey, contact);
	}
	
	protected ContactDataElement findById(long contactId, String lookupKey, ContactDataElementImpl contact) {
		Uri uri = Contacts.getLookupUri(contactId, lookupKey);
		Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
		
		return loadContactData(cursor, contact);
	}
	
	protected ContactDataElement loadContactData(Cursor cursor, ContactDataElementImpl data) {
		data.setId(cursor.getLong(cursor.getColumnIndex(Contacts._ID)));
		data.setLookupKey(cursor.getString(cursor.getColumnIndex(Contacts.LOOKUP_KEY)));
		data.setDisplayName(cursor.getString(cursor.getColumnIndex(Contacts.DISPLAY_NAME)));
		data.setPhotoId(cursor.getLong(cursor.getColumnIndex(Contacts.PHOTO_ID)));
		data.setInVisibleGroup(cursor.getInt(cursor.getColumnIndex(Contacts.IN_VISIBLE_GROUP)));
		data.setHasPhoneNumber(cursor.getInt(cursor.getColumnIndex(Contacts.HAS_PHONE_NUMBER)));
		data.setTimesContacted(cursor.getInt(cursor.getColumnIndex(Contacts.TIMES_CONTACTED)));
		data.setLastTimeContacted(cursor.getLong(cursor.getColumnIndex(Contacts.LAST_TIME_CONTACTED)));
		data.setStarred(cursor.getInt(cursor.getColumnIndex(Contacts.STARRED)));
		data.setCustomRingtone(cursor.getString(cursor.getColumnIndex(Contacts.CUSTOM_RINGTONE)));
		data.setSendToVoicemail(cursor.getInt(cursor.getColumnIndex(Contacts.SEND_TO_VOICEMAIL)));
//		data.setContactPresence(cursor.getInt(cursor.getColumnIndex(Contacts.CONTACT_PRESENCE)));
//		data.setContactStatus(cursor.getString(cursor.getColumnIndex(Contacts.CONTACT_STATUS)));
//		data.setContactStatusTimestamp(cursor.getLong(cursor.getColumnIndex(Contacts.CONTACT_STATUS_TIMESTAMP)));
//		data.setContactStatusResPackage(cursor.getString(cursor.getColumnIndex(Contacts.CONTACT_STATUS_RES_PACKAGE)));			
//		data.setContactStatusLabel(cursor.getLong(cursor.getColumnIndex(Contacts.CONTACT_STATUS_LABEL)));
//		data.setContactStatusIcon(cursor.getLong(cursor.getColumnIndex(Contacts.CONTACT_STATUS_ICON)));

		return data;
	}
}
