package jp.sourceforge.andjong.mahjong;

/**
 * ̔vǗB
 *
 * @author Yuji Urushibara
 *
 */
public class SuteHai extends Hai {
	/** tO */
	private boolean m_naki = false;

	/** [`tO */
	private boolean m_reach = false;

	/** otO */
	private boolean m_tedashi = false;

	/**
	 * ̔v쐬B
	 */
	public SuteHai() {
		super();
	}

	/**
	 * ID̔v쐬B
	 *
	 * @param a_id
	 *            ID
	 */
	public SuteHai(int a_id) {
		super(a_id);
	}

	/**
	 * v̔v쐬B
	 *
	 * @param a_hai
	 *            v
	 */
	public SuteHai(Hai a_hai) {
		super(a_hai);
	}

	/**
	 * ̔vRs[B
	 *
	 * @param a_dest
	 *            Rs[̎̔v
	 * @param a_src
	 *            Rs[̎̔v
	 */
	public static void copy(SuteHai a_dest, SuteHai a_src) {
		Hai.copy(a_dest, a_src);
		a_dest.m_naki = a_src.m_naki;
		a_dest.m_reach = a_src.m_reach;
		a_dest.m_tedashi = a_src.m_tedashi;
	}

	/**
	 * ̔vRs[B
	 *
	 * @param a_dest
	 *            Rs[̎̔v
	 * @param a_src
	 *            Rs[̎̔v
	 */
	public static void copy(SuteHai a_dest, Hai a_src) {
		Hai.copy(a_dest, a_src);
		a_dest.m_naki = false;
		a_dest.m_reach = false;
		a_dest.m_tedashi = false;
	}

	/**
	 * tOݒ肷B
	 *
	 * @param a_naki
	 *            tO
	 */
	public void setNaki(boolean a_naki) {
		this.m_naki = a_naki;
	}

	/**
	 * tO擾B
	 *
	 * @return tO
	 */
	public boolean isNaki() {
		return m_naki;
	}

	/**
	 * [`tOݒ肷B
	 *
	 * @param a_reach
	 *            [`tO
	 */
	public void setReach(boolean a_reach) {
		this.m_reach = a_reach;
	}

	/**
	 * [`tO擾B
	 *
	 * @return [`tO
	 */
	public boolean isReach() {
		return m_reach;
	}

	/**
	 * otOݒ肷B
	 *
	 * @param a_tedashi
	 *            otO
	 */
	public void setTedashi(boolean a_tedashi) {
		this.m_tedashi = a_tedashi;
	}

	/**
	 * otO擾B
	 *
	 * @return otO
	 */
	public boolean isTedashi() {
		return m_tedashi;
	}
}
