package jp.sourceforge.andjong.mahjong;

/**
 * IǗB
 *
 * @author Yuji Urushibara
 *
 */
public class Fuuro {
	/*
	 * 
	 */

	/**   */
	public static final int TYPE_MINSHUN = 0;
	/**   */
	public static final int TYPE_MINKOU = 1;
	/**  喾 */
	public static final int TYPE_DAIMINKAN = 2;
	/**   */
	public static final int TYPE_KAKAN = 3;
	/**  Þ */
	public static final int TYPE_ANKAN = 4;

	/**  */
	private int m_type;

	/** ƂƂ̊֌W */
	private int m_relation;

	/** \v */
	private Hai m_hais[] = new Hai[Mahjong.MENTSU_HAI_MEMBERS_4];

	{
		for (int i = 0; i < m_hais.length; i++) {
			m_hais[i] = new Hai();
		}
	}

	/**
	 * ʂݒ肷B
	 *
	 * @param a_type
	 *            
	 */
	public void setType(int a_type) {
		this.m_type = a_type;
	}

	/**
	 * ʂ擾B
	 *
	 * @return 
	 */
	public int getType() {
		return m_type;
	}

	/**
	 * ƂƂ̊֌Wݒ肷B
	 *
	 * @param a_relation
	 *            ƂƂ̊֌W
	 */
	public void setRelation(int a_relation) {
		this.m_relation = a_relation;
	}

	/**
	 * ƂƂ̊֌W擾B
	 *
	 * @return ƂƂ̊֌W
	 */
	public int getRelation() {
		return m_relation;
	}

	/**
	 * \vݒ肷B
	 *
	 * @param m_hais
	 *            \v
	 */
	public void setHais(Hai m_hais[]) {
		this.m_hais = m_hais;
	}

	/**
	 * \v擾B
	 *
	 * @return \v
	 */
	public Hai[] getHais() {
		return m_hais;
	}

	/**
	 * IRs[B
	 *
	 * @param a_dest
	 *            Rs[̕I
	 * @param a_src
	 *            Rs[̕I
	 */
	public static void copy(Fuuro a_dest, Fuuro a_src) {
		a_dest.m_type = a_src.m_type;
		a_dest.m_relation = a_src.m_relation;

		for (int i = 0; i < Mahjong.MENTSU_HAI_MEMBERS_4; i++) {
			Hai.copy(a_dest.m_hais[i], a_src.m_hais[i]);
		}
	}
}
