package jp.sourceforge.andjong;

import static jp.sourceforge.andjong.Hai.*;
import jp.sourceforge.andjong.CountFormat.Combi;

public class AgariScore {
	/** JEgtH[}bg */
	private CountFormat countFormat = new CountFormat();

	/**
	 * vZ܂B
	 *
	 * @param tehai
	 *            v addHai av combi v̑gݍ킹@
	 *
	 * @return int 
	 *
	 */
	int countHu(Tehai tehai, Hai addHai, Combi combi, Yaku yaku,AgariSetting setting) {
		int countHu = 20;
		Hai checkHais[][];

		//Ύq̏ꍇ͂QT
		if(yaku.checkTeetoitu() == true){
			return 25;
		}

		//̔v擾
		Hai atamaHai = new Hai(combi.atamaId);

		// RvȂQǉ
		if (atamaHai.getKind() == KIND_SANGEN) {
			countHu += 2;
		}

		// ꕗȂQǉ
		if (atamaHai.getId() == setting.getBakaze()){
			countHu += 2;
		}

		// ȂQǉ
		if (atamaHai.getId() == setting.getJikaze()){
			countHu += 2;
		}

		//aꍇ́A҂ɂQǉD悳
		if(yaku.checkPinfu() == false){
			// PR҂̏ꍇQǉ
			if(addHai.getId() == combi.atamaId){
				countHu += 2;
			}

			// ƒ҂̏ꍇQǉ
			//v̂Q`Wǂ
			if(addHai.isYaotyuu() == false){
				for(int i = 0 ; i < combi.shunCount ; i++){
					if((addHai.getNo()-1) == combi.shunIds[i]){
						countHu += 2;
					}
				}
			}

			// Ӓ҂(3)̏ꍇQǉ
			if((addHai.isYaotyuu() == false) && (addHai.getNo() == NO_3)){
				for(int i = 0 ; i < combi.shunCount ; i++){
					if( (addHai.getId()-2) == combi.shunIds[i]){
						countHu += 2;
					}
				}
			}

			// Ӓ҂(7)̏ꍇQǉ
			if((addHai.isYaotyuu() == false) && (addHai.getNo() == NO_7)){
				for(int i = 0 ; i < combi.shunCount ; i++){
					if( addHai.getId() == combi.shunIds[i]){
						countHu += 2;
					}
				}
			}
		}

		// Íɂ_
		for (int i = 0; i < combi.kouCount; i++) {
			Hai checkHai = new Hai(combi.kouIds[i]);
			// vv1,9
			if (checkHai.isYaotyuu() == true) {
				countHu += 8;
			} else {
				countHu += 4;
			}
		}

		// ɂ_
		for (int i = 0; i < tehai.getMinKousLength(); i++) {
			checkHais = tehai.getMinKous();
			// vv1,9
			if (checkHais[i][0].isYaotyuu() == true) {
				countHu += 4;
			} else {
				countHu += 2;
			}
		}

		// Ȃɂ_
		for (int i = 0; i < tehai.getMinKansLength(); i++) {
			checkHais = tehai.getMinKans();
			// vv1,9
			if (checkHais[i][0].isYaotyuu() == true) {
				countHu += 16;
			} else {
				countHu += 8;
			}
		}

		// ÞȂɂ_
		for (int i = 0; i < tehai.getAnKansLength(); i++) {
			checkHais = tehai.getAnKans();
			// vv1,9
			if (checkHais[i][0].isYaotyuu() == true) {
				countHu += 32;
			} else {
				countHu += 16;
			}
		}

		// cオŕaĂȂ΂Qǉ
		if(setting.getYakuflg(AgariSetting.YakuflgName.TUMO.ordinal() )== true){
			if(yaku.checkPinfu() == false){
				countHu += 2;
			}
		}

		// ʑOオ̏ꍇ͂POǉ
		if(setting.getYakuflg(AgariSetting.YakuflgName.TUMO.ordinal() )== false){
			if (yaku.nakiflg == false) {
				countHu += 10;
			}
		}

		// ̈ʂꍇ́A؂グ
		if (countHu % 10 != 0) {
			countHu = countHu - (countHu % 10) + 10;
		}

		return countHu;
	}

	/**
	 * オ_擾܂B
	 *
	 * @param tehai
	 *            v addHai av combi v̑gݍ킹@
	 *
	 * @return int a_
	 */
	public int getScore(int hanSuu, int huSuu) {
		int score;
		// @~ Q́@i|@+@]2|)
		score = huSuu * (int) Math.pow(2, hanSuu + 2);
		// q͏4{{_(e6{)
		score *= 4;

		// 100Ŋ؂Ȃꍇ100_Jグ
		if (score % 100 != 0) {
			score = score - (score % 100) + 100;
		}
		// 7700ȏ8000Ƃ
		if (score >= 7700) {
			score = 8000;
		}

		if (hanSuu >= 13) { // 13|ȏ͖
			score = 32000;
		} else if (hanSuu >= 11) { // 11|ȏ3{
			score = 24000;
		} else if (hanSuu >= 8) { // 8|ȏ͔{
			score = 16000;
		} else if (hanSuu >= 6) { // 6|ȏ͒
			score = 12000;
		} else if (hanSuu >= 5) { // 5|ȏ͖
			score = 8000;
		}

		return score;
	}

	public int getAgariScore(Tehai tehai, Hai addHai, Combi[] combis,AgariSetting setting) {
		// JEgtH[}bg擾܂B
		CountFormat.getCountFormat(tehai, countFormat, addHai);

		// ̑gݍ킹擾܂B
		int combisCount = countFormat.getCombi(combis);

		// ̑gݍ킹Ȃꍇ0_
		if (combisCount == 0)
			return 0;

		// 
		int hanSuu[] = new int[combisCount];
		// 
		int huSuu[] = new int[combisCount];
		// _iq̃オj
		int agariScore[] = new int[combisCount];
		// ő̓_
		int maxagariScore = 0;

		for (int i = 0; i < combisCount; i++) {
			Yaku yaku = new Yaku(tehai, addHai, combis[i], setting);
			hanSuu[i] = yaku.getHanSuu();
			huSuu[i] = countHu(tehai, addHai, combis[i],yaku,setting);
			agariScore[i] = getScore(hanSuu[i], huSuu[i]);
		}

		// őlT
		maxagariScore = agariScore[0];
		for (int i = 0; i < combisCount; i++) {
			maxagariScore = Math.max(maxagariScore, agariScore[i]);
		}
		return maxagariScore;
	}
	
	public String[] getYakuName(Tehai tehai, Hai addHai, Combi[] combis,AgariSetting setting) {
		//a̖O
		String[] yakuNames = {""};
		// JEgtH[}bg擾܂B
		CountFormat.getCountFormat(tehai, countFormat, addHai);

		// ̑gݍ킹擾܂B
		int combisCount = countFormat.getCombi(combis);

		// ̑gݍ킹Ȃꍇ0_
		if (combisCount == 0){
			return yakuNames;
		}

		// 
		int hanSuu[] = new int[combisCount];
		// 
		int huSuu[] = new int[combisCount];
		// _iq̃オj
		int agariScore[] = new int[combisCount];
		// ő̓_
		int maxagariScore = 0;


		for (int i = 0; i < combisCount; i++) {
			Yaku yaku = new Yaku(tehai, addHai, combis[i], setting);
			hanSuu[i] = yaku.getHanSuu();
			huSuu[i] = countHu(tehai, addHai, combis[i],yaku,setting);
			agariScore[i] = getScore(hanSuu[i], huSuu[i]);
			
			if(maxagariScore < agariScore[i]){
				maxagariScore = agariScore[i];
				yakuNames = yaku.getYakuName();
			}
		}

		return yakuNames;
	}
}
