package jp.sourceforge.andjong;

import jp.sourceforge.andjong.CountFormat.Combi;
import jp.sourceforge.andjong.EventIF.EID;
import jp.sourceforge.andjong.AgariScore;

/**
 * Q[ǗNXłB
 *
 * @author Yuji Urushibara
 *
 */
public class Game {
	/** R */
	private Yama yama;

	/**
	 * R擾܂B
	 *
	 * @return R
	 */
	Yama getYama() {
		return yama;
	}

	/**  */
	public final static int KYOKU_TON_1 = 1;
	/**  */
	public final static int KYOKU_TON_2 = 2;
	/** O */
	public final static int KYOKU_TON_3 = 3;
	/** l */
	public final static int KYOKU_TON_4 = 4;

	/**  */
	private int kyoku;

	/**
	 * ǂ擾܂B
	 *
	 * @return 
	 */
	int getkyoku() {
		return kyoku;
	}

	/** ǂ̍ől */
	private int kyokuMax;

	/** cv */
	private Hai tsumoHai;

	/**
	 * cv擾܂B
	 *
	 * @return cv
	 */
	Hai getTsumoHai() {
		return tsumoHai;
	}

	/** ̔v */
	private Hai suteHai;

	/**
	 * ̔v擾܂B
	 *
	 * @return ̔v
	 */
	Hai getSuteHai() {
		return suteHai;
	}

	/** vC[ɒ񋟂 */
	private Info info;

	/** vC[̐l */
	private int playerLength;

	/** vC[̔z */
	private Player[] players;

	/** vC[CfbNXɕϊz */
	private int[] kazeToPlayerIdx = new int[4];

	/** UIɒ񋟂 */
	private InfoUI infoUi;

	/** UI */
	private Console ui;

	/** [`_̐ */
	private int reachbou;

	/** ẽvC[CfbNX */
	private int oyaIdx;

	/** A */
	private boolean renchan;

	/** { */
	private int honba;

	/** Cxg𔭍s */
	private int fromKaze;

	/** Cxg̑ΏۂƂȂ */
	private int toKaze;

	/** TCR̔z */
	private Sai[] sais = new Sai[] { new Sai(), new Sai() };

	/**
	 * TCR̔z擾܂B
	 *
	 * @return TCR̔z
	 */
	Sai[] getSais() {
		return sais;
	}

	public final static int KAZE_TON = 1;
	public final static int KAZE_NAN = 2;
	public final static int KAZE_SHA = 3;
	public final static int KAZE_PE = 4;

	/**  */
	private int wareme;

	/** ANeBuvC[ */
	private Player activePlayer;

	/**
	 * CJn܂B
	 *
	 * @param args
	 *            R}hC
	 */
	public static void main(String[] args) {
		// GameCX^X쐬܂B
		Game game = new Game();

		// Q[Jn܂B
		game.play();
	}

	/**
	 * Q[Jn܂B
	 */
	public void play() {
		// GameCX^X܂B
		init();

		// ꏊ߂܂B
		// TODO łB

		// Cxgiꏊ߁j𔭍s܂B
		ui.event(EID.BASHOGIME, 0, 0);

		// vC[e߂܂B
		sais[0].saifuri();
		sais[1].saifuri();
		oyaIdx = (sais[0].getNo() + sais[1].getNo() - 1) % 4;

		// Cxgie߁j𔭍s܂B
		ui.event(EID.OYAGIME, 0, 0);

		// ǂJn܂B
		while (kyoku <= kyokuMax) {
			startKyoku();
			if (!renchan) {
				kyoku++;
				honba = 0;
			} else {
				System.out.println("AłB");
			}
		}
	}

	/**
	 * ܂B
	 * <p>
	 * ݒɂēIɏ܂B
	 * </p>
	 */
	private void init() {
		// R܂B
		yama = new Yama();

		// ǂ܂B
		kyoku = 1;

		// ǂ̍őlݒ肵܂B
		kyokuMax = 4;

		// cv܂B
		tsumoHai = new Hai();

		// ̔v܂B
		suteHai = new Hai();

		// vC[ɒ񋟂܂B
		info = new Info(this);

		// vC[̐lݒ肵܂B
		playerLength = 4;

		// vC[z܂B
		players = new Player[playerLength];
		// for (int i = 0; i < players.length; i++) {
		// players[i] = new Player((EventIF) new AI(info));
		// }
		players[0] = new Player((EventIF) new AI(info, "Y"));
		players[1] = new Player((EventIF) new AI(info, "Y"));
		players[2] = new Player((EventIF) new AI(info, "OY"));
		players[3] = new Player((EventIF) new AI(info, "lY"));
		// players[0] = new Player((EventIF) new Man(info));

		// vC[CfbNXɕϊz܂B
		kazeToPlayerIdx = new int[players.length];

		// UIɒ񋟂܂B
		infoUi = new InfoUI(this);

		// UI܂B
		ui = new Console(infoUi, "R\[");
	}

	/**
	 * ǂJn܂B
	 */
	private void startKyoku() {
		// [`_̐܂B
		reachbou = 0;

		// A܂B
		renchan = false;

		// Cxg𔭍s܂B
		fromKaze = oyaIdx;

		// Cxg̑ΏۂƂȂ܂B
		toKaze = oyaIdx;

		// vC[̎ݒ肵܂B
		setJikaze();

		// v܂B
		yama.xipai();

		// UICxgivj𔭍s܂B
		ui.event(EID.SENPAI, fromKaze, toKaze);

		// TCU܂B
		sais[0].saifuri();
		sais[1].saifuri();

		// RɊڂݒ肵܂B
		setWareme(sais);

		// vC[z܂B
		for (int i = 0; i < players.length; i++) {
			players[i].init();
		}

		// UICxgiTCUj𔭍s܂B
		ui.event(EID.SAIFURI, fromKaze, toKaze);

		// zv܂B
		haipai();

		// ǂ̃C[v
		EID retEid;
		MAINLOOP: while (true) {
			// c܂B
			tsumoHai = yama.tsumo();

			// cvȂꍇAǂ܂B
			if (tsumoHai == null) {
				// UICxgiǁj𔭍s܂B
				ui.event(EID.RYUUKYOKU, 0, 0);

				// eXV܂B
				oyaIdx++;
				if (oyaIdx >= players.length) {
					oyaIdx = 0;
				}

				break MAINLOOP;
			}

			// Cxgicj𔭍s܂B
			retEid = tsumoEvent();

			// Cxg܂B
			switch (retEid) {
			case TSUMOAGARI:// c
				// UICxgicj𔭍s܂B
				ui.event(retEid, fromKaze, toKaze);

				// TODO _𐴎Z܂B
				activePlayer.increaseTenbou(reachbou * 1000);

				// eXV܂B
				if (oyaIdx != kazeToPlayerIdx[fromKaze]) {
					oyaIdx++;
					if (oyaIdx >= players.length) {
						oyaIdx = 0;
					}
				} else {
					renchan = true;
					honba++;
				}

				break MAINLOOP;
			case RON:// 
				// UICxgij𔭍s܂B
				ui.event(retEid, fromKaze, toKaze);

				// TODO _𐴎Z܂B
				activePlayer.increaseTenbou(reachbou * 1000);

				// eXV܂B
				if (oyaIdx != kazeToPlayerIdx[fromKaze]) {
					oyaIdx++;
					if (oyaIdx >= players.length) {
						oyaIdx = 0;
					}
				} else {
					renchan = true;
					honba++;
				}

				break MAINLOOP;
			case REACH:// [`
				int tenbou = activePlayer.getTenbou();
				if (tenbou >= 1000) {
					activePlayer.reduceTenbou(1000);
					activePlayer.setReach(true);
					reachbou++;
				}
				break;
			default:
				break;
			}

			// Cxg𔭍sXV܂B
			fromKaze++;
			if (fromKaze >= players.length) {
				fromKaze = 0;
			}
		}
	}

	/**
	 * RɊڂݒ肵܂B
	 *
	 * @param sais
	 *            TCR̔z
	 */
	void setWareme(Sai[] sais) {
		int sum = sais[0].getNo() + sais[1].getNo() - 1;

		wareme = sum % 4;

		int startHaisIdx = ((sum % 4) * 36) + sum;

		yama.setTsumoHaisStartIdx(startHaisIdx);
	}

	/**
	 * vC[̎ݒ肵܂B
	 */
	private void setJikaze() {
		for (int i = 0, j = oyaIdx; i < players.length; i++, j++) {
			if (j >= players.length) {
				j = 0;
			}

			// vC[̎ݒ肵܂B
			players[j].setJikaze(i);

			// vC[CfbNXɕϊzݒ肵܂B
			kazeToPlayerIdx[i] = j;
		}
	}

	/**
	 * zv܂B
	 */
	private void haipai() {
		for (int i = 0, j = oyaIdx, max = players.length * 13; i < max; i++, j++) {
			if (j >= players.length) {
				j = 0;
			}

			players[j].getTehai().addJyunTehai(yama.tsumo());
		}
	}

	/**
	 * Cxgicj𔭍s܂B
	 *
	 * @return CxgID
	 */
	private EID tsumoEvent() {
		// ANeBuvC[ݒ肵܂B
		activePlayer = players[kazeToPlayerIdx[fromKaze]];

		// UICxgicj𔭍s܂B
		ui.event(EID.TSUMO, fromKaze, fromKaze);

		// Cxgicj𔭍s܂B
		EID retEid = activePlayer.getEventIf().event(EID.TSUMO, fromKaze,
				fromKaze);

		int sutehaiIdx;

		// Cxg܂B
		switch (retEid) {
		case TSUMOAGARI:// c
			break;
		case SUTEHAI:// ̔v
			// ̔ṽCfbNX擾܂B
			sutehaiIdx = activePlayer.getEventIf().getSutehaiIdx();
			if (sutehaiIdx == 13) {// c؂
				Hai.copy(suteHai, tsumoHai);
				activePlayer.getKawa().add(suteHai);
			} else {// o
				activePlayer.getTehai().copyJyunTehaiIdx(suteHai, sutehaiIdx);
				activePlayer.getTehai().rmJyunTehai(sutehaiIdx);
				activePlayer.getTehai().addJyunTehai(tsumoHai);
				activePlayer.getKawa().add(suteHai);
				activePlayer.getKawa().setTedashi(true);
			}

			// Cxgʒm܂B
			retEid = notifyEvent(EID.SUTEHAI, fromKaze, fromKaze);
			break;
		case REACH:
			// ̔ṽCfbNX擾܂B
			sutehaiIdx = activePlayer.getEventIf().getSutehaiIdx();
			if (sutehaiIdx == 13) {// c؂
				Hai.copy(suteHai, tsumoHai);
				activePlayer.getKawa().add(suteHai);
				activePlayer.getKawa().setReach(true);
			} else {// o
				activePlayer.getTehai().copyJyunTehaiIdx(suteHai, sutehaiIdx);
				activePlayer.getTehai().rmJyunTehai(sutehaiIdx);
				activePlayer.getTehai().addJyunTehai(tsumoHai);
				activePlayer.getKawa().add(suteHai);
				activePlayer.getKawa().setTedashi(true);
				activePlayer.getKawa().setReach(true);
			}

			// Cxgʒm܂B
			retEid = notifyEvent(EID.REACH, fromKaze, fromKaze);
			break;
		default:
			break;
		}

		return retEid;
	}

	/**
	 * Cxgʒm܂B
	 *
	 * @param eid
	 *            CxgID
	 * @param fromKaze
	 *            Cxg𔭍s
	 * @param toKaze
	 *            Cxg̑ΏۂƂȂ
	 * @return CxgID
	 */
	private EID notifyEvent(EID eid, int fromKaze, int toKaze) {
		EID retEid = EID.NAGASHI;

		// evC[ɃCxgʒmB
		NOTIFYLOOP: for (int i = 0, j = fromKaze; i < players.length; i++, j++) {
			if (j >= players.length) {
				j = 0;
			}

			// ANeBuvC[ݒ肵܂B
			activePlayer = players[kazeToPlayerIdx[j]];

			// UICxg𔭍s܂B
			ui.event(eid, fromKaze, toKaze);

			// Cxg𔭍s܂B
			retEid = activePlayer.getEventIf().event(eid, fromKaze, toKaze);

			// Cxg܂B
			switch (retEid) {
			case TSUMOAGARI:// c
				// ANeBuvC[ݒ肵܂B
				this.fromKaze = j;
				this.toKaze = toKaze;
				activePlayer = players[kazeToPlayerIdx[this.fromKaze]];
				break NOTIFYLOOP;
			case RON:// 
				// ANeBuvC[ݒ肵܂B
				this.fromKaze = j;
				this.toKaze = toKaze;
				activePlayer = players[kazeToPlayerIdx[this.fromKaze]];
				break NOTIFYLOOP;
			case PON:
				// ANeBuvC[ݒ肵܂B
				this.fromKaze = j;
				this.toKaze = fromKaze;
				activePlayer = players[kazeToPlayerIdx[this.fromKaze]];
				activePlayer.getTehai().setPon(suteHai);

				notifyEvent(EID.SUTEHAISELECT, this.fromKaze, this.toKaze);

				// ̔ṽCfbNX擾܂B
				int sutehaiIdx = activePlayer.getEventIf().getSutehaiIdx();
				activePlayer.getTehai().copyJyunTehaiIdx(suteHai, sutehaiIdx);
				activePlayer.getTehai().rmJyunTehai(sutehaiIdx);
				activePlayer.getKawa().add(suteHai);
				activePlayer.getKawa().setNaki(true);
				activePlayer.getKawa().setTedashi(true);

				// Cxgʒm܂B
				retEid = notifyEvent(EID.PON, this.fromKaze, this.toKaze);
				break NOTIFYLOOP;
			default:
				break;
			}
		}

		return retEid;
	}

	/*
	 * Info, InfoUIɒ񋟂API`܂B
	 */

	/**
	 * \hAȃh̔z擾܂B
	 *
	 * @return \hAȃh̔z
	 */
	Hai[] getDoras() {
		return getYama().getOmoteDoraHais();
	}

	/**
	 * \hAȃh̔z擾܂B
	 *
	 * @return \hAȃh̔z
	 */
	Hai[] getUraDoras() {
		return getYama().getUraDoraHais();
	}

	/**
	 * 擾܂B
	 */
	int getJikaze() {
		return activePlayer.getJikaze();
	}

	/**
	 * {擾܂B
	 *
	 * @return {
	 */
	int getHonba() {
		return honba;
	}

	/**
	 * [`擾܂B
	 *
	 * @param kaze
	 *            
	 * @return [`
	 */
	boolean isReach(int kaze) {
		return players[kazeToPlayerIdx[kaze]].isReach();
	}

	/**
	 * vRs[܂B
	 *
	 * @param tehai
	 *            v
	 * @param kaze
	 *            
	 */
	void copyTehai(Tehai tehai, int kaze) {
		if (activePlayer.getJikaze() == kaze) {
			Tehai.copy(tehai, activePlayer.getTehai(), true);
		} else {
			Tehai.copy(tehai, players[kazeToPlayerIdx[kaze]].getTehai(), false);
		}
	}

	/**
	 * ͂Rs[܂B
	 *
	 * @param kawa
	 *            
	 * @param kaze
	 *            
	 */
	void copyKawa(Kawa kawa, int kaze) {
		Kawa.copy(kawa, players[kazeToPlayerIdx[kaze]].getKawa());
	}

	/**
	 * c̎c萔擾܂B
	 *
	 * @return c̎c萔
	 */
	int getTsumoRemain() {
		return yama.getTsumoNokori();
	}

	String getName(int kaze) {
		return players[kazeToPlayerIdx[kaze]].getEventIf().getName();
	}

	int getTenbou(int kaze) {
		return players[kazeToPlayerIdx[kaze]].getTenbou();
	}

	int getWareme() {
		return wareme;
	}

	private Combi[] combis = new Combi[10];
	{
		for (int i = 0; i < combis.length; i++)
			combis[i] = new Combi();
	}

	public int getAgariScore(Tehai tehai, Hai addHai) {
		AgariSetting setting = new AgariSetting(this);
		AgariScore score = new AgariScore();
		return score.getAgariScore(tehai, addHai, combis, setting);
	}
	
	public String[] getYakuName(Tehai tehai, Hai addHai){
		AgariSetting setting = new AgariSetting(this);
		AgariScore score = new AgariScore();
		return score.getYakuName(tehai, addHai, combis, setting);	
	}
	
	
}
