package jp.sourceforge.andjong;

import android.content.res.Resources;
import jp.sourceforge.andjong.mahjong.Hai;
import jp.sourceforge.andjong.mahjong.Kawa;
import jp.sourceforge.andjong.mahjong.Mahjong;
import jp.sourceforge.andjong.mahjong.Tehai;
import jp.sourceforge.andjong.mahjong.EventIf.EventId;

/**
 * `ACeǗB
 *
 * @author Yuji Urushibara
 *
 */
public class DrawItem {
	/** ҂ */
	public static final int STATE_INIT_WAIT = 0;
	/** ԂȂ */
	public static final int STATE_NONE = 1;
	/** ǂ̊Jn */
	public static final int STATE_KYOKU_START = 2;
	/** vC */
	public static final int STATE_PLAY = 3;
	/** v҂ */
	public static final int STATE_RIHAI_WAIT = 4;
	/** [` */
	public static final int STATE_REACH = 5;
	/** c */
	public static final int STATE_TSUMO = 6;
	/**  */
	public static final int STATE_RON = 7;
	/**  */
	public static final int STATE_RYUUKYOKU = 8;
	/**  */
	public static final int STATE_RESULT = 9;
	/** I */
	public static final int STATE_END = 10;

	/**  */
	int m_state = STATE_INIT_WAIT;

	/** ǂ̕ */
	private String m_kyokuString = null;

	/** [`_̐ */
	private int m_reachbou = 0;

	/** { */
	private int m_honba = 0;

	/** N */
	private int m_chiicha = 0;

	/** v̂ĂṽCfbNX */
	private int m_iSkip = 0;

	/**
	 * ǂ̕ݒ肷B
	 *
	 * @param a_kyoku
	 *            
	 */
	public synchronized void setKyokuString(Resources a_resources, int a_kyoku) {
		if (a_kyoku > Mahjong.KYOKU_TON_4) {
			m_kyokuString = null;
			return;
		}

		String[] kyokuStrings = a_resources.getStringArray(R.array.kyoku);
		m_kyokuString = kyokuStrings[a_kyoku];
	}

	/**
	 * ǂ̕擾B
	 *
	 * @return ǂ̕
	 */
	public synchronized String getKyokuString() {
		return m_kyokuString;
	}

	/**
	 * [`_̐ݒ肷B
	 *
	 * @param a_reachbou
	 *            [`_̐
	 */
	public synchronized void setReachbou(int a_reachbou) {
		this.m_reachbou = a_reachbou;
	}

	/**
	 * [`_̐擾B
	 *
	 * @return [`_̐
	 */
	public synchronized int getReachbou() {
		return m_reachbou;
	}

	/**
	 * {ݒ肷B
	 *
	 * @param a_honba
	 *            {
	 */
	public synchronized void setHonba(int a_honba) {
		this.m_honba = a_honba;
	}

	/**
	 * {擾B
	 *
	 * @return {
	 */
	public synchronized int getHonba() {
		return m_honba;
	}

	/**
	 * NƂݒ肷B
	 *
	 * @param a_chiicha
	 *            N
	 */
	public synchronized void setChiicha(int a_chiicha) {
		this.m_chiicha = a_chiicha;
	}

	/**
	 * NƂ擾B
	 *
	 * @return N
	 */
	public synchronized int getChiicha() {
		return m_chiicha;
	}

	/**
	 * v̂ĂṽCfbNXݒ肷B
	 *
	 * @param a_iSkip
	 *            v̂ĂṽCfbNX
	 */
	public synchronized void setSkipIdx(int a_iSkip) {
		this.m_iSkip = a_iSkip;
	}

	/**
	 * v̂ĂṽCfbNX擾B
	 *
	 * @return v̂ĂṽCfbNX
	 */
	public synchronized int getSkipIdx() {
		return m_iSkip;
	}

	/**
	 * Ԃݒ肷B
	 *
	 * @param m_state
	 *            
	 */
	synchronized void setState(int m_state) {
		this.m_state = m_state;
	}

	/**
	 * Ԃ擾B
	 *
	 * @return 
	 */
	synchronized int getState() {
		return m_state;
	}

	public class PlayerInfo {
		/** v */
		Tehai m_tehai = new Tehai();
		/**  */
		Kawa m_kawa = new Kawa();
		/** cv */
		Hai m_tsumoHai;
		/** __ */
		int m_tenbo;
		boolean m_tenpai;
	}

	/** vC[ */
	PlayerInfo m_playerInfos[] = new PlayerInfo[4];

	/** fobOtO */
	boolean m_isDebug = false;

	/** CxgID */
	EventId m_eventId;

	int m_kazeFrom;
	int m_kazeTo;

	Hai m_suteHai = new Hai();

	boolean m_isManReach = false;

	{
		for (int i = 0; i < 4; i++) {
			m_playerInfos[i] = new PlayerInfo();
		}
	}
}
