# -*- coding: utf-8 -*-

# GUIのメインフレーム
# 2013/12/15 written by kei9
import wx
from wx import xrc
import wx.grid

import constnumbers
from notebookflowview import NoteBookFlowView
from notebooksettingview import NoteBookSettingView
from notebookseed1view import NoteBookSeed1View
from notebookseed2view import NoteBookSeed2View
from notebookskill2view import NoteBookSkill2View
from notebookamuletview import NoteBookAmuletView

class MainFrameView():
    u""" メインのフレームクラス """
    def __init__(self, filename):
        self.res = wx.xrc.XmlResource(filename)
        self._init_frame()

    def _init_frame(self):
        # load controls
        self.frame = self.res.LoadFrame(None, "MainFrame")
        self.note_book = xrc.XRCCTRL(self.frame, "NoteBookMain")

        # menu
        self.ID_MENU_ITEM_EXIT = xrc.XRCID("wxID_EXIT") # same as wx.ID_EXIT
        self.ID_MENU_ITEM_ABOUT = xrc.XRCID("wxID_ABOUT") # same as wx.ID_ABOUT

        # seed1 decision view
        self.notebook_seed1_view = NoteBookSeed1View(self.frame)

        # seed2 decision view
        self.notebook_seed2_view = NoteBookSeed2View(self.frame)

        # skill2 search from seed2 view
        self.notebook_skill2_view = NoteBookSkill2View(self.frame)

        # amulet view
        self.notebook_amulet_view = NoteBookAmuletView(self.frame)

        # flow view
        self.notebook_flow_view = NoteBookFlowView(self.frame)

        # setting view
        self.notebook_setting_view = NoteBookSettingView(self.frame)

    def Show(self):
        self.frame.Show()

    def Close(self):
        self.frame.Close(True)

    def DisableNoteBook(self):
        self.note_book.Disable()

    def EnableNoteBook(self):
        self.note_book.Enable()

    def OnAboutBox(self, evt):
        u""" Show About Box """
        info = wx.AboutDialogInfo()
        info.Name = constnumbers.NAME
        info.Version = constnumbers.VERSION
        info.Copyright = constnumbers.COPYRIGHT
        info.Description = constnumbers.DESCRIPTION
        info.WebSite = (constnumbers.WEBSITE_LINK, constnumbers.WEBSITE_TEXT)
        info.Developers = constnumbers.DEVELOPERS
        info.License = constnumbers.LICENSE_TEXT
        wx.AboutBox(info)

    def GetAboutInfo(self):
        u""" create About info """
        info = wx.AboutDialogInfo()
        info.Name = constnumbers.NAME
        info.Version = constnumbers.VERSION
        info.Copyright = constnumbers.COPYRIGHT
        info.Description = constnumbers.DESCRIPTION
        info.WebSite = (constnumbers.WEBSITE_LINK, constnumbers.WEBSITE_TEXT)
        info.Developers = constnumbers.DEVELOPERS
        info.License = constnumbers.LICENSE_TEXT
        return info

if __name__ == "__main__":
    app = wx.App(False)
    mainframe = MainFrameView(u"mainframe.xrc")
    mainframe.Show()
    app.MainLoop()
