# -*- coding: utf-8 -*-

# 進行状況をゲージで示すダイアログ
# 2013/12/05 written by kei9
import wx
from wx import xrc

import constnumbers

class GaugeDialogView():
    u""" メインのフレームクラス """
    def __init__(self, filename):
        self.res = wx.xrc.XmlResource(filename)
        self._init_dialog()

    def _init_dialog(self):
        # load controls
        self.dialog = self.res.LoadDialog(None, "GaugeDialog")
        self.label = xrc.XRCCTRL(self.dialog, "LabelGaugeDialog")
        self.gauge = xrc.XRCCTRL(self.dialog, "GaugeProgress")
        self.button = xrc.XRCCTRL(self.dialog, "wxID_OK")

        self.ID_BUTTON_OK = xrc.XRCID("wxID_OK")
        # "self.ID_BUTTON_OK" same as "wx.ID_OK"

    def ShowModal(self):
        self.button.Disable()
        self.label.SetLabel(u"データベースの生成中...　　")
        self.ret_code = self.dialog.ShowModal()
        return self.ret_code

    def finish_generation(self):
        self.button.Enable()
        self.label.SetLabel(u"データベースの生成中...完了")

    def Destroy(self):
        self.dialog.Destroy()

