# -*- coding: utf-8 -*-

# Random Seedを保持するクラス
# 2013/12/04 written by kei9 

import db_supports

class SeedsHolder(object):
    u""" Seed値を保持するクラス """
    def __init__(self, seed_list):
        u""" seed_list: list of seed
        """
        self.seed_set = set(seed_list)

    def get_where_in_sql(self, remove_where=False):
        u""" SQLのWhere文に変換する(IN句) """
        if len(self.seed_set) >= 1:
            uni_list = [u"{0}".format(x) for x in self.seed_set]
            sql = u" {col} IN({in_phrase})".format(
                    col=db_supports.SEED2_SKILL2_COL_SEED2,
                    in_phrase=u",".join(uni_list))

            if remove_where:
                return sql
            else:
                return u" where" + sql
        else:
            return ""


