/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.util;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sf.amateras.mirage.annotation.Column;
import jp.sf.amateras.mirage.annotation.PrimaryKey;
import jp.sf.amateras.mirage.annotation.Table;
import jp.sf.amateras.mirage.bean.BeanDesc;
import jp.sf.amateras.mirage.bean.BeanDescFactory;
import jp.sf.amateras.mirage.bean.PropertyDesc;
import jp.sf.amateras.mirage.dialect.Dialect;
import jp.sf.amateras.mirage.naming.NameConverter;
import jp.sf.amateras.mirage.type.ValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MirageUtil {
    public static <T> T createEntity(Class<T> clazz, ResultSet rs, ResultSetMetaData meta, int columnCount, BeanDesc beanDesc, Dialect dialect, List<ValueType> valueTypes, NameConverter nameConverter) throws InstantiationException, IllegalAccessException, SQLException {
        ValueType valueType;
        if (dialect.getValueType() != null && (valueType = dialect.getValueType()).isSupport(clazz)) {
            return (T)valueType.get(clazz, rs, 1);
        }
        for (ValueType valueType2 : valueTypes) {
            if (!valueType2.isSupport(clazz)) continue;
            return (T)valueType2.get(clazz, rs, 1);
        }
        HashMap entity = null;
        entity = clazz == Map.class ? new HashMap() : (HashMap)clazz.newInstance();
        block1: for (int i = 0; i < columnCount; ++i) {
            ValueType valueType3;
            String columnName = meta.getColumnName(i + 1);
            String propertyName = nameConverter.columnToProperty(columnName);
            PropertyDesc pd = beanDesc.getPropertyDesc(propertyName);
            if (pd == null) continue;
            Class<?> fieldType = pd.getPropertyType();
            if (dialect.getValueType() != null && (valueType3 = dialect.getValueType()).isSupport(clazz)) {
                pd.setValue(entity, valueType3.get(fieldType, rs, columnName));
                break;
            }
            for (ValueType valueType4 : valueTypes) {
                if (!valueType4.isSupport(fieldType)) continue;
                pd.setValue(entity, valueType4.get(fieldType, rs, columnName));
                continue block1;
            }
        }
        return (T)entity;
    }

    public static String getTableName(Class<?> entityClass, NameConverter nameConverter) {
        Table table = entityClass.getAnnotation(Table.class);
        if (table != null) {
            return table.name();
        }
        return nameConverter.entityToTable(entityClass.getName());
    }

    public static String getColumnName(PropertyDesc pd, NameConverter nameConverter) {
        Column column = pd.getAnnotation(Column.class);
        if (column != null) {
            return column.name();
        }
        return nameConverter.propertyToColumn(pd.getPropertyName());
    }

    public static String buildSelectSQL(Class<?> clazz, NameConverter nameConverter) {
        StringBuilder sb = new StringBuilder();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(clazz);
        sb.append("SELECT * FROM ");
        sb.append(MirageUtil.getTableName(clazz, nameConverter));
        sb.append(" WHERE ");
        int count = 0;
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (pd.getAnnotation(PrimaryKey.class) == null) continue;
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(MirageUtil.getColumnName(pd, nameConverter));
            sb.append(" = ?");
            ++count;
        }
        if (count == 0) {
            throw new RuntimeException("Primary key is not found: " + clazz.getName());
        }
        return sb.toString();
    }

    public static String buildInsertSql(Object entity, NameConverter nameConverter, List<Object> params) {
        PrimaryKey primaryKey;
        PropertyDesc pd;
        int i;
        StringBuilder sb = new StringBuilder();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(entity.getClass());
        sb.append("INSERT INTO ").append(MirageUtil.getTableName(entity.getClass(), nameConverter)).append(" (");
        int count = 0;
        for (i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            pd = beanDesc.getPropertyDesc(i);
            primaryKey = pd.getAnnotation(PrimaryKey.class);
            if (primaryKey != null && !primaryKey.persistent() || pd.isTransient() || !pd.isReadable()) continue;
            if (count != 0) {
                sb.append(", ");
            }
            sb.append(MirageUtil.getColumnName(pd, nameConverter));
            ++count;
        }
        sb.append(") VALUES (");
        count = 0;
        for (i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            pd = beanDesc.getPropertyDesc(i);
            primaryKey = pd.getAnnotation(PrimaryKey.class);
            if (primaryKey != null && !primaryKey.persistent() || pd.isTransient() || !pd.isReadable()) continue;
            if (count != 0) {
                sb.append(", ");
            }
            sb.append("?");
            try {
                params.add(pd.getValue(entity));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            ++count;
        }
        sb.append(")");
        return sb.toString();
    }

    public static String buildUpdateSql(Object entity, NameConverter nameConverter, List<Object> params) {
        PropertyDesc pd;
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ").append(MirageUtil.getTableName(entity.getClass(), nameConverter)).append(" SET ");
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(entity.getClass());
        int count = 0;
        for (i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            pd = beanDesc.getPropertyDesc(i);
            if (pd.getAnnotation(PrimaryKey.class) != null || pd.isTransient() || !pd.isReadable()) continue;
            if (count != 0) {
                sb.append(", ");
            }
            sb.append(MirageUtil.getColumnName(pd, nameConverter)).append(" = ?");
            try {
                params.add(pd.getValue(entity));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            ++count;
        }
        sb.append(" WHERE ");
        count = 0;
        for (i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            pd = beanDesc.getPropertyDesc(i);
            if (pd.getAnnotation(PrimaryKey.class) == null || !pd.isReadable()) continue;
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(MirageUtil.getColumnName(pd, nameConverter)).append(" = ? ");
            try {
                params.add(pd.getValue(entity));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            ++count;
        }
        if (count == 0) {
            throw new RuntimeException("Primary key is not found: " + entity.getClass().getName());
        }
        return sb.toString();
    }

    public static String buildDeleteSql(Object entity, NameConverter nameConverter, List<Object> params) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ").append(MirageUtil.getTableName(entity.getClass(), nameConverter));
        sb.append(" WHERE ");
        boolean hasPrimaryKey = false;
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(entity.getClass());
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (pd.getAnnotation(PrimaryKey.class) == null || !pd.isReadable()) continue;
            if (!params.isEmpty()) {
                sb.append(" AND ");
            }
            sb.append(MirageUtil.getColumnName(pd, nameConverter)).append("=?");
            try {
                params.add(pd.getValue(entity));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            hasPrimaryKey = true;
        }
        if (!hasPrimaryKey) {
            throw new RuntimeException("Primary key is not found: " + entity.getClass().getName());
        }
        return sb.toString();
    }
}

