/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.deliver.DeliverEngine;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.install.InstallEngine;
import org.apache.ivy.core.publish.PublishEngine;
import org.apache.ivy.core.repository.RepositoryManagementEngine;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.retrieve.RetrieveEngine;
import org.apache.ivy.core.search.SearchEngine;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.core.sort.SortEngine;
import org.apache.ivy.plugins.repository.TransferEvent;
import org.apache.ivy.plugins.repository.TransferListener;
import org.apache.ivy.plugins.resolver.BasicResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.trigger.Trigger;
import org.apache.ivy.util.HostUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.MessageLoggerEngine;

public class Ivy {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final String IVY_VERSION;
    private static final String IVY_DATE;
    private boolean interrupted;
    private boolean bound;
    private IvySettings settings;
    private EventManager eventManager;
    private SortEngine sortEngine;
    private SearchEngine searchEngine;
    private ResolveEngine resolveEngine;
    private RetrieveEngine retrieveEngine;
    private DeliverEngine deliverEngine;
    private PublishEngine publishEngine;
    private InstallEngine installEngine;
    private RepositoryManagementEngine repositoryEngine;
    private MessageLoggerEngine loggerEngine = new MessageLoggerEngine();

    public static String getIvyVersion() {
        return IVY_VERSION;
    }

    public static String getIvyHomeURL() {
        return "http://ant.apache.org/ivy/";
    }

    public static Ivy newInstance() {
        Ivy ivy = new Ivy();
        ivy.bind();
        return ivy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind() {
        this.pushContext();
        try {
            if (this.settings == null) {
                this.settings = new IvySettings();
            }
            if (this.eventManager == null) {
                this.eventManager = new EventManager();
            }
            if (this.sortEngine == null) {
                this.sortEngine = new SortEngine(this.settings);
            }
            if (this.searchEngine == null) {
                this.searchEngine = new SearchEngine(this.settings);
            }
            if (this.resolveEngine == null) {
                this.resolveEngine = new ResolveEngine(this.settings, this.eventManager, this.sortEngine);
            }
            if (this.retrieveEngine == null) {
                this.retrieveEngine = new RetrieveEngine(this.settings, this.eventManager);
            }
            if (this.deliverEngine == null) {
                this.deliverEngine = new DeliverEngine(this.settings);
            }
            if (this.publishEngine == null) {
                this.publishEngine = new PublishEngine(this.settings, this.eventManager);
            }
            if (this.installEngine == null) {
                this.installEngine = new InstallEngine(this.settings, this.searchEngine, this.resolveEngine);
            }
            if (this.repositoryEngine == null) {
                this.repositoryEngine = new RepositoryManagementEngine(this.settings, this.searchEngine, this.resolveEngine);
            }
            this.eventManager.addTransferListener(new TransferListener(){

                public void transferProgress(TransferEvent evt) {
                    switch (evt.getEventType()) {
                        case 3: {
                            ResolveData resolve2 = IvyContext.getContext().getResolveData();
                            if (resolve2 != null && "quiet".equals(resolve2.getOptions().getLog())) break;
                            Message.progress();
                            break;
                        }
                        case 2: {
                            ResolveData resolve2 = IvyContext.getContext().getResolveData();
                            if (resolve2 != null && "quiet".equals(resolve2.getOptions().getLog())) break;
                            Message.endProgress(" (" + evt.getTotalLength() / 1024L + "kB)");
                            break;
                        }
                    }
                }
            });
            this.bound = true;
        }
        finally {
            this.popContext();
        }
    }

    public void pushContext() {
        if (IvyContext.getContext().peekIvy() != this) {
            IvyContext.pushNewContext();
            IvyContext.getContext().setIvy(this);
        } else {
            IvyContext.pushContext(IvyContext.getContext());
        }
    }

    public void popContext() {
        IvyContext.popContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureDefault() throws ParseException, IOException {
        this.pushContext();
        try {
            this.assertBound();
            this.settings.loadDefault();
            this.postConfigure();
        }
        finally {
            this.popContext();
        }
    }

    public synchronized boolean isInterrupted() {
        return this.interrupted;
    }

    public void checkInterrupted() {
        if (this.isInterrupted()) {
            Message.info("operation interrupted");
            throw new RuntimeException("operation interrupted");
        }
    }

    public static String getWorkingRevision() {
        return "working@" + HostUtil.getLocalHostName();
    }

    private void assertBound() {
        if (!this.bound) {
            this.bind();
        }
    }

    private void postConfigure() {
        List triggers = this.settings.getTriggers();
        Iterator iter = triggers.iterator();
        while (iter.hasNext()) {
            Trigger trigger = (Trigger)iter.next();
            this.eventManager.addIvyListener(trigger, trigger.getEventFilter());
        }
        iter = this.settings.getResolvers().iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            if (!(resolver instanceof BasicResolver)) continue;
            ((BasicResolver)resolver).setEventManager(this.eventManager);
        }
    }

    public IvySettings getSettings() {
        return this.settings;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public ResolveEngine getResolveEngine() {
        return this.resolveEngine;
    }

    public void setSettings(IvySettings settings) {
        this.settings = settings;
    }

    public MessageLoggerEngine getLoggerEngine() {
        return this.loggerEngine;
    }

    static {
        Properties props = new Properties();
        URL moduleURL = Message.class.getResource("/module.properties");
        if (moduleURL != null) {
            try {
                InputStream module = moduleURL.openStream();
                props.load(module);
                module.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        IVY_VERSION = props.getProperty("version", "non official version");
        IVY_DATE = props.getProperty("date", "");
    }
}

