/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import org.h2.command.Prepared;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.result.RowList;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;

public class Delete
extends Prepared {
    private Expression condition;
    private TableFilter tableFilter;

    public Delete(Session session) {
        super(session);
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.tableFilter = tableFilter;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update() throws SQLException {
        this.tableFilter.startQuery(this.session);
        this.tableFilter.reset();
        Table table = this.tableFilter.getTable();
        this.session.getUser().checkRight(table, 2);
        table.fireBefore(this.session);
        table.lock(this.session, true, false);
        RowList rows = new RowList(this.session);
        try {
            Row row;
            this.setCurrentRowNumber(0);
            while (this.tableFilter.next()) {
                this.checkCancelled();
                this.setCurrentRowNumber(rows.size() + 1);
                if (this.condition != null && !Boolean.TRUE.equals(this.condition.getBooleanValue(this.session))) continue;
                row = this.tableFilter.get();
                if (table.fireRow()) {
                    table.fireBeforeRow(this.session, row, null);
                }
                rows.add(row);
            }
            rows.reset();
            while (rows.hasNext()) {
                this.checkCancelled();
                row = rows.next();
                table.removeRow(this.session, row);
                this.session.log(table, (short)1, row);
            }
            if (table.fireRow()) {
                rows.reset();
                while (rows.hasNext()) {
                    row = rows.next();
                    table.fireAfterRow(this.session, row, null);
                }
            }
            table.fireAfter(this.session);
            int n = rows.size();
            return n;
        }
        finally {
            rows.close();
        }
    }

    public String getPlanSQL() {
        StringBuffer buff = new StringBuffer();
        buff.append("DELETE FROM ");
        buff.append(this.tableFilter.getPlanSQL(false));
        if (this.condition != null) {
            buff.append("\nWHERE " + StringUtils.unEnclose(this.condition.getSQL()));
        }
        return buff.toString();
    }

    public void prepare() throws SQLException {
        if (this.condition != null) {
            this.condition.mapColumns(this.tableFilter, 0);
            this.condition = this.condition.optimize(this.session);
            this.condition.createIndexConditions(this.session, this.tableFilter);
        }
        PlanItem item = this.tableFilter.getBestPlanItem(this.session);
        this.tableFilter.setPlanItem(item);
        this.tableFilter.prepare();
    }

    public boolean isTransactional() {
        return true;
    }

    public LocalResult queryMeta() {
        return null;
    }
}

