/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.util;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.seasar.extension.jdbc.util.ColumnDesc;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.util.CaseInsensitiveMap;
import org.seasar.framework.util.CaseInsensitiveSet;

public class DatabaseMetaDataUtil {
    protected DatabaseMetaDataUtil() {
    }

    public static String[] getPrimaryKeys(DatabaseMetaData dbMetaData, String tableName) {
        Set set = DatabaseMetaDataUtil.getPrimaryKeySet(dbMetaData, tableName);
        return set.toArray(new String[set.size()]);
    }

    public static Set getPrimaryKeySet(DatabaseMetaData dbMetaData, String tableName) {
        String schema;
        int index = tableName.indexOf(46);
        if (index >= 0) {
            schema = tableName.substring(0, index);
            tableName = tableName.substring(index + 1);
        } else {
            schema = DatabaseMetaDataUtil.getUserName(dbMetaData);
        }
        String convertedTableName = DatabaseMetaDataUtil.convertIdentifier(dbMetaData, tableName);
        CaseInsensitiveSet set = new CaseInsensitiveSet();
        DatabaseMetaDataUtil.addPrimaryKeys(dbMetaData, DatabaseMetaDataUtil.convertIdentifier(dbMetaData, schema), convertedTableName, (Set)set);
        if (set.size() == 0) {
            DatabaseMetaDataUtil.addPrimaryKeys(dbMetaData, schema, tableName, (Set)set);
        }
        if (set.size() == 0 && schema != null) {
            DatabaseMetaDataUtil.addPrimaryKeys(dbMetaData, null, convertedTableName, (Set)set);
            if (set.size() == 0) {
                DatabaseMetaDataUtil.addPrimaryKeys(dbMetaData, null, tableName, (Set)set);
            }
        }
        return set;
    }

    public static Set getPrimaryKeySet(DatabaseMetaData dbMetaData, String schema, String tableName) {
        CaseInsensitiveSet set = new CaseInsensitiveSet();
        DatabaseMetaDataUtil.addPrimaryKeys(dbMetaData, schema, tableName, (Set)set);
        return set;
    }

    public static String getUserName(DatabaseMetaData dbMetaData) {
        try {
            return dbMetaData.getUserName();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    private static void addPrimaryKeys(DatabaseMetaData dbMetaData, String schema, String tableName, Set set) {
        try {
            ResultSet rs = dbMetaData.getPrimaryKeys(null, schema, tableName);
            while (rs.next()) {
                set.add(rs.getString(4));
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static String[] getColumns(DatabaseMetaData dbMetaData, String tableName) {
        Map map = DatabaseMetaDataUtil.getColumnMap(dbMetaData, tableName);
        String[] ret = new String[map.size()];
        int index = 0;
        Iterator i = map.values().iterator();
        while (i.hasNext()) {
            ColumnDesc cd = (ColumnDesc)i.next();
            ret[index++] = cd.getName();
        }
        return ret;
    }

    public static Map getColumnMap(DatabaseMetaData dbMetaData, String tableName) {
        return DatabaseMetaDataUtil.getColumnCaseInsensitiveMap(dbMetaData, tableName);
    }

    public static CaseInsensitiveMap getColumnCaseInsensitiveMap(DatabaseMetaData dbMetaData, String tableName) {
        String schema;
        int index = tableName.indexOf(46);
        if (index >= 0) {
            schema = tableName.substring(0, index);
            tableName = tableName.substring(index + 1);
        } else {
            schema = DatabaseMetaDataUtil.getUserName(dbMetaData);
        }
        String convertedTableName = DatabaseMetaDataUtil.convertIdentifier(dbMetaData, tableName);
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        DatabaseMetaDataUtil.addColumns(dbMetaData, DatabaseMetaDataUtil.convertIdentifier(dbMetaData, schema), convertedTableName, (Map)map);
        if (map.size() == 0) {
            DatabaseMetaDataUtil.addColumns(dbMetaData, schema, tableName, (Map)map);
        }
        if (map.size() == 0 && schema != null) {
            DatabaseMetaDataUtil.addColumns(dbMetaData, null, convertedTableName, (Map)map);
            if (map.size() == 0) {
                DatabaseMetaDataUtil.addColumns(dbMetaData, null, tableName, (Map)map);
            }
        }
        return map;
    }

    public static CaseInsensitiveMap getColumnMap(DatabaseMetaData dbMetaData, String schema, String tableName) {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        DatabaseMetaDataUtil.addColumns(dbMetaData, schema, tableName, (Map)map);
        return map;
    }

    private static void addColumns(DatabaseMetaData dbMetaData, String schema, String tableName, Map map) {
        try {
            ResultSet rs = dbMetaData.getColumns(null, schema, tableName, null);
            while (rs.next()) {
                ColumnDesc cd = new ColumnDesc();
                cd.setName(rs.getString(4));
                cd.setSqlType(rs.getInt(5));
                map.put(cd.getName(), cd);
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static String convertIdentifier(DatabaseMetaData dbMetaData, String identifier) {
        if (identifier == null) {
            return null;
        }
        if (!DatabaseMetaDataUtil.supportsMixedCaseIdentifiers(dbMetaData)) {
            if (DatabaseMetaDataUtil.storesUpperCaseIdentifiers(dbMetaData)) {
                return identifier.toUpperCase();
            }
            return identifier.toLowerCase();
        }
        return identifier;
    }

    public static boolean supportsMixedCaseIdentifiers(DatabaseMetaData dbMetaData) throws SQLRuntimeException {
        try {
            return dbMetaData.supportsMixedCaseIdentifiers();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static boolean storesUpperCaseIdentifiers(DatabaseMetaData dbMetaData) throws SQLRuntimeException {
        try {
            return dbMetaData.storesUpperCaseIdentifiers();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static boolean storesLowerCaseIdentifiers(DatabaseMetaData dbMetaData) throws SQLRuntimeException {
        try {
            return dbMetaData.storesLowerCaseIdentifiers();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static boolean supportsSchemasInTableDefinitions(DatabaseMetaData dbMetaData) throws SQLRuntimeException {
        try {
            return dbMetaData.supportsSchemasInTableDefinitions();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static boolean supportsGetGeneratedKeys(DatabaseMetaData dbMetaData) {
        try {
            return dbMetaData.supportsGetGeneratedKeys();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }

    public static String getDatabaseProductName(DatabaseMetaData dbMetaData) {
        try {
            return dbMetaData.getDatabaseProductName();
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }
}

