/*
 * Copyright 2004-2008 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.amateras.rdiffbackup.action;

import java.util.List;

import javax.annotation.Resource;

import jp.sf.amateras.rdiffbackup.entity.BackupDir;
import jp.sf.amateras.rdiffbackup.form.IndexForm;
import jp.sf.amateras.rdiffbackup.service.ConfigService;

import org.seasar.framework.util.LongConversionUtil;
import org.seasar.struts.annotation.ActionForm;
import org.seasar.struts.annotation.Execute;

/**
 * アプリケーションのインデックスアクションです。
 * 登録されているバックアップディレクトリを一覧表示します。
 *
 * @author Naoki Takezoe
 */
public class IndexAction {

	///////////////////////////////////////////////////////////////
	// 表示用プロパティ
	///////////////////////////////////////////////////////////////

	/**
	 * バックアップディレクトリのリスト
	 */
	public List<BackupDir> backupDirList;

	///////////////////////////////////////////////////////////////
	// DI用プロパティ
	///////////////////////////////////////////////////////////////

	/**
	 * アクションフォーム
	 */
	@Resource
	@ActionForm
	protected IndexForm indexForm;

	/**
	 * アプリケーションの設定
	 */
	@Resource
	protected ConfigService configService;

	///////////////////////////////////////////////////////////////
	// 実行メソッド
	///////////////////////////////////////////////////////////////

	/**
	 * バックアップディレクトリの一覧を表示します。
	 *
	 * @return "index.jsp"
	 */
    @Execute(validator = false)
	public String index() {
    	this.backupDirList = configService.getBackupDirList();

        return "index.jsp";
	}

    /**
     * バックアップディレクトリを追加します。
     *
     * @return "index/?redirect=true"
     */
    @Execute(validator = true, input="index/")
    public String add(){
    	configService.addBackupDir(indexForm.directory, indexForm.description);

    	return "index/?redirect=true";
    }

    /**
     * バックアップディレクトリを削除します。
     *
     * @return "index/?redirect=true"
     */
    @Execute(validator = true, input="index/")
    public String remove(){
    	configService.removeBackupDir(LongConversionUtil.toLong(indexForm.id));

    	return "index/?redirect=true";
    }

    /**
     * バックアップディレクトリの編集画面に遷移します。
     *
     * @return "edit.jsp"
     */
    @Execute(validator = true, input="index/")
    public String edit(){
    	BackupDir backupDir = configService.getBackupDir(LongConversionUtil.toLong(indexForm.id));

    	indexForm.id = backupDir.id.toString();
    	indexForm.directory = backupDir.directory;
    	indexForm.description = backupDir.description;

    	return "edit.jsp";
    }

    /**
     * バックアップディレクトリを更新します。
     *
     * @return "index/?redirect=true"
     */
    @Execute(validator = true, input="edit.jsp")
    public String update(){
    	configService.updateBackupDir(LongConversionUtil.toLong(indexForm.id),
    			indexForm.directory, indexForm.description);

    	return "index/?redirect=true";
    }

    /**
     * バックアップディレクトリの編集をキャンセルしてトップ画面にリダイレクトします。
     *
     * @return "index/?redirect=true"
     */
    @Execute(validator = false)
    public String cancel(){
    	return "index/?redirect=true";
    }

}
