/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptorMediator;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.descriptor.OverrideDependencyDescriptorMediator;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.matcher.MapMatcher;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.XMLHelper;
import org.apache.ivy.util.extendable.ExtendableItem;
import scala.Function1;
import scala.collection.TraversableLike;
import scala.collection.TraversableLike$WithFilter$$anonfun$foreach$1;
import scala.collection.generic.FilterMonadic;

public class XmlModuleDescriptorWriter
implements FilterMonadic {
    public final Function1 scala$collection$TraversableLike$WithFilter$$p;
    private /* synthetic */ TraversableLike $outer;

    private XmlModuleDescriptorWriter() {
    }

    public static void write(ModuleDescriptor moduleDescriptor, File file2) {
        File file3 = file2;
        ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
        if (file3.getParentFile() != null) {
            file3.getParentFile().mkdirs();
        }
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file3), "UTF-8"));
        try {
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            StringBuffer stringBuffer = new StringBuffer();
            Object object = moduleDescriptor2.getExtraAttributesNamespaces().entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = object.next();
                stringBuffer.append(" xmlns:").append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
            }
            object = "2.0";
            if (moduleDescriptor2.getInheritedDescriptors().length > 0) {
                object = "2.2";
            }
            printWriter.println("<ivy-module version=\"" + (String)object + "\"" + stringBuffer + ">");
            XmlModuleDescriptorWriter.printInfoTag(moduleDescriptor2, printWriter);
            XmlModuleDescriptorWriter.printConfigurations(moduleDescriptor2, printWriter);
            XmlModuleDescriptorWriter.printPublications(moduleDescriptor2, printWriter);
            XmlModuleDescriptorWriter.printDependencies(moduleDescriptor2, printWriter);
            printWriter.println("</ivy-module>");
            return;
        }
        finally {
            printWriter.close();
        }
    }

    private static void printDependencies(ModuleDescriptor moduleDescriptor, PrintWriter printWriter) {
        DependencyDescriptor[] dependencyDescriptorArray = moduleDescriptor.getDependencies();
        if (dependencyDescriptorArray.length > 0) {
            printWriter.println("\t<dependencies>");
            for (int i = 0; i < dependencyDescriptorArray.length; ++i) {
                Object[] objectArray;
                DependencyDescriptor dependencyDescriptor = dependencyDescriptorArray[i];
                printWriter.print("\t\t");
                PrintWriter printWriter2 = printWriter;
                DependencyDescriptor dependencyDescriptor2 = dependencyDescriptor;
                ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
                printWriter2.print("<dependency");
                printWriter2.print(" org=\"" + XMLHelper.escape(dependencyDescriptor2.getDependencyRevisionId().getOrganisation()) + "\"");
                printWriter2.print(" name=\"" + XMLHelper.escape(dependencyDescriptor2.getDependencyRevisionId().getName()) + "\"");
                if (dependencyDescriptor2.getDependencyRevisionId().getBranch() != null) {
                    printWriter2.print(" branch=\"" + XMLHelper.escape(dependencyDescriptor2.getDependencyRevisionId().getBranch()) + "\"");
                }
                printWriter2.print(" rev=\"" + XMLHelper.escape(dependencyDescriptor2.getDependencyRevisionId().getRevision()) + "\"");
                if (!dependencyDescriptor2.getDynamicConstraintDependencyRevisionId().equals(dependencyDescriptor2.getDependencyRevisionId())) {
                    if (dependencyDescriptor2.getDynamicConstraintDependencyRevisionId().getBranch() != null) {
                        printWriter2.print(" branchConstraint=\"" + XMLHelper.escape(dependencyDescriptor2.getDynamicConstraintDependencyRevisionId().getBranch()) + "\"");
                    }
                    printWriter2.print(" revConstraint=\"" + XMLHelper.escape(dependencyDescriptor2.getDynamicConstraintDependencyRevisionId().getRevision()) + "\"");
                }
                if (dependencyDescriptor2.isForce()) {
                    printWriter2.print(" force=\"" + dependencyDescriptor2.isForce() + "\"");
                }
                if (dependencyDescriptor2.isChanging()) {
                    printWriter2.print(" changing=\"" + dependencyDescriptor2.isChanging() + "\"");
                }
                if (!dependencyDescriptor2.isTransitive()) {
                    printWriter2.print(" transitive=\"" + dependencyDescriptor2.isTransitive() + "\"");
                }
                printWriter2.print(" conf=\"");
                String[] stringArray = dependencyDescriptor2.getModuleConfigurations();
                for (int j = 0; j < stringArray.length; ++j) {
                    objectArray = dependencyDescriptor2.getDependencyConfigurations(stringArray[j]);
                    printWriter2.print(XMLHelper.escape(stringArray[j]) + "->");
                    for (int k = 0; k < objectArray.length; ++k) {
                        printWriter2.print(XMLHelper.escape((String)objectArray[k]));
                        if (k + 1 >= objectArray.length) continue;
                        printWriter2.print(",");
                    }
                    if (j + 1 >= stringArray.length) continue;
                    printWriter2.print(";");
                }
                printWriter2.print("\"");
                XmlModuleDescriptorWriter.printExtraAttributes(dependencyDescriptor2, printWriter2, " ");
                DependencyArtifactDescriptor[] dependencyArtifactDescriptorArray = dependencyDescriptor2.getAllDependencyArtifacts();
                if (dependencyArtifactDescriptorArray.length > 0) {
                    printWriter2.println(">");
                }
                XmlModuleDescriptorWriter.printDependencyArtefacts(moduleDescriptor2, printWriter2, dependencyArtifactDescriptorArray);
                objectArray = dependencyDescriptor2.getAllIncludeRules();
                if (objectArray.length > 0 && dependencyArtifactDescriptorArray.length == 0) {
                    printWriter2.println(">");
                }
                XmlModuleDescriptorWriter.printDependencyIncludeRules(moduleDescriptor2, printWriter2, (IncludeRule[])objectArray);
                ExcludeRule[] excludeRuleArray = dependencyDescriptor2.getAllExcludeRules();
                if (excludeRuleArray.length > 0 && objectArray.length == 0 && dependencyArtifactDescriptorArray.length == 0) {
                    printWriter2.println(">");
                }
                XmlModuleDescriptorWriter.printDependencyExcludeRules(moduleDescriptor2, printWriter2, excludeRuleArray);
                if (objectArray.length + excludeRuleArray.length + dependencyArtifactDescriptorArray.length == 0) {
                    printWriter2.println("/>");
                    continue;
                }
                printWriter2.println("\t\t</dependency>");
            }
            PrintWriter printWriter3 = printWriter;
            ModuleDescriptor moduleDescriptor3 = moduleDescriptor;
            ExcludeRule[] excludeRuleArray = moduleDescriptor3.getAllExcludeRules();
            if (excludeRuleArray.length > 0) {
                for (int i = 0; i < excludeRuleArray.length; ++i) {
                    printWriter3.print("\t\t<exclude");
                    printWriter3.print(" org=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getModuleId().getOrganisation()) + "\"");
                    printWriter3.print(" module=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getModuleId().getName()) + "\"");
                    printWriter3.print(" artifact=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getName()) + "\"");
                    printWriter3.print(" type=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getType()) + "\"");
                    printWriter3.print(" ext=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getExt()) + "\"");
                    String[] stringArray = excludeRuleArray[i].getConfigurations();
                    if (!((Object)Arrays.asList(stringArray)).equals(Arrays.asList(moduleDescriptor3.getConfigurationsNames()))) {
                        printWriter3.print(" conf=\"");
                        for (int j = 0; j < stringArray.length; ++j) {
                            printWriter3.print(XMLHelper.escape(stringArray[j]));
                            if (j + 1 >= stringArray.length) continue;
                            printWriter3.print(",");
                        }
                        printWriter3.print("\"");
                    }
                    printWriter3.print(" matcher=\"" + XMLHelper.escape(excludeRuleArray[i].getMatcher().getName()) + "\"");
                    printWriter3.println("/>");
                }
            }
            XmlModuleDescriptorWriter.printAllMediators(moduleDescriptor, printWriter);
            printWriter.println("\t</dependencies>");
        }
    }

    private static void printAllMediators(ModuleDescriptor moduleDescriptor, PrintWriter printWriter) {
        Iterator iterator = moduleDescriptor.getAllDependencyDescriptorMediators().getAllRules().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            MapMatcher mapMatcher = (MapMatcher)entry.getKey();
            DependencyDescriptorMediator dependencyDescriptorMediator = (DependencyDescriptorMediator)entry.getValue();
            if (dependencyDescriptorMediator instanceof OverrideDependencyDescriptorMediator) {
                OverrideDependencyDescriptorMediator overrideDependencyDescriptorMediator = (OverrideDependencyDescriptorMediator)dependencyDescriptorMediator;
                printWriter.print("\t\t<override");
                printWriter.print(" org=\"" + XMLHelper.escape((String)mapMatcher.getAttributes().get("organisation")) + "\"");
                printWriter.print(" module=\"" + XMLHelper.escape((String)mapMatcher.getAttributes().get("module")) + "\"");
                printWriter.print(" matcher=\"" + XMLHelper.escape(mapMatcher.getPatternMatcher().getName()) + "\"");
                if (overrideDependencyDescriptorMediator.getBranch() != null) {
                    printWriter.print(" branch=\"" + XMLHelper.escape(overrideDependencyDescriptorMediator.getBranch()) + "\"");
                }
                if (overrideDependencyDescriptorMediator.getVersion() != null) {
                    printWriter.print(" rev=\"" + XMLHelper.escape(overrideDependencyDescriptorMediator.getVersion()) + "\"");
                }
                printWriter.println("/>");
                continue;
            }
            Message.verbose("ignoring unhandled DependencyDescriptorMediator: " + dependencyDescriptorMediator.getClass());
        }
    }

    private static void printDependencyExcludeRules(ModuleDescriptor moduleDescriptor, PrintWriter printWriter, ExcludeRule[] excludeRuleArray) {
        if (excludeRuleArray.length > 0) {
            for (int i = 0; i < excludeRuleArray.length; ++i) {
                printWriter.print("\t\t\t<exclude");
                printWriter.print(" org=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getModuleId().getOrganisation()) + "\"");
                printWriter.print(" module=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getModuleId().getName()) + "\"");
                printWriter.print(" name=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getName()) + "\"");
                printWriter.print(" type=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getType()) + "\"");
                printWriter.print(" ext=\"" + XMLHelper.escape(excludeRuleArray[i].getId().getExt()) + "\"");
                String[] stringArray = excludeRuleArray[i].getConfigurations();
                if (!((Object)Arrays.asList(stringArray)).equals(Arrays.asList(moduleDescriptor.getConfigurationsNames()))) {
                    printWriter.print(" conf=\"");
                    for (int j = 0; j < stringArray.length; ++j) {
                        printWriter.print(XMLHelper.escape(stringArray[j]));
                        if (j + 1 >= stringArray.length) continue;
                        printWriter.print(",");
                    }
                    printWriter.print("\"");
                }
                printWriter.print(" matcher=\"" + XMLHelper.escape(excludeRuleArray[i].getMatcher().getName()) + "\"");
                printWriter.println("/>");
            }
        }
    }

    private static void printDependencyIncludeRules(ModuleDescriptor moduleDescriptor, PrintWriter printWriter, IncludeRule[] includeRuleArray) {
        if (includeRuleArray.length > 0) {
            for (int i = 0; i < includeRuleArray.length; ++i) {
                printWriter.print("\t\t\t<include");
                printWriter.print(" name=\"" + XMLHelper.escape(includeRuleArray[i].getId().getName()) + "\"");
                printWriter.print(" type=\"" + XMLHelper.escape(includeRuleArray[i].getId().getType()) + "\"");
                printWriter.print(" ext=\"" + XMLHelper.escape(includeRuleArray[i].getId().getExt()) + "\"");
                String[] stringArray = includeRuleArray[i].getConfigurations();
                if (!((Object)Arrays.asList(stringArray)).equals(Arrays.asList(moduleDescriptor.getConfigurationsNames()))) {
                    printWriter.print(" conf=\"");
                    for (int j = 0; j < stringArray.length; ++j) {
                        printWriter.print(XMLHelper.escape(stringArray[j]));
                        if (j + 1 >= stringArray.length) continue;
                        printWriter.print(",");
                    }
                    printWriter.print("\"");
                }
                printWriter.print(" matcher=\"" + XMLHelper.escape(includeRuleArray[i].getMatcher().getName()) + "\"");
                printWriter.println("/>");
            }
        }
    }

    private static void printDependencyArtefacts(ModuleDescriptor moduleDescriptor, PrintWriter printWriter, DependencyArtifactDescriptor[] dependencyArtifactDescriptorArray) {
        if (dependencyArtifactDescriptorArray.length > 0) {
            for (int i = 0; i < dependencyArtifactDescriptorArray.length; ++i) {
                printWriter.print("\t\t\t<artifact");
                printWriter.print(" name=\"" + XMLHelper.escape(dependencyArtifactDescriptorArray[i].getName()) + "\"");
                printWriter.print(" type=\"" + XMLHelper.escape(dependencyArtifactDescriptorArray[i].getType()) + "\"");
                printWriter.print(" ext=\"" + XMLHelper.escape(dependencyArtifactDescriptorArray[i].getExt()) + "\"");
                String[] stringArray = dependencyArtifactDescriptorArray[i].getConfigurations();
                if (!((Object)Arrays.asList(stringArray)).equals(Arrays.asList(moduleDescriptor.getConfigurationsNames()))) {
                    printWriter.print(" conf=\"");
                    for (int j = 0; j < stringArray.length; ++j) {
                        printWriter.print(XMLHelper.escape(stringArray[j]));
                        if (j + 1 >= stringArray.length) continue;
                        printWriter.print(",");
                    }
                    printWriter.print("\"");
                }
                XmlModuleDescriptorWriter.printExtraAttributes(dependencyArtifactDescriptorArray[i], printWriter, " ");
                printWriter.println("/>");
            }
        }
    }

    private static void printExtraAttributes(ExtendableItem extendableItem, PrintWriter printWriter, String string) {
        String string2 = string;
        PrintWriter printWriter2 = printWriter;
        Map map2 = extendableItem.getQualifiedExtraAttributes();
        if (map2 != null) {
            String string3 = string2;
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                printWriter2.print(string3 + entry.getKey() + "=\"" + XMLHelper.escape(entry.getValue().toString()) + "\"");
                string3 = " ";
            }
        }
    }

    private static void printPublications(ModuleDescriptor moduleDescriptor, PrintWriter printWriter) {
        printWriter.println("\t<publications>");
        Artifact[] artifactArray = moduleDescriptor.getAllArtifacts();
        for (int i = 0; i < artifactArray.length; ++i) {
            printWriter.print("\t\t<artifact");
            printWriter.print(" name=\"" + XMLHelper.escape(artifactArray[i].getName()) + "\"");
            printWriter.print(" type=\"" + XMLHelper.escape(artifactArray[i].getType()) + "\"");
            printWriter.print(" ext=\"" + XMLHelper.escape(artifactArray[i].getExt()) + "\"");
            printWriter.print(" conf=\"" + XMLHelper.escape(XmlModuleDescriptorWriter.getConfs(moduleDescriptor, artifactArray[i])) + "\"");
            XmlModuleDescriptorWriter.printExtraAttributes(artifactArray[i], printWriter, " ");
            printWriter.println("/>");
        }
        printWriter.println("\t</publications>");
    }

    private static void printConfigurations(ModuleDescriptor moduleDescriptor, PrintWriter printWriter) {
        Configuration[] configurationArray = moduleDescriptor.getConfigurations();
        if (configurationArray.length > 0) {
            printWriter.println("\t<configurations>");
            for (int i = 0; i < configurationArray.length; ++i) {
                String[] stringArray;
                Configuration configuration = configurationArray[i];
                printWriter.print("\t\t");
                PrintWriter printWriter2 = printWriter;
                Configuration configuration2 = configuration;
                printWriter2.print("<conf");
                printWriter2.print(" name=\"" + XMLHelper.escape(configuration2.getName()) + "\"");
                printWriter2.print(" visibility=\"" + XMLHelper.escape(configuration2.getVisibility().toString()) + "\"");
                if (configuration2.getDescription() != null) {
                    printWriter2.print(" description=\"" + XMLHelper.escape(configuration2.getDescription()) + "\"");
                }
                if ((stringArray = configuration2.getExtends()).length > 0) {
                    printWriter2.print(" extends=\"");
                    for (int j = 0; j < stringArray.length; ++j) {
                        printWriter2.print(XMLHelper.escape(stringArray[j]));
                        if (j + 1 >= stringArray.length) continue;
                        printWriter2.print(",");
                    }
                    printWriter2.print("\"");
                }
                if (!configuration2.isTransitive()) {
                    printWriter2.println(" transitive=\"false\"");
                }
                if (configuration2.getDeprecated() != null) {
                    printWriter2.print(" deprecated=\"" + XMLHelper.escape(configuration2.getDeprecated()) + "\"");
                }
                XmlModuleDescriptorWriter.printExtraAttributes(configuration2, printWriter2, " ");
                printWriter2.println("/>");
            }
            printWriter.println("\t</configurations>");
        }
    }

    private static void printInfoTag(ModuleDescriptor moduleDescriptor, PrintWriter printWriter) {
        ModuleDescriptor moduleDescriptor2;
        String string;
        printWriter.println("\t<info organisation=\"" + XMLHelper.escape(moduleDescriptor.getModuleRevisionId().getOrganisation()) + "\"");
        printWriter.println("\t\tmodule=\"" + XMLHelper.escape(moduleDescriptor.getModuleRevisionId().getName()) + "\"");
        String string2 = moduleDescriptor.getResolvedModuleRevisionId().getBranch();
        if (string2 != null) {
            printWriter.println("\t\tbranch=\"" + XMLHelper.escape(string2) + "\"");
        }
        if ((string = moduleDescriptor.getResolvedModuleRevisionId().getRevision()) != null) {
            printWriter.println("\t\trevision=\"" + XMLHelper.escape(string) + "\"");
        }
        printWriter.println("\t\tstatus=\"" + XMLHelper.escape(moduleDescriptor.getStatus()) + "\"");
        printWriter.println("\t\tpublication=\"" + Ivy.DATE_FORMAT.format(moduleDescriptor.getResolvedPublicationDate()) + "\"");
        if (moduleDescriptor.isDefault()) {
            printWriter.println("\t\tdefault=\"true\"");
        }
        if (moduleDescriptor instanceof DefaultModuleDescriptor && ((DefaultModuleDescriptor)moduleDescriptor).getNamespace() != null && !((String)null).equals("system")) {
            printWriter.println("\t\tnamespace=\"" + XMLHelper.escape(null) + "\"");
        }
        if (!moduleDescriptor.getExtraAttributes().isEmpty()) {
            XmlModuleDescriptorWriter.printExtraAttributes(moduleDescriptor, printWriter, "\t\t");
            printWriter.println();
        }
        if ((moduleDescriptor2 = moduleDescriptor).getExtraInfo().size() > 0 || moduleDescriptor2.getHomePage() != null || moduleDescriptor2.getDescription() != null && moduleDescriptor2.getDescription().trim().length() > 0 || moduleDescriptor2.getLicenses().length > 0 || moduleDescriptor2.getInheritedDescriptors().length > 0) {
            Map.Entry entry;
            printWriter.println("\t>");
            ExtendsDescriptor[] extendsDescriptorArray = moduleDescriptor.getInheritedDescriptors();
            for (int i = 0; i < extendsDescriptorArray.length; ++i) {
                ExtendsDescriptor extendsDescriptor = extendsDescriptorArray[i];
                entry = extendsDescriptor.getParentRevisionId();
                printWriter.print("\t\t<extends organisation=\"" + XMLHelper.escape(((ModuleRevisionId)((Object)entry)).getOrganisation()) + "\"" + " module=\"" + XMLHelper.escape(((ModuleRevisionId)((Object)entry)).getName()) + "\"" + " revision=\"" + XMLHelper.escape(((ModuleRevisionId)((Object)entry)).getRevision()) + "\"");
                String string3 = extendsDescriptor.getLocation();
                if (string3 != null) {
                    printWriter.print(" location=\"" + XMLHelper.escape(string3) + "\"");
                }
                printWriter.print(" extendType=\"" + StringUtils.join(extendsDescriptor.getExtendsTypes(), ",") + "\"");
                printWriter.println("/>");
            }
            License[] licenseArray = moduleDescriptor.getLicenses();
            for (int i = 0; i < licenseArray.length; ++i) {
                entry = licenseArray[i];
                printWriter.print("\t\t<license ");
                if (((License)((Object)entry)).getName() != null) {
                    printWriter.print("name=\"" + XMLHelper.escape(((License)((Object)entry)).getName()) + "\" ");
                }
                if (((License)((Object)entry)).getUrl() != null) {
                    printWriter.print("url=\"" + XMLHelper.escape(((License)((Object)entry)).getUrl()) + "\" ");
                }
                printWriter.println("/>");
            }
            if (moduleDescriptor.getHomePage() != null || moduleDescriptor.getDescription() != null) {
                printWriter.print("\t\t<description");
                if (moduleDescriptor.getHomePage() != null) {
                    printWriter.print(" homepage=\"" + XMLHelper.escape(moduleDescriptor.getHomePage()) + "\"");
                }
                if (moduleDescriptor.getDescription() != null && moduleDescriptor.getDescription().trim().length() > 0) {
                    printWriter.println(">");
                    printWriter.println("\t\t" + XMLHelper.escape(moduleDescriptor.getDescription()));
                    printWriter.println("\t\t</description>");
                } else {
                    printWriter.println(" />");
                }
            }
            Iterator iterator = moduleDescriptor.getExtraInfo().entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                if (entry.getValue() == null || ((String)entry.getValue()).length() == 0) continue;
                printWriter.print("\t\t<");
                printWriter.print(entry.getKey());
                printWriter.print(">");
                printWriter.print(XMLHelper.escape((String)entry.getValue()));
                printWriter.print("</");
                printWriter.print(entry.getKey());
                printWriter.println(">");
            }
            printWriter.println("\t</info>");
            return;
        }
        printWriter.println("\t/>");
    }

    private static String getConfs(ModuleDescriptor moduleDescriptor, Artifact artifact) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = moduleDescriptor.getConfigurationsNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!Arrays.asList(moduleDescriptor.getArtifacts(stringArray[i])).contains(artifact)) continue;
            stringBuffer.append(stringArray[i]).append(",");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public void foreach(Function1 function1) {
        XmlModuleDescriptorWriter xmlModuleDescriptorWriter = this;
        xmlModuleDescriptorWriter.$outer.foreach(new TraversableLike$WithFilter$$anonfun$foreach$1(this, function1));
    }

    public XmlModuleDescriptorWriter(TraversableLike traversableLike, Function1 function1) {
        this.scala$collection$TraversableLike$WithFilter$$p = function1;
        if (traversableLike == null) {
            throw new NullPointerException();
        }
        this.$outer = traversableLike;
    }
}

