/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.aop.impl.PointcutImpl;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.factory.AbstractTagHandler;
import org.seasar.framework.container.impl.AspectDefImpl;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.xml.TagHandlerContext;
import org.xml.sax.Attributes;

public class AspectTagHandler
extends AbstractTagHandler {
    private static final long serialVersionUID = 5619707344253136193L;

    public void start(TagHandlerContext context, Attributes attributes) {
        AspectDefImpl aspectDef = null;
        String pointcutStr = attributes.getValue("pointcut");
        if (pointcutStr != null) {
            String[] methodNames = StringUtil.split(pointcutStr, ", ");
            aspectDef = this.createAspectDef(this.createPointcut(methodNames));
        } else {
            aspectDef = this.createAspectDef();
        }
        context.push(aspectDef);
    }

    public void end(TagHandlerContext context, String body) {
        AspectDef aspectDef = (AspectDef)context.pop();
        if (!StringUtil.isEmpty(body)) {
            aspectDef.setExpression(this.createExpression(context, body));
        }
        ComponentDef componentDef = (ComponentDef)context.peek();
        componentDef.addAspectDef(aspectDef);
    }

    protected AspectDefImpl createAspectDef() {
        return new AspectDefImpl();
    }

    protected AspectDefImpl createAspectDef(Pointcut pointcut) {
        return new AspectDefImpl(pointcut);
    }

    protected Pointcut createPointcut(String[] methodNames) {
        return new PointcutImpl(methodNames);
    }
}

