/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.query;

import java.lang.reflect.Field;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.seasar.extension.jdbc.JdbcContext;
import org.seasar.extension.jdbc.ModuleCall;
import org.seasar.extension.jdbc.ParamType;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.annotation.InOut;
import org.seasar.extension.jdbc.annotation.Out;
import org.seasar.extension.jdbc.annotation.ResultSet;
import org.seasar.extension.jdbc.exception.FieldNotGenericsRuntimeException;
import org.seasar.extension.jdbc.handler.BeanListResultSetHandler;
import org.seasar.extension.jdbc.handler.BeanResultSetHandler;
import org.seasar.extension.jdbc.handler.ObjectListResultSetHandler;
import org.seasar.extension.jdbc.handler.ObjectResultSetHandler;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.parameter.LobParameter;
import org.seasar.extension.jdbc.parameter.TemporalParameter;
import org.seasar.extension.jdbc.query.AbstractQuery;
import org.seasar.extension.jdbc.query.Param;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.Disposable;
import org.seasar.framework.util.DisposableUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.ModifierUtil;
import org.seasar.framework.util.StatementUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;
import org.seasar.framework.util.tiger.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModuleCall<S extends ModuleCall<S>>
extends AbstractQuery<S>
implements ModuleCall<S> {
    protected static boolean initialized;
    protected static final ConcurrentMap<Class<?>, ParamDesc[]> paramDescCache;
    protected int maxRows;
    protected int fetchSize;
    protected Object parameter;
    protected List<Param> nonParamList = new ArrayList<Param>();
    protected boolean functionCall;

    public AbstractModuleCall(JdbcManagerImplementor jdbcManager, boolean functionCall) {
        super(jdbcManager);
        this.functionCall = functionCall;
    }

    @Override
    public S maxRows(int maxRows) {
        this.maxRows = maxRows;
        return (S)this;
    }

    @Override
    public S fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return (S)this;
    }

    protected void prepareParameter() {
        if (this.parameter == null) {
            return;
        }
        Class<?> paramClass = this.parameter.getClass();
        if (ValueTypes.isSimpleType(paramClass) || TemporalParameter.class == paramClass || LobParameter.class == paramClass) {
            this.addParam(this.parameter, paramClass);
            return;
        }
        boolean needsParameterForResultSet = this.jdbcManager.getDialect().needsParameterForResultSet();
        block6: for (ParamDesc paramDesc : this.getParamDescs(paramClass)) {
            Class<?> clazz = paramDesc.paramClass;
            ValueType valueType = paramDesc.valueType;
            switch (paramDesc.paramType) {
                case RESULT_SET: {
                    if (needsParameterForResultSet) {
                        this.addParam(paramDesc.field, clazz, valueType, ParamType.OUT);
                        continue block6;
                    }
                    this.addNonParam(paramDesc.field);
                    continue block6;
                }
                case IN: {
                    this.addParam(FieldUtil.get((Field)paramDesc.field, (Object)this.parameter), clazz, valueType);
                    continue block6;
                }
                case OUT: {
                    this.addParam(paramDesc.field, clazz, valueType, ParamType.OUT);
                    continue block6;
                }
                case IN_OUT: {
                    this.addParam(paramDesc.field, clazz, valueType, ParamType.IN_OUT);
                }
            }
        }
    }

    protected void addParam(Field field, Class<?> paramClass, ValueType valueType, ParamType paramType) {
        Object value = field != null && paramType != ParamType.OUT ? FieldUtil.get((Field)field, (Object)this.parameter) : null;
        Param p = this.addParam(value, paramClass, valueType);
        p.paramType = paramType;
        p.field = field;
    }

    protected CallableStatement getCallableStatement(JdbcContext jdbcContext) {
        CallableStatement ps = jdbcContext.getCallableStatement(this.executedSql);
        this.setupCallableStatement(ps);
        return ps;
    }

    protected void setupCallableStatement(CallableStatement cs) {
        if (this.maxRows > 0) {
            StatementUtil.setMaxRows((Statement)cs, (int)this.maxRows);
        }
        if (this.fetchSize > 0) {
            StatementUtil.setFetchSize((Statement)cs, (int)this.fetchSize);
        }
        if (this.queryTimeout > 0) {
            StatementUtil.setQueryTimeout((Statement)cs, (int)this.queryTimeout);
        }
        this.prepareInParams(cs);
        this.prepareOutParams(cs);
    }

    protected void prepareOutParams(CallableStatement cs) {
        int size = this.getParamSize();
        try {
            for (int i = 0; i < size; ++i) {
                Param param = this.getParam(i);
                if (param.paramType == ParamType.IN) continue;
                param.valueType.registerOutParameter(cs, i + 1);
            }
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    protected void handleNonParamResultSets(CallableStatement cs, boolean resultSetGettable) {
        try {
            java.sql.ResultSet rs;
            if (!resultSetGettable) {
                cs.getMoreResults();
            }
            for (int i = 0; i < this.nonParamList.size() && (rs = this.getResultSet(cs)) != null; ++i) {
                Param param = this.nonParamList.get(i);
                Object value = this.handleResultSet(param.field, cs.getResultSet());
                FieldUtil.set((Field)param.field, (Object)this.parameter, (Object)value);
                cs.getMoreResults();
            }
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    protected java.sql.ResultSet getResultSet(CallableStatement cs) {
        try {
            while (true) {
                java.sql.ResultSet rs;
                if ((rs = cs.getResultSet()) != null) {
                    return rs;
                }
                if (cs.getUpdateCount() == -1) {
                    return null;
                }
                cs.getMoreResults();
            }
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    protected void handleOutParams(CallableStatement cs) {
        try {
            int start;
            for (int i = start = this.functionCall ? 1 : 0; i < this.getParamSize(); ++i) {
                Param param = this.getParam(i);
                if (param.paramType == ParamType.IN) continue;
                Object value = param.valueType.getValue(cs, i + 1);
                if (value instanceof java.sql.ResultSet) {
                    value = this.handleResultSet(param.field, (java.sql.ResultSet)value);
                }
                FieldUtil.set((Field)param.field, (Object)this.parameter, (Object)value);
            }
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    protected Object handleResultSet(Field field, java.sql.ResultSet rs) {
        if (!List.class.isAssignableFrom(field.getType())) {
            return this.handleSingleResult(field.getType(), rs);
        }
        Class<?> elementClass = ReflectionUtil.getElementTypeOfListFromFieldType(field);
        if (elementClass == null) {
            this.logger.log("ESSR0709", new Object[]{this.callerClass.getName(), this.callerMethodName});
            throw new FieldNotGenericsRuntimeException(field);
        }
        return this.handleResultList(elementClass, rs);
    }

    protected Object handleSingleResult(Class<?> resultClass, java.sql.ResultSet rs) {
        Object handler = ValueTypes.isSimpleType(resultClass) ? new ObjectResultSetHandler(ValueTypes.getValueType(resultClass), null) : new BeanResultSetHandler(resultClass, this.jdbcManager.getDialect(), this.jdbcManager.getPersistenceConvention(), null);
        return this.handleResultSet((ResultSetHandler)handler, rs);
    }

    protected Object handleResultList(Class<?> elementClass, java.sql.ResultSet rs) {
        Object handler = ValueTypes.isSimpleType(elementClass) ? new ObjectListResultSetHandler(ValueTypes.getValueType(elementClass)) : new BeanListResultSetHandler(elementClass, this.jdbcManager.getDialect(), this.jdbcManager.getPersistenceConvention(), null);
        return this.handleResultSet((ResultSetHandler)handler, rs);
    }

    protected int getNonParamSize() {
        return this.nonParamList.size();
    }

    protected Param getNonParam(int index) {
        return this.nonParamList.get(index);
    }

    protected Param addNonParam(Field field) {
        Param param = new Param();
        param.field = field;
        param.paramType = ParamType.OUT;
        this.nonParamList.add(param);
        return param;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public Object getParameter() {
        return this.parameter;
    }

    protected synchronized void initialize() {
        if (initialized) {
            return;
        }
        DisposableUtil.add((Disposable)new Disposable(){

            public void dispose() {
                paramDescCache.clear();
                initialized = false;
            }
        });
        initialized = true;
    }

    protected ParamDesc[] getParamDescs(Class<?> dtoClass) {
        this.initialize();
        ParamDesc[] paramDesc = (ParamDesc[])paramDescCache.get(dtoClass);
        if (paramDesc != null) {
            return paramDesc;
        }
        return this.createParamDesc(dtoClass);
    }

    protected ParamDesc[] createParamDesc(Class<?> dtoClass) {
        Field[] fields = ClassUtil.getDeclaredFields(dtoClass);
        ArrayList<ParamDesc> list = CollectionsUtil.newArrayList(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!ModifierUtil.isInstanceField((Field)field)) continue;
            field.setAccessible(true);
            ParamDesc paramDesc = new ParamDesc();
            paramDesc.field = field;
            paramDesc.name = field.getName();
            paramDesc.paramClass = field.getType();
            boolean lob = field.getAnnotation(Lob.class) != null;
            Temporal temporal = field.getAnnotation(Temporal.class);
            TemporalType temporalType = temporal != null ? temporal.value() : null;
            paramDesc.valueType = this.getValueType(paramDesc.paramClass, lob, temporalType);
            paramDesc.paramType = field.getAnnotation(ResultSet.class) != null ? ParamDesc.ParameterType.RESULT_SET : (field.getAnnotation(Out.class) != null ? ParamDesc.ParameterType.OUT : (field.getAnnotation(InOut.class) != null ? ParamDesc.ParameterType.IN_OUT : ParamDesc.ParameterType.IN));
            list.add(paramDesc);
        }
        ParamDesc[] result = list.toArray(new ParamDesc[list.size()]);
        return CollectionsUtil.putIfAbsent(paramDescCache, dtoClass, result);
    }

    static {
        paramDescCache = CollectionsUtil.newConcurrentHashMap();
    }

    public static class ParamDesc {
        public Field field;
        public String name;
        public Class<?> paramClass;
        public ParameterType paramType;
        public ValueType valueType;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ParameterType {
            IN,
            IN_OUT,
            OUT,
            RESULT_SET;

        }
    }
}

