/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.lang.ref.WeakReference;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.index.BtreeIndex;
import org.h2.log.LogSystem;
import org.h2.message.TraceSystem;
import org.h2.table.Table;
import org.h2.util.FileUtils;
import org.h2.util.ObjectArray;

public class WriterThread
extends Thread {
    private volatile WeakReference databaseRef;
    private int writeDelay;
    private long lastIndexFlush;
    private volatile boolean stop;
    private long oldLogFileDelete;
    private String oldLogFile;

    private WriterThread(Database database, int writeDelay) {
        this.databaseRef = new WeakReference<Database>(database);
        this.writeDelay = writeDelay;
    }

    public void setWriteDelay(int writeDelay) {
        LogSystem log = this.getLog();
        this.writeDelay = writeDelay;
        if (writeDelay < SysProperties.MIN_WRITE_DELAY) {
            log.setFlushOnEachCommit(true);
        } else {
            log.setFlushOnEachCommit(false);
        }
    }

    public static WriterThread create(Database database, int writeDelay) {
        WriterThread thread = new WriterThread(database, writeDelay);
        thread.setName("H2 Log Writer " + database.getShortName());
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    private LogSystem getLog() {
        Database database = (Database)this.databaseRef.get();
        if (database == null) {
            return null;
        }
        LogSystem log = database.getLog();
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushIndexes(Database database) {
        long time = System.currentTimeMillis();
        if (this.lastIndexFlush + 0L > time) {
            return;
        }
        Database database2 = database;
        synchronized (database2) {
            ObjectArray array = database.getAllSchemaObjects(1);
            for (int i = 0; i < array.size(); ++i) {
                Table tab;
                BtreeIndex idx;
                DbObject obj = (DbObject)array.get(i);
                if (!(obj instanceof BtreeIndex) || (idx = (BtreeIndex)obj).getLastChange() == 0L || (tab = idx.getTable()).isLockedExclusively() || idx.getLastChange() + 0L > time) continue;
                try {
                    idx.flush(database.getSystemSession());
                    continue;
                }
                catch (SQLException e) {
                    database.getTrace("database").error("flush index " + idx.getName(), e);
                }
            }
        }
        this.lastIndexFlush = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stop) {
            block10: {
                LogSystem log;
                WriterThread writerThread = this;
                synchronized (writerThread) {
                    long time;
                    if (this.oldLogFile != null && (time = System.currentTimeMillis()) > this.oldLogFileDelete) {
                        FileUtils.tryDelete(this.oldLogFile);
                        if (!FileUtils.exists(this.oldLogFile)) {
                            this.oldLogFile = null;
                        }
                    }
                }
                Database database = (Database)this.databaseRef.get();
                if (database == null || (log = database.getLog()) == null) break;
                try {
                    log.flush();
                }
                catch (SQLException e) {
                    TraceSystem traceSystem = database.getTraceSystem();
                    if (traceSystem == null) break block10;
                    traceSystem.getTrace("log").error("flush", e);
                }
            }
            int wait = this.writeDelay > 0 ? this.writeDelay : 1;
            try {
                Thread.sleep(wait);
            }
            catch (InterruptedException e) {}
        }
        this.databaseRef = null;
    }

    public void stopThread() throws SQLException {
        this.stop = true;
        this.deleteLogFileLater(null);
    }

    public synchronized void deleteLogFileLater(String fileName) throws SQLException {
        int delay;
        if (this.oldLogFile != null) {
            FileUtils.delete(this.oldLogFile);
        }
        if ((delay = SysProperties.getLogFileDeleteDelay()) == 0 && fileName != null) {
            FileUtils.delete(fileName);
        } else {
            this.oldLogFile = fileName;
            if (fileName != null) {
                this.oldLogFileDelete = System.currentTimeMillis() + (long)delay;
            }
        }
    }
}

