package code.model

import _root_.net.liftweb.mapper._

class BackupDir extends LongKeyedMapper[BackupDir] with IdPK {
	def getSingleton = BackupDir

//  def functions = FunctionInfo.findAll(By(FunctionInfo.systemInfo, this.id), OrderBy(FunctionInfo.id, Descending))

	object directory extends MappedString(this, 1000){
//    override def displayName = "Directory"

    // TODO エラーメッセージは変える？
    override def validations =
      valMinLen(1, "Directory is required.") _ ::
      valMaxLen(1000, "Directory max length is 1000 characters.") _ :: Nil

  }

	object description  extends MappedString(this, 2000){
//    override def displayName = "Description"

    // TODO エラーメッセージは変える？
    override def validations =
      valMaxLen(2000 , "Description max length is 2000 characters.") _ :: Nil
  }

}

object BackupDir extends BackupDir
  with LongKeyedMetaMapper[BackupDir] with CRUDify[Long, BackupDir]{
}