package jp.sf.amateras.mirage;

import java.util.List;

import jp.sf.amateras.mirage.naming.NameConverter;
import jp.sf.amateras.mirage.provider.ConnectionProvider;
import jp.sf.amateras.mirage.type.ValueType;

public interface SqlManager {

	public void setNameConverter(NameConverter converter);

	public void setConnectionProvider(ConnectionProvider connectionProvider);

	public void addValueType(ValueType valueType);

	public <T> int getCount(String sqlPath);

	public <T> int getCount(String sqlPath, Object param);

	public <T> List<T> getResultList(Class<T> clazz, String sqlPath);

	public <T> List<T> getResultList(Class<T> clazz, String sqlPath, Object param);

	public <T> T getSingleResult(Class<T> clazz, String sqlPath);

	public <T> T getSingleResult(Class<T> clazz, String sqlPath, Object param);

	public int executeUpdate(String sqlPath);

	public int executeUpdate(String sqlPath, Object param);

	public int insertEntity(Object entity);

	public int updateEntity(Object entity);

	public int deleteEntity(Object entity);

	public <T> T findEntity(Class<T> clazz, Object... id);

//	public <T> T getResultListBySql(Class<T> clazz, String sql);
//
//	public <T> T getResultListBySql(Class<T> clazz, String sql, Object param);
//
//	public <T> T getSingleResultBySql(Class<T> clazz, String sql);
//
//	public <T> T getSingleResultBySql(Class<T> clazz, String sql, Object param);
//
//	public int executeUpdateBySql(String sqlPath);
//
//	public int executeUpdateBySql(String sqlPath, Object param);

}
