package jp.sf.amateras.mirage.example.page;

import jp.sf.amateras.mirage.SqlManager;
import jp.sf.amateras.mirage.example.entity.Book;
import jp.sf.amateras.mirage.util.StringUtil;

import org.apache.click.ActionListener;
import org.apache.click.Control;
import org.apache.click.control.Checkbox;
import org.apache.click.control.FileField;
import org.apache.click.control.Form;
import org.apache.click.control.HiddenField;
import org.apache.click.control.PageLink;
import org.apache.click.control.Submit;
import org.apache.click.control.TextField;
import org.apache.click.extras.control.DateField;
import org.apache.click.extras.control.IntegerField;
import org.apache.click.util.Bindable;

public class BookEditPage extends AbstractPage {

	private static final long serialVersionUID = 1L;

	@Bindable
	public Long id;

	private Form form = new Form("form");
	private HiddenField bookId = new HiddenField("id", Long.class);
	private TextField name = new TextField("name", getMessage("book.name"), 40, true);
	private TextField author = new TextField("author", getMessage("book.author"), 40, true);
	private TextField publisher = new TextField("publisher", getMessage("book.publisher"), 40, true);
	private IntegerField price = new IntegerField("price", getMessage("book.price"), 10, true);
	private DateField publishDate = new DateField("publishDate", getMessage("book.publishDate"), true);
	private FileField image = new FileField("image", getMessage("book.image"));
	private Checkbox imageDelete = new Checkbox("imageDelete", getMessage("label.deleteImage"));
	private Submit submit = new Submit("submit", getMessage("button.modify"));

	private PageLink back = new PageLink("back", getMessage("link.back"), BookListPage.class);

	@Override
	public void onInit() {
		super.onInit();

		// Retrieves the editing target book
		SqlManager sqlManager = getSqlManager();
		Book book = sqlManager.findEntity(Book.class, id);
		if(book == null){
			throw new RuntimeException(getMessage("message.bookNotExist"));
		}
		addModel("book", book);

		// Assembles form
		form.add(bookId);
		form.add(name);
		form.add(author);
		form.add(publisher);
		form.add(price);
		form.add(publishDate);
		if(StringUtil.isEmpty(book.getImageName())){
			form.add(image);
		} else {
			form.add(imageDelete);
		}
		form.add(submit);

		form.copyFrom(book);

		submit.setActionListener(new ActionListener() {
			private static final long serialVersionUID = 1L;
			@Override
			public boolean onAction(Control source) {
				if(form.isValid()){
					SqlManager sqlManager = getSqlManager();
					Book book = sqlManager.findEntity(Book.class, new Long(bookId.getValue()));
					if(book == null){
						throw new RuntimeException(getMessage("message.bookNotExist"));
					}
					form.copyTo(book);

					if(form.contains(image)){
						book.setImageName(image.getFileItem().getName());
						book.setImage(image.getFileItem().get());

					} else if(imageDelete.isChecked()){
						book.setImageName("");
						book.setImage(new byte[0]);
					}

					sqlManager.updateEntity(book);

					setRedirect(BookListPage.class);
					return false;
				}
				return true;
			}
		});

		addControl(form);
		addControl(back);
		addModel("title", getMessage("title.bookEdit"));
	}


}
