package code.snippet

import _root_.scala.xml.NodeSeq
import java.io.File
import net.liftweb.http.{LiftResponse, RequestVar, S}
import net.liftweb.common.Box
import code.util.Util
import code.util.Util._
import code.util.ZipCompresser
import code.util.RDiffBackup

/**
 * 変更内容一覧ポップアップ画面で使用するスニペットです。
 */
class ChangesSnippet {

  private object paramRoot extends RequestVar[String](S.param("root").open_!)
  private object paramPath extends RequestVar[String](S.param("path").openOr(""))
  private object paramDate extends RequestVar[String](S.param("date").openOr(""))

  def back(xhtml:NodeSeq):NodeSeq = {
    <input type="button" value="Back" onclick={"showHistory('%s','%s')".format(paramRoot, paramPath)}/>
  }

  def list(xhtml:NodeSeq):NodeSeq = {
    // パスのセキュリティチェック？
    checkRoot(paramRoot)
    checkPath(paramPath)

    S.skipDocType = true
    S.skipXmlHeader = true

    val path = buildPath(paramRoot, if(paramPath.equals(".")) "" else paramPath)
    val changeList = RDiffBackup.changes(path, paramDate)
    <ul>
      {changeList.map(dto => {
        <li class={if(changeList.indexOf(dto) % 2 == 0) "odd" else "even"}>
          <img src={dto.getIcon} alt={dto.operation} />
          {if(dto.operation == "new")
            {dto.path}
          else
            <a href={"changes/download?root=" + u(paramRoot) + "&path=" + u(dto.path) + "&date=" + u(paramDate)}>{dto.path}</a>
          }
        </li>
      })}
    </ul>
  }

}

/**
 * バックアップ履歴のダウンロードを行うためのハンドラです。
 */
object ChangeDownloadHandler {
  def download(): Box[LiftResponse] = {
    val paramRoot = S.param("root").open_!
    val paramPath = S.param("path").open_!
    val paramDate = S.param("date").open_!

    // パスのセキュリティチェック？
    checkRoot(paramRoot)
    checkPath(paramPath)

    val path = buildPath(paramRoot, paramPath)

    RDiffBackup.restore(path, paramDate){ tmpDir =>
      val fileName = getFileName(path)
      val file = new File(tmpDir, fileName);
      if(file.isFile){
        // ファイルの場合は単体でダウンロード
        fileDownload(file)
      } else {
        // ディレクトリの場合はZIPにまとめてダウンロード
        new ZipCompresser(file).archive
        fileDownload(new File(tmpDir, fileName + ".zip"))
      }
    }
  }
}