/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.util.Message;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractModuleDescriptorParser$AbstractParser
extends DefaultHandler {
    private String defaultConf;
    private String defaultConfMapping;
    private DefaultDependencyDescriptor defaultConfMappingDescriptor;
    private Resource res;
    private List errors = new ArrayList();
    private DefaultModuleDescriptor md;
    private ModuleDescriptorParser parser;

    protected AbstractModuleDescriptorParser$AbstractParser(ModuleDescriptorParser moduleDescriptorParser) {
        this.parser = moduleDescriptorParser;
    }

    public final ModuleDescriptorParser getModuleDescriptorParser() {
        return this.parser;
    }

    protected final void checkErrors() {
        if (!this.errors.isEmpty()) {
            throw new ParseException(this.errors.toString(), 0);
        }
    }

    public final void setResource(Resource resource) {
        long l;
        this.res = resource;
        this.md = new DefaultModuleDescriptor(this.parser, resource);
        Resource resource2 = resource;
        long l2 = resource2.getLastModified();
        if (l2 > 0L) {
            l = l2;
        } else {
            Message.debug("impossible to get date for " + resource2 + ": using 'now'");
            l = System.currentTimeMillis();
        }
        this.md.setLastModified(l);
    }

    protected final String getDefaultConfMapping() {
        return this.defaultConfMapping;
    }

    protected final void setDefaultConfMapping(String string) {
        this.defaultConfMapping = string;
    }

    protected final void parseDepsConfs(String string, DefaultDependencyDescriptor defaultDependencyDescriptor) {
        boolean bl = this.defaultConfMapping != null;
        DefaultDependencyDescriptor defaultDependencyDescriptor2 = defaultDependencyDescriptor;
        String string2 = string;
        this.parseDepsConfs(string2, defaultDependencyDescriptor2, bl, true);
    }

    private void parseDepsConfs(String string, DefaultDependencyDescriptor defaultDependencyDescriptor, boolean bl, boolean bl2) {
        if (string == null) {
            return;
        }
        String[] stringArray = string.split(";");
        this.parseDepsConfs(stringArray, defaultDependencyDescriptor, bl, bl2);
    }

    private void parseDepsConfs(String[] stringArray, DefaultDependencyDescriptor defaultDependencyDescriptor, boolean bl) {
        this.parseDepsConfs(stringArray, defaultDependencyDescriptor, bl, true);
    }

    private void parseDepsConfs(String[] stringArray, DefaultDependencyDescriptor defaultDependencyDescriptor, boolean bl, boolean bl2) {
        Object object = this.md;
        Configuration[] configurationArray = object.getConfigurations();
        for (int i = 0; i < configurationArray.length; ++i) {
            configurationArray[i].replaceWildcards((ModuleDescriptor)object);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            int n;
            String[] stringArray2;
            String[] stringArray3 = stringArray[i].split("->");
            if (stringArray3.length == 1) {
                stringArray2 = stringArray3[0].split(",");
                if (!bl) {
                    for (int j = 0; j < stringArray2.length; ++j) {
                        defaultDependencyDescriptor.addDependencyConfiguration(stringArray2[j].trim(), stringArray2[j].trim());
                    }
                    continue;
                }
                for (int j = 0; j < stringArray2.length; ++j) {
                    String[] stringArray4;
                    object = this;
                    if (((AbstractModuleDescriptorParser$AbstractParser)object).defaultConfMappingDescriptor == null) {
                        ((AbstractModuleDescriptorParser$AbstractParser)object).defaultConfMappingDescriptor = new DefaultDependencyDescriptor(ModuleRevisionId.newInstance("", "", ""), false, 0);
                        super.parseDepsConfs(((AbstractModuleDescriptorParser$AbstractParser)object).defaultConfMapping, ((AbstractModuleDescriptorParser$AbstractParser)object).defaultConfMappingDescriptor, false, false);
                    }
                    if ((stringArray4 = ((AbstractModuleDescriptorParser$AbstractParser)object).defaultConfMappingDescriptor.getDependencyConfigurations(stringArray2[j])).length > 0) {
                        for (n = 0; n < stringArray4.length; ++n) {
                            string = bl2 ? this.evaluateCondition(stringArray4[n].trim(), defaultDependencyDescriptor) : stringArray4[n].trim();
                            if (string == null) continue;
                            defaultDependencyDescriptor.addDependencyConfiguration(stringArray2[j].trim(), string);
                        }
                        continue;
                    }
                    defaultDependencyDescriptor.addDependencyConfiguration(stringArray2[j].trim(), stringArray2[j].trim());
                }
                continue;
            }
            if (stringArray3.length == 2) {
                stringArray2 = stringArray3[0].split(",");
                String[] stringArray5 = stringArray3[1].split(",");
                for (int j = 0; j < stringArray2.length; ++j) {
                    for (n = 0; n < stringArray5.length; ++n) {
                        string = bl2 ? this.evaluateCondition(stringArray5[n].trim(), defaultDependencyDescriptor) : stringArray5[n].trim();
                        if (string == null) continue;
                        defaultDependencyDescriptor.addDependencyConfiguration(stringArray2[j].trim(), string);
                    }
                }
                continue;
            }
            this.addError("invalid conf " + stringArray[i] + " for " + defaultDependencyDescriptor);
        }
        if (this.md.isMappingOverride()) {
            this.addExtendingConfigurations(stringArray, defaultDependencyDescriptor, bl);
        }
    }

    private String evaluateCondition(String string, DefaultDependencyDescriptor defaultDependencyDescriptor) {
        if (string.charAt(0) != '[') {
            return string;
        }
        int n = string.indexOf(93);
        if (n == -1) {
            this.addError("invalid conf " + string + " for " + defaultDependencyDescriptor);
            return null;
        }
        String string2 = string.substring(1, n);
        int n2 = string2.indexOf("!=");
        if (n2 == -1) {
            String string3;
            int n3 = string2.indexOf(61);
            if (n3 == -1) {
                this.addError("invalid conf " + string + " for " + defaultDependencyDescriptor.getDependencyRevisionId());
                return null;
            }
            String string4 = string2.substring(0, n3).trim();
            String string5 = string2.substring(n3 + 1).trim();
            if (string4.equals("org") || string4.equals("organization")) {
                string4 = "organisation";
            }
            if (!string5.equals(string3 = defaultDependencyDescriptor.getAttribute(string4))) {
                return null;
            }
        } else {
            String string6;
            String string7 = string2.substring(0, n2).trim();
            String string8 = string2.substring(n2 + 2).trim();
            if (string7.equals("org") || string7.equals("organization")) {
                string7 = "organisation";
            }
            if (string8.equals(string6 = defaultDependencyDescriptor.getAttribute(string7))) {
                return null;
            }
        }
        return string.substring(n + 1);
    }

    private void addExtendingConfigurations(String[] stringArray, DefaultDependencyDescriptor defaultDependencyDescriptor, boolean bl) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addExtendingConfigurations(stringArray[i], defaultDependencyDescriptor, bl);
        }
    }

    private void addExtendingConfigurations(String string, DefaultDependencyDescriptor defaultDependencyDescriptor, boolean bl) {
        HashSet<String> hashSet = new HashSet<String>();
        Configuration[] configurationArray = this.md.getConfigurations();
        for (int i = 0; i < configurationArray.length; ++i) {
            String[] stringArray = configurationArray[i].getExtends();
            for (int j = 0; j < stringArray.length; ++j) {
                if (!string.equals(stringArray[j])) continue;
                String string2 = configurationArray[i].getName();
                hashSet.add(string2);
                this.addExtendingConfigurations(string2, defaultDependencyDescriptor, bl);
            }
        }
        String[] stringArray = hashSet.toArray(new String[hashSet.size()]);
        this.parseDepsConfs(stringArray, defaultDependencyDescriptor, bl);
    }

    protected final void addError(String string) {
        if (this.res != null) {
            this.errors.add(string + " in " + this.res + "\n");
            return;
        }
        this.errors.add(string + "\n");
    }

    public void warning(SAXParseException sAXParseException) {
        Message.warn("xml parsing: " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) {
        this.addError("xml parsing: " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void fatalError(SAXParseException sAXParseException) {
        this.addError("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        } else if (this.res != null) {
            stringBuffer.append(this.res.toString());
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }

    protected final String getDefaultConf() {
        if (this.defaultConf != null) {
            return this.defaultConf;
        }
        if (this.defaultConfMapping != null) {
            return this.defaultConfMapping;
        }
        return "*->*";
    }

    protected final void setDefaultConf(String string) {
        this.defaultConf = string;
    }

    public final ModuleDescriptor getModuleDescriptor() {
        this.checkErrors();
        return this.md;
    }

    protected final Date getDefaultPubDate() {
        return new Date(this.md.getLastModified());
    }

    protected final void setMd(DefaultModuleDescriptor defaultModuleDescriptor) {
        this.md = defaultModuleDescriptor;
    }

    protected final DefaultModuleDescriptor getMd() {
        return this.md;
    }
}

