/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.descriptor;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.Configuration$Visibility;
import org.apache.ivy.core.module.descriptor.ConfigurationGroup;
import org.apache.ivy.core.module.descriptor.ConfigurationIntersection;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptorMediator;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.module.id.ModuleRules;
import org.apache.ivy.core.module.status.StatusManager;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.matcher.ExactOrRegexpPatternMatcher$ExactOrRegexpMatcher;
import org.apache.ivy.plugins.matcher.MapMatcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.namespace.NamespaceTransformer;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.m2.DefaultPomDependencyMgt;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.util.Message;

public final class DefaultModuleDescriptor
implements ModuleDescriptor {
    private ModuleRevisionId revId;
    private ModuleRevisionId resolvedRevId;
    private String status = StatusManager.getCurrent().getDefaultStatus();
    private Date publicationDate;
    private Date resolvedPublicationDate;
    private List dependencies = new ArrayList();
    private Map configurations = new LinkedHashMap();
    private Map artifactsByConf = new HashMap();
    private Collection artifacts = new LinkedHashSet();
    private boolean isDefault = false;
    private ModuleRules conflictManagers = new ModuleRules();
    private ModuleRules dependencyDescriptorMediators = new ModuleRules();
    private List licenses = new ArrayList();
    private String homePage;
    private String description = "";
    private long lastModified = 0L;
    private Namespace namespace;
    private boolean mappingOverride;
    private ModuleDescriptorParser parser;
    private Resource resource;
    private List excludeRules = new ArrayList();
    private Artifact metadataArtifact;
    private List inheritedDescriptors = new ArrayList();
    private Map extraAttributesNamespaces = new LinkedHashMap();
    private Map extraInfo = new HashMap();

    public static DefaultModuleDescriptor newDefaultInstance(ModuleRevisionId moduleRevisionId, DependencyArtifactDescriptor[] dependencyArtifactDescriptorArray) {
        long l;
        DefaultModuleDescriptor defaultModuleDescriptor = new DefaultModuleDescriptor(moduleRevisionId, "release", true);
        defaultModuleDescriptor.addConfiguration(new Configuration("default"));
        if (dependencyArtifactDescriptorArray != null && dependencyArtifactDescriptorArray.length > 0) {
            for (int i = 0; i < dependencyArtifactDescriptorArray.length; ++i) {
                defaultModuleDescriptor.addArtifact("default", new MDArtifact(defaultModuleDescriptor, dependencyArtifactDescriptorArray[i].getName(), dependencyArtifactDescriptorArray[i].getType(), dependencyArtifactDescriptorArray[i].getExt(), dependencyArtifactDescriptorArray[i].getUrl(), dependencyArtifactDescriptorArray[i].getExtraAttributes()));
            }
        } else {
            defaultModuleDescriptor.addArtifact("default", new MDArtifact(defaultModuleDescriptor, moduleRevisionId.getName(), "jar", "jar"));
        }
        defaultModuleDescriptor.lastModified = l = System.currentTimeMillis();
        return defaultModuleDescriptor;
    }

    public static ModuleDescriptor transformInstance(ModuleDescriptor moduleDescriptor, Namespace namespace) {
        boolean bl;
        NamespaceTransformer namespaceTransformer = namespace.getToSystemTransformer();
        if (namespaceTransformer.isIdentity()) {
            return moduleDescriptor;
        }
        DefaultModuleDescriptor defaultModuleDescriptor = new DefaultModuleDescriptor(moduleDescriptor.getParser(), moduleDescriptor.getResource());
        new DefaultModuleDescriptor(moduleDescriptor.getParser(), moduleDescriptor.getResource()).revId = namespaceTransformer.transform(moduleDescriptor.getModuleRevisionId());
        defaultModuleDescriptor.resolvedRevId = namespaceTransformer.transform(moduleDescriptor.getResolvedModuleRevisionId());
        defaultModuleDescriptor.status = moduleDescriptor.getStatus();
        defaultModuleDescriptor.publicationDate = moduleDescriptor.getPublicationDate();
        defaultModuleDescriptor.resolvedPublicationDate = moduleDescriptor.getResolvedPublicationDate();
        ExtendsDescriptor[] extendsDescriptorArray = moduleDescriptor.getInheritedDescriptors();
        for (int i = 0; i < extendsDescriptorArray.length; ++i) {
            ModuleRevisionId moduleRevisionId = namespaceTransformer.transform(extendsDescriptorArray[i].getParentRevisionId());
            ModuleRevisionId moduleRevisionId2 = namespaceTransformer.transform(extendsDescriptorArray[i].getResolvedParentRevisionId());
            defaultModuleDescriptor.inheritedDescriptors.add(new ExtendsDescriptor(moduleRevisionId, moduleRevisionId2, extendsDescriptorArray[i].getLocation(), extendsDescriptorArray[i].getExtendsTypes()));
        }
        DependencyDescriptor[] dependencyDescriptorArray = moduleDescriptor.getDependencies();
        for (int i = 0; i < dependencyDescriptorArray.length; ++i) {
            Namespace namespace2 = namespace;
            defaultModuleDescriptor.dependencies.add(DefaultDependencyDescriptor.transformInstance(dependencyDescriptorArray[i], namespace2));
        }
        Configuration[] configurationArray = moduleDescriptor.getConfigurations();
        for (int i = 0; i < configurationArray.length; ++i) {
            defaultModuleDescriptor.configurations.put(configurationArray[i].getName(), configurationArray[i]);
            Artifact[] artifactArray = moduleDescriptor.getArtifacts(configurationArray[i].getName());
            for (int j = 0; j < artifactArray.length; ++j) {
                defaultModuleDescriptor.addArtifact(configurationArray[i].getName(), DefaultPomDependencyMgt.transform(artifactArray[j], namespaceTransformer));
            }
        }
        defaultModuleDescriptor.isDefault = bl = moduleDescriptor.isDefault();
        if (moduleDescriptor instanceof DefaultModuleDescriptor) {
            DefaultModuleDescriptor defaultModuleDescriptor2 = (DefaultModuleDescriptor)moduleDescriptor;
            defaultModuleDescriptor.conflictManagers = (ModuleRules)defaultModuleDescriptor2.conflictManagers.clone();
            defaultModuleDescriptor.dependencyDescriptorMediators = (ModuleRules)defaultModuleDescriptor2.dependencyDescriptorMediators.clone();
        } else {
            Message.warn("transformed module descriptor is not a default module descriptor: impossible to copy conflict manager and version mediation configuration: " + moduleDescriptor);
        }
        defaultModuleDescriptor.licenses.addAll(Arrays.asList(moduleDescriptor.getLicenses()));
        defaultModuleDescriptor.homePage = moduleDescriptor.getHomePage();
        defaultModuleDescriptor.description = moduleDescriptor.getDescription();
        defaultModuleDescriptor.lastModified = moduleDescriptor.getLastModified();
        defaultModuleDescriptor.extraAttributesNamespaces = moduleDescriptor.getExtraAttributesNamespaces();
        defaultModuleDescriptor.extraInfo = moduleDescriptor.getExtraInfo();
        defaultModuleDescriptor.namespace = namespace;
        return defaultModuleDescriptor;
    }

    public DefaultModuleDescriptor(ModuleRevisionId moduleRevisionId, String string, boolean bl) {
        if (moduleRevisionId == null) {
            throw new NullPointerException("null module revision id not allowed");
        }
        if (string == null) {
            throw new NullPointerException("null status not allowed");
        }
        this.revId = moduleRevisionId;
        this.resolvedRevId = moduleRevisionId;
        this.status = string;
        this.publicationDate = null;
        this.resolvedPublicationDate = this.publicationDate == null ? new Date() : this.publicationDate;
        this.isDefault = bl;
        this.parser = XmlModuleDescriptorParser.getInstance();
    }

    public DefaultModuleDescriptor(ModuleDescriptorParser moduleDescriptorParser, Resource resource) {
        this.parser = moduleDescriptorParser;
        this.resource = resource;
    }

    public final Artifact getMetadataArtifact() {
        if (this.metadataArtifact == null) {
            this.metadataArtifact = DefaultArtifact.newIvyArtifact(this.resolvedRevId, this.resolvedPublicationDate);
        }
        return this.metadataArtifact;
    }

    public final void setModuleArtifact(Artifact artifact) {
        this.metadataArtifact = artifact;
    }

    public final boolean isDefault() {
        return this.isDefault;
    }

    public final void setPublicationDate(Date date) {
        this.publicationDate = date;
        if (this.resolvedPublicationDate == null) {
            this.resolvedPublicationDate = date == null ? new Date() : date;
        }
    }

    public final Date getPublicationDate() {
        return this.publicationDate;
    }

    public final void setResolvedPublicationDate(Date date) {
        if (date == null) {
            throw new NullPointerException("null publication date not allowed");
        }
        this.resolvedPublicationDate = date;
    }

    public final Date getResolvedPublicationDate() {
        return this.resolvedPublicationDate;
    }

    public final String getRevision() {
        return this.resolvedRevId.getRevision();
    }

    public final void setModuleRevisionId(ModuleRevisionId moduleRevisionId) {
        if (moduleRevisionId == null) {
            throw new NullPointerException("null module revision id not allowed");
        }
        this.revId = moduleRevisionId;
        if (this.resolvedRevId == null) {
            this.resolvedRevId = moduleRevisionId;
        }
    }

    public final void setResolvedModuleRevisionId(ModuleRevisionId moduleRevisionId) {
        this.resolvedRevId = moduleRevisionId;
    }

    public final void setStatus(String string) {
        this.status = string;
    }

    public final void addInheritedDescriptor(ExtendsDescriptor extendsDescriptor) {
        this.inheritedDescriptors.add(extendsDescriptor);
    }

    public final void addDependency(DependencyDescriptor dependencyDescriptor) {
        this.dependencies.add(dependencyDescriptor);
    }

    public final void addConfiguration(Configuration configuration) {
        this.configurations.put(configuration.getName(), configuration);
    }

    public final void addArtifact(String string, Artifact artifact) {
        Configuration configuration = this.getConfiguration(string);
        if (configuration == null) {
            throw new IllegalArgumentException("Cannot add artifact '" + artifact.getId().getArtifactId().getShortDescription() + "' to configuration '" + string + "' of module " + this.revId + " because this configuration doesn't exist!");
        }
        if (configuration instanceof ConfigurationGroup) {
            String[] stringArray = ((ConfigurationGroup)configuration).getMembersConfigurationNames();
            for (int i = 0; i < stringArray.length; ++i) {
                this.addArtifact(stringArray[i], artifact);
            }
            return;
        }
        ArrayList<Artifact> arrayList = (ArrayList<Artifact>)this.artifactsByConf.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Artifact>();
            this.artifactsByConf.put(string, arrayList);
        }
        arrayList.add(artifact);
        this.artifacts.add(artifact);
    }

    public final ModuleRevisionId getModuleRevisionId() {
        return this.revId;
    }

    public final ModuleRevisionId getResolvedModuleRevisionId() {
        return this.resolvedRevId;
    }

    public final String getStatus() {
        return this.status;
    }

    public final ExtendsDescriptor[] getInheritedDescriptors() {
        return this.inheritedDescriptors.toArray(new ExtendsDescriptor[this.inheritedDescriptors.size()]);
    }

    public final Configuration[] getConfigurations() {
        return this.configurations.values().toArray(new Configuration[this.configurations.size()]);
    }

    public final String[] getConfigurationsNames() {
        return this.configurations.keySet().toArray(new String[this.configurations.size()]);
    }

    public final String[] getPublicConfigurationsNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.configurations.values().iterator();
        while (iterator.hasNext()) {
            Configuration configuration = (Configuration)iterator.next();
            if (configuration.getVisibility() != Configuration$Visibility.PUBLIC) continue;
            arrayList.add(configuration.getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public final Configuration getConfiguration(String string) {
        Configuration configuration = (Configuration)this.configurations.get(string);
        if (configuration == null && string != null) {
            Matcher matcher = Pattern.compile("\\*\\[([^=]+)\\=([^\\]]+)\\]").matcher(string);
            if (matcher.matches()) {
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                LinkedHashMap<String, Configuration> linkedHashMap = new LinkedHashMap<String, Configuration>();
                Iterator iterator = this.configurations.values().iterator();
                while (iterator.hasNext()) {
                    Configuration configuration2 = (Configuration)iterator.next();
                    if (!string3.equals(configuration2.getAttribute(string2))) continue;
                    linkedHashMap.put(configuration2.getName(), configuration2);
                }
                return new ConfigurationGroup(string, linkedHashMap);
            }
            String[] stringArray = string.split("\\+");
            if (stringArray.length <= 1) {
                return null;
            }
            LinkedHashMap<String, Configuration> linkedHashMap = new LinkedHashMap<String, Configuration>();
            for (int i = 0; i < stringArray.length; ++i) {
                Configuration configuration3 = (Configuration)this.configurations.get(stringArray[i]);
                if (configuration3 == null) {
                    Message.verbose("missing configuration '" + stringArray[i] + "' from intersection " + string + " in " + this);
                    return null;
                }
                linkedHashMap.put(stringArray[i], configuration3);
            }
            return new ConfigurationIntersection(string, linkedHashMap);
        }
        return configuration;
    }

    public final Artifact[] getArtifacts(String string) {
        Configuration configuration = this.getConfiguration(string);
        if (configuration == null) {
            return new Artifact[0];
        }
        Collection collection = (Collection)this.artifactsByConf.get(string);
        if (configuration instanceof ConfigurationIntersection) {
            String[] stringArray = ((ConfigurationIntersection)configuration).getIntersectedConfigurationNames();
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            for (int i = 0; i < stringArray.length; ++i) {
                Collection collection2 = this.getArtifactsIncludingExtending(stringArray[i]);
                if (linkedHashSet.isEmpty()) {
                    linkedHashSet.addAll(collection2);
                    continue;
                }
                linkedHashSet.retainAll(collection2);
            }
            if (collection != null) {
                linkedHashSet.addAll(collection);
            }
            return linkedHashSet.toArray(new Artifact[linkedHashSet.size()]);
        }
        if (configuration instanceof ConfigurationGroup) {
            String[] stringArray = ((ConfigurationGroup)configuration).getMembersConfigurationNames();
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            for (int i = 0; i < stringArray.length; ++i) {
                linkedHashSet.addAll(this.getArtifactsIncludingExtending(stringArray[i]));
            }
            if (collection != null) {
                linkedHashSet.addAll(collection);
            }
            return linkedHashSet.toArray(new Artifact[linkedHashSet.size()]);
        }
        if (collection == null) {
            return new Artifact[0];
        }
        return collection.toArray(new Artifact[collection.size()]);
    }

    private Collection getArtifactsIncludingExtending(String string) {
        Collection collection = Configuration.findConfigurationExtending(string, this.getConfigurations());
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Collection collection2 = (Collection)this.artifactsByConf.get(string);
        if (collection2 != null) {
            linkedHashSet.addAll(collection2);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Configuration configuration = (Configuration)iterator.next();
            collection2 = (Collection)this.artifactsByConf.get(configuration.getName());
            if (collection2 == null) continue;
            linkedHashSet.addAll(collection2);
        }
        return linkedHashSet;
    }

    public final Artifact[] getAllArtifacts() {
        return this.artifacts.toArray(new Artifact[this.artifacts.size()]);
    }

    public final DependencyDescriptor[] getDependencies() {
        return this.dependencies.toArray(new DependencyDescriptor[this.dependencies.size()]);
    }

    public final void toIvyFile(File file2) {
        if (this.parser != null && this.resource != null) {
            this.parser.toIvyFile(this.resource.openStream(), this.resource, file2, this);
            return;
        }
        XmlModuleDescriptorWriter.write(this, file2);
    }

    public final String toString() {
        return "module: " + this.revId + " status=" + this.status + " publication=" + this.publicationDate + " configurations=" + this.configurations + " artifacts=" + this.artifactsByConf + " dependencies=" + this.dependencies;
    }

    public final void setDefault(boolean bl) {
        this.isDefault = bl;
    }

    public final void addConflictManager(ModuleId moduleId, PatternMatcher patternMatcher, ConflictManager conflictManager) {
        this.conflictManagers.defineRule(new MapMatcher(moduleId.getAttributes(), patternMatcher), conflictManager);
    }

    public final ConflictManager getConflictManager(ModuleId moduleId) {
        return (ConflictManager)this.conflictManagers.getRule(moduleId);
    }

    public final void addDependencyDescriptorMediator(ModuleId moduleId, PatternMatcher patternMatcher, DependencyDescriptorMediator dependencyDescriptorMediator) {
        this.dependencyDescriptorMediators.defineRule(new MapMatcher(moduleId.getAttributes(), patternMatcher), dependencyDescriptorMediator);
    }

    public final DependencyDescriptor mediate(DependencyDescriptor dependencyDescriptor) {
        Object[] objectArray = this.dependencyDescriptorMediators.getRules(dependencyDescriptor.getDependencyId());
        for (int i = 0; i < objectArray.length; ++i) {
            dependencyDescriptor = ((DependencyDescriptorMediator)objectArray[i]).mediate(dependencyDescriptor);
        }
        return dependencyDescriptor;
    }

    public final ModuleRules getAllDependencyDescriptorMediators() {
        return (ModuleRules)this.dependencyDescriptorMediators.clone();
    }

    public final void addLicense(License license) {
        this.licenses.add(license);
    }

    public final License[] getLicenses() {
        return this.licenses.toArray(new License[this.licenses.size()]);
    }

    public final String getHomePage() {
        return this.homePage;
    }

    public final void setHomePage(String string) {
        this.homePage = string;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String string) {
        this.description = string;
    }

    public final long getLastModified() {
        return this.lastModified;
    }

    public final void setLastModified(long l) {
        this.lastModified = l;
    }

    public final Namespace getNamespace() {
        return this.namespace;
    }

    public final void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public final void check() {
        Stack<String> stack = new Stack<String>();
        Iterator iterator = this.configurations.values().iterator();
        while (iterator.hasNext()) {
            Configuration configuration = (Configuration)iterator.next();
            String[] stringArray = configuration.getExtends();
            for (int i = 0; i < stringArray.length; ++i) {
                stack.push(configuration.getName());
                this.checkConf(stack, stringArray[i].trim());
                stack.pop();
            }
        }
    }

    private void checkConf(Stack stack, String string) {
        int n = stack.indexOf(string);
        if (n != -1) {
            StringBuffer stringBuffer = new StringBuffer();
            while (n < stack.size()) {
                stringBuffer.append(stack.get(n)).append(" => ");
                ++n;
            }
            stringBuffer.append(string);
            throw new IllegalStateException("illegal cycle detected in configuration extension: " + stringBuffer);
        }
        Configuration configuration = this.getConfiguration(string);
        if (configuration == null) {
            throw new IllegalStateException("unknown configuration '" + string + "'. It is extended by " + stack.get(stack.size() - 1));
        }
        String[] stringArray = configuration.getExtends();
        for (int i = 0; i < stringArray.length; ++i) {
            stack.push(configuration.getName());
            this.checkConf(stack, stringArray[i].trim());
            stack.pop();
        }
    }

    public final void setMappingOverride(boolean bl) {
        this.mappingOverride = bl;
    }

    public final boolean isMappingOverride() {
        return this.mappingOverride;
    }

    public final Map getAttributes() {
        return this.resolvedRevId.getAttributes();
    }

    public final String getExtraAttribute(String string) {
        return this.resolvedRevId.getExtraAttribute(string);
    }

    public final Map getExtraAttributes() {
        return this.resolvedRevId.getExtraAttributes();
    }

    public final Map getQualifiedExtraAttributes() {
        return this.resolvedRevId.getQualifiedExtraAttributes();
    }

    public final ModuleDescriptorParser getParser() {
        return this.parser;
    }

    public final Resource getResource() {
        return this.resource;
    }

    public final void addExcludeRule(ExcludeRule excludeRule) {
        this.excludeRules.add(excludeRule);
    }

    public final boolean canExclude() {
        return !this.excludeRules.isEmpty();
    }

    public final boolean doesExclude(String[] stringArray, ArtifactId artifactId) {
        if (this.namespace != null) {
            artifactId = DefaultPomDependencyMgt.transform(artifactId, this.namespace.getFromSystemTransformer());
        }
        String[] stringArray2 = stringArray;
        DefaultModuleDescriptor defaultModuleDescriptor = this;
        LinkedHashSet<ExcludeRule> linkedHashSet = new LinkedHashSet<ExcludeRule>();
        Iterator iterator = defaultModuleDescriptor.excludeRules.iterator();
        while (iterator.hasNext()) {
            ExcludeRule excludeRule = (ExcludeRule)iterator.next();
            String[] stringArray3 = stringArray2;
            String[] stringArray4 = excludeRule.getConfigurations();
            if (!new ArrayList<String>(Arrays.asList(stringArray4)).removeAll(Arrays.asList(stringArray3))) continue;
            linkedHashSet.add(excludeRule);
        }
        ExcludeRule[] excludeRuleArray = linkedHashSet.toArray(new ExcludeRule[linkedHashSet.size()]);
        for (int i = 0; i < excludeRuleArray.length; ++i) {
            if (!ExactOrRegexpPatternMatcher$ExactOrRegexpMatcher.matches(excludeRuleArray[i].getMatcher(), excludeRuleArray[i].getId(), artifactId)) continue;
            return true;
        }
        return false;
    }

    public final ExcludeRule[] getAllExcludeRules() {
        return this.excludeRules.toArray(new ExcludeRule[this.excludeRules.size()]);
    }

    public final Map getExtraAttributesNamespaces() {
        return this.extraAttributesNamespaces;
    }

    public final void addExtraAttributeNamespace(String string, String string2) {
        this.extraAttributesNamespaces.put(string, string2);
    }

    public final void addExtraInfo(String string, String string2) {
        this.extraInfo.put(string, string2);
    }

    public final Map getExtraInfo() {
        return this.extraInfo;
    }
}

