/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

public class MemoryUtils {
    private static long lastGC;
    private static final int GC_DELAY = 50;
    private static final int MAX_GC = 8;

    public static int getMemoryUsed() {
        MemoryUtils.collectGarbage();
        Runtime rt = Runtime.getRuntime();
        long mem = rt.totalMemory() - rt.freeMemory();
        return (int)(mem >> 10);
    }

    public static int getMemoryFree() {
        MemoryUtils.collectGarbage();
        Runtime rt = Runtime.getRuntime();
        long mem = rt.freeMemory();
        return (int)(mem >> 10);
    }

    private static synchronized void collectGarbage() {
        Runtime runtime = Runtime.getRuntime();
        long total = runtime.totalMemory();
        long time = System.currentTimeMillis();
        if (lastGC + 50L < time) {
            for (int i = 0; i < 8; ++i) {
                runtime.gc();
                long now = runtime.totalMemory();
                if (now == total) {
                    lastGC = System.currentTimeMillis();
                    break;
                }
                total = now;
            }
        }
    }
}

