/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ivy.plugins.repository.AbstractRepository;
import org.apache.ivy.plugins.repository.RepositoryCopyProgressListener;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.file.FileResource;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.FileUtil;

public class FileRepository
extends AbstractRepository {
    private RepositoryCopyProgressListener progress = new RepositoryCopyProgressListener(this);
    private File baseDir = null;
    private boolean local = true;

    public Resource getResource(String source) throws IOException {
        return new FileResource(this, this.getFile(source));
    }

    public void get(String source, File destination) throws IOException {
        this.fireTransferInitiated(this.getResource(source), 5);
        this.copy(this.getFile(source), destination, true);
    }

    public void put(File source, String destination, boolean overwrite) throws IOException {
        this.fireTransferInitiated(this.getResource(destination), 6);
        this.copy(source, this.getFile(destination), overwrite);
    }

    public void move(File src, File dest) throws IOException {
        if (!src.renameTo(dest)) {
            throw new IOException("impossible to move '" + src + "' to '" + dest + "'");
        }
    }

    public void delete(File f) throws IOException {
        if (!FileUtil.forceDelete(f)) {
            throw new IOException("impossible to delete '" + f + "'");
        }
    }

    private void copy(File src, File destination, boolean overwrite) throws IOException {
        try {
            this.getProgressListener().setTotalLength(new Long(src.length()));
            if (!FileUtil.copy(src, destination, this.getProgressListener(), overwrite)) {
                if (!overwrite && destination.exists()) {
                    throw new IOException("file copy not done from " + src + " to " + destination + ": destination already exists and overwrite is false");
                }
                throw new IOException("file copy not done from " + src + " to " + destination);
            }
        }
        catch (IOException ex) {
            this.fireTransferError(ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            this.fireTransferError(ex);
            throw ex;
        }
        finally {
            this.getProgressListener().setTotalLength(null);
        }
    }

    protected RepositoryCopyProgressListener getProgressListener() {
        return this.progress;
    }

    public List list(String parent) throws IOException {
        String[] names;
        File dir = this.getFile(parent);
        if (dir.exists() && dir.isDirectory() && (names = dir.list()) != null) {
            ArrayList<String> ret = new ArrayList<String>(names.length);
            for (int i = 0; i < names.length; ++i) {
                ret.add(parent + this.getFileSeparator() + names[i]);
            }
            return ret;
        }
        return null;
    }

    File getFile(String source) {
        if (this.baseDir != null) {
            return FileUtil.resolveFile(this.baseDir, source);
        }
        return Checks.checkAbsolute(source, "source");
    }

    public boolean isLocal() {
        return this.local;
    }
}

