/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.seasar.extension.jdbc.types.AbstractValueType;
import org.seasar.extension.jdbc.util.BindVariableUtil;
import org.seasar.framework.util.TimestampConversionUtil;

public class TimestampType
extends AbstractValueType {
    public TimestampType() {
        super(93);
    }

    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        return resultSet.getTimestamp(index);
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        return resultSet.getTimestamp(columnName);
    }

    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return cs.getTimestamp(index);
    }

    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return cs.getTimestamp(parameterName);
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else {
            ps.setTimestamp(index, this.toTimestamp(value));
        }
    }

    public void bindValue(CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else {
            cs.setTimestamp(parameterName, this.toTimestamp(value));
        }
    }

    protected Timestamp toTimestamp(Object value) {
        if (value instanceof Date || value instanceof Calendar) {
            return TimestampConversionUtil.toTimestamp((Object)value);
        }
        return TimestampConversionUtil.toTimestamp((Object)value, (String)TimestampConversionUtil.getPattern((Locale)Locale.getDefault()));
    }

    public String toText(Object value) {
        if (value == null) {
            return BindVariableUtil.nullText();
        }
        return BindVariableUtil.toText(this.toTimestamp(value));
    }
}

