/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.provider;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.XADataSource;
import jp.sf.amateras.mirage.exception.SQLRuntimeException;
import jp.sf.amateras.mirage.provider.ConnectionProvider;
import jp.sf.amateras.mirage.util.JdbcUtil;

public class XADataSourceConnectionProvider
implements ConnectionProvider {
    private static final Logger logger = Logger.getLogger(XADataSourceConnectionProvider.class.getName());
    private XADataSource xaDataSource;
    private ThreadLocal<Connection> threadLocal = new ThreadLocal();

    public void setDataSource(XADataSource xaDataSource) {
        this.xaDataSource = xaDataSource;
    }

    public void releaseConnection() {
        Connection conn = this.threadLocal.get();
        if (conn != null) {
            JdbcUtil.close(conn);
            this.threadLocal.remove();
            logger.info("Connection is released.");
        } else {
            logger.info("Connection is not used.");
        }
    }

    public Connection getConnection() throws SQLRuntimeException {
        try {
            Connection conn = this.threadLocal.get();
            if (conn == null) {
                conn = this.xaDataSource.getXAConnection().getConnection();
                this.threadLocal.set(conn);
                logger.info("Get Connection from DataSource.");
            }
            return conn;
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
    }
}

