package code.util

import javax.servlet.http.HttpServletRequest

/**
 * ThreadLocalにHttpServletRequestを保持するオブジェクト。
 * [[code.util.RequestFilter]]によってリクエスト毎にHttpServletRequestのセット、削除が行われます。
 */
object RequestUtil {

  val requests: ThreadLocal[HttpServletRequest] = new ThreadLocal

  /**
   * HttpServletRequestを取得します。
   */
  def getRequest: HttpServletRequest = {
    requests.get()
  }

  private[util] def setRequest(request: HttpServletRequest){
    requests.set(request)
  }

  private[util] def removeRequest(){
    requests.remove()
  }

}