package code.util

import java.util.Date
import java.text.SimpleDateFormat
import java.io.File

/**
 * ファイル一覧の情報を格納するためのDTOです。
 *
 * @param file 対象のファイル
 * @param parentPath 親ディレクトリのパス
 * @see BrowseAction
 * @author Naoki Takezoe
 */
case class FileDto(file: File, parentPath: String) {

  private def fixPath(value: String, file: File): String = if(file.isFile) value else value + "/"

  /**
   * ファイルかどうか
   */
  val isFile: Boolean = file.isFile

  /**
   * ファイルもしくはディレクトリ名
   */
  val name: String = fixPath(file.getName, file)

  /**
   * バックアップディレクトリ内のパス
   */
  val path: String = fixPath(Util.buildPath(parentPath, file.getName), file)

  /**
   * 最終更新日時
   */
  val date: Date = new Date(file.lastModified)

  /**
   * アイコンのパス
   */
  val icon: String = Util.getIcon(file)

  /**
   * yyyy/MM/dd HH:mm:ss形式でフォーマットした最終更新日時
   * @return 最終更新日時
   */
  def getFormattedDate: String = {
    return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(date)
  }

}