package jp.sf.amateras.mirage.bean;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BeanDescFactory {

	private static Map<Class<?>, BeanDesc> cacheMap = new ConcurrentHashMap<Class<?>, BeanDesc>();
	private static boolean cacheEnabled = false;

	public static void setCacheEnabled(boolean cacheEnabled){
		BeanDescFactory.cacheEnabled = cacheEnabled;
	}

	public static boolean isCacheEnabled(){
		return BeanDescFactory.cacheEnabled;
	}

	@SuppressWarnings("unchecked")
	public static BeanDesc getBeanDesc(Object obj){
		if(obj instanceof Map){
			return new MapBeanDescImpl((Map) obj);
		} else {
			return getBeanDesc(obj.getClass());
		}
	}

	public static BeanDesc getBeanDesc(Class<?> clazz){
		if(clazz == Map.class){
			return new MapBeanDescImpl();
		}

		if(cacheEnabled){
			if(cacheMap.containsKey(clazz)){
				return cacheMap.get(clazz);
			}
		}

		BeanDesc beanDesc = new BeanDescImpl(clazz);

		if(cacheEnabled){
			cacheMap.put(clazz, beanDesc);
		}

		return beanDesc;
	}

}
