package jp.sf.amateras.mirage.util;

import java.io.Closeable;
import java.io.InputStream;
import java.util.Properties;

public class IOUtil {

	public static void closeQuitly(Closeable closeable){
		if(closeable != null){
			try {
				closeable.close();
			} catch(Exception ex){
				;
			}
		}
	}

	public static Properties loadProperties(String path){
		ClassLoader cl = Thread.currentThread().getContextClassLoader();
		InputStream in = null;
		try {
			in = cl.getResourceAsStream(path);

			Properties properties = new Properties();
			properties.load(in);

			return properties;

		} catch(Exception ex){
			return null;

		} finally {
			IOUtil.closeQuitly(in);
		}
	}

}
