package jp.sf.amateras.functions.utils;

import java.text.DecimalFormat;

/**
 * 数値関連のユーティリティメソッドを提供します。
 *
 * @author Naoki Takezoe
 */
public class NumberUtil {

	/**
	 * 数値を指定されたパターンでフォーマットします。
	 *
	 * @param number フォーマットする数値
	 * @param pattern <code>java.text.DecimalFormat</code>で指定可能なパターン
	 * @return フォーマットされた文字列。引数<code>number</code>が<code>null</code>の場合は空文字列
	 */
	public static String formatNumber(Object number, String pattern){
		DecimalFormat formatter = new DecimalFormat(pattern);
		return formatter.format(number);
	}

}
