/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.latest;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.latest.ComparatorLatestStrategy;
import org.apache.ivy.plugins.version.VersionMatcher;

public class LatestRevisionStrategy
extends ComparatorLatestStrategy {
    private static final Map DEFAULT_SPECIAL_MEANINGS = new HashMap();
    private final Comparator mridComparator = new MridComparator();
    private final Comparator artifactInfoComparator = new ArtifactInfoComparator();
    private Map specialMeanings = null;
    private boolean usedefaultspecialmeanings = true;

    public LatestRevisionStrategy() {
        this.setComparator(this.artifactInfoComparator);
        this.setName("latest-revision");
    }

    public synchronized Map getSpecialMeanings() {
        if (this.specialMeanings == null) {
            this.specialMeanings = new HashMap();
            if (this.isUsedefaultspecialmeanings()) {
                this.specialMeanings.putAll(DEFAULT_SPECIAL_MEANINGS);
            }
        }
        return this.specialMeanings;
    }

    public boolean isUsedefaultspecialmeanings() {
        return this.usedefaultspecialmeanings;
    }

    static {
        DEFAULT_SPECIAL_MEANINGS.put("dev", new Integer(-1));
        DEFAULT_SPECIAL_MEANINGS.put("rc", new Integer(1));
        DEFAULT_SPECIAL_MEANINGS.put("final", new Integer(2));
    }

    final class ArtifactInfoComparator
    implements Comparator {
        ArtifactInfoComparator() {
        }

        public int compare(Object o1, Object o2) {
            String rev1 = ((ArtifactInfo)o1).getRevision();
            String rev2 = ((ArtifactInfo)o2).getRevision();
            VersionMatcher vmatcher = IvyContext.getContext().getSettings().getVersionMatcher();
            ModuleRevisionId mrid1 = ModuleRevisionId.newInstance("", "", rev1);
            ModuleRevisionId mrid2 = ModuleRevisionId.newInstance("", "", rev2);
            if (vmatcher.isDynamic(mrid1)) {
                int c = vmatcher.compare(mrid1, mrid2, LatestRevisionStrategy.this.mridComparator);
                return c >= 0 ? 1 : -1;
            }
            if (vmatcher.isDynamic(mrid2)) {
                int c = vmatcher.compare(mrid2, mrid1, LatestRevisionStrategy.this.mridComparator);
                return c >= 0 ? -1 : 1;
            }
            return LatestRevisionStrategy.this.mridComparator.compare(mrid1, mrid2);
        }
    }

    final class MridComparator
    implements Comparator {
        MridComparator() {
        }

        public int compare(Object o1, Object o2) {
            int i;
            String rev1 = ((ModuleRevisionId)o1).getRevision();
            String rev2 = ((ModuleRevisionId)o2).getRevision();
            rev1 = rev1.replaceAll("([a-zA-Z])(\\d)", "$1.$2");
            rev1 = rev1.replaceAll("(\\d)([a-zA-Z])", "$1.$2");
            rev2 = rev2.replaceAll("([a-zA-Z])(\\d)", "$1.$2");
            rev2 = rev2.replaceAll("(\\d)([a-zA-Z])", "$1.$2");
            String[] parts1 = rev1.split("[\\._\\-\\+]");
            String[] parts2 = rev2.split("[\\._\\-\\+]");
            for (i = 0; i < parts1.length && i < parts2.length; ++i) {
                if (parts1[i].equals(parts2[i])) continue;
                boolean is1Number = this.isNumber(parts1[i]);
                boolean is2Number = this.isNumber(parts2[i]);
                if (is1Number && !is2Number) {
                    return 1;
                }
                if (is2Number && !is1Number) {
                    return -1;
                }
                if (is1Number && is2Number) {
                    return Long.valueOf(parts1[i]).compareTo(Long.valueOf(parts2[i]));
                }
                Map specialMeanings = LatestRevisionStrategy.this.getSpecialMeanings();
                Integer sm1 = (Integer)specialMeanings.get(parts1[i].toLowerCase(Locale.US));
                Integer sm2 = (Integer)specialMeanings.get(parts2[i].toLowerCase(Locale.US));
                if (sm1 != null) {
                    sm2 = sm2 == null ? new Integer(0) : sm2;
                    return sm1.compareTo(sm2);
                }
                if (sm2 != null) {
                    return new Integer(0).compareTo(sm2);
                }
                return parts1[i].compareTo(parts2[i]);
            }
            if (i < parts1.length) {
                return this.isNumber(parts1[i]) ? 1 : -1;
            }
            if (i < parts2.length) {
                return this.isNumber(parts2[i]) ? -1 : 1;
            }
            return 0;
        }

        private boolean isNumber(String str) {
            return str.matches("\\d+");
        }
    }
}

