/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dataset.impl;

import java.sql.Connection;
import java.sql.Statement;
import javax.sql.DataSource;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.impl.SqlTableWriter;
import org.seasar.extension.jdbc.impl.BasicSelectHandler;
import org.seasar.extension.jdbc.impl.ObjectResultSetHandler;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.extension.jdbc.util.DataSourceUtil;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.StatementUtil;

public class SqlServerSqlTableWriter
extends SqlTableWriter {
    private static final Logger logger = Logger.getLogger((Class)SqlTableWriter.class);

    public SqlServerSqlTableWriter(DataSource dataSource) {
        super(dataSource);
    }

    protected void doWrite(DataTable dataTable) {
        boolean hasIdentity = this.hasIdentityColumn(dataTable);
        if (hasIdentity) {
            this.turnOnIdentityInsert(dataTable);
        }
        super.doWrite(dataTable);
        if (hasIdentity) {
            this.turnOffIdentityInsert(dataTable);
        }
    }

    private void turnOnIdentityInsert(DataTable dataTable) {
        this.setIdentityInsert(dataTable, "ON");
    }

    private void turnOffIdentityInsert(DataTable dataTable) {
        this.setIdentityInsert(dataTable, "OFF");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIdentityInsert(DataTable dataTable, String command) {
        String sql = "SET IDENTITY_INSERT " + dataTable.getTableName() + " " + command;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        Connection connection = DataSourceUtil.getConnection(this.getDataSource());
        try {
            Statement statement = ConnectionUtil.createStatement(connection);
            try {
                StatementUtil.execute((Statement)statement, (String)sql);
            }
            finally {
                StatementUtil.close((Statement)statement);
            }
        }
        finally {
            ConnectionUtil.close(connection);
        }
    }

    private boolean hasIdentityColumn(DataTable dataTable) {
        String sql = "SELECT IDENT_CURRENT ('" + dataTable.getTableName() + "') AS IDENT_CURRENT";
        BasicSelectHandler handler = new BasicSelectHandler(this.getDataSource(), sql, new ObjectResultSetHandler());
        return handler.execute((Object[])null) != null;
    }
}

