/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.UserAggregate;
import org.h2.message.Message;

public class CreateAggregate
extends DefineCommand {
    private String name;
    private String javaClassMethod;
    private boolean ifNotExists;
    private boolean force;

    public CreateAggregate(Session session) {
        super(session);
    }

    public int update() throws SQLException {
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        Database db = this.session.getDatabase();
        if (db.findAggregate(this.name) != null || db.findFunctionAlias(this.name) != null) {
            if (!this.ifNotExists) {
                throw Message.getSQLException(90076, this.name);
            }
        } else {
            int id = this.getObjectId(false, true);
            UserAggregate aggregate = new UserAggregate(db, id, this.name, this.javaClassMethod, this.force);
            db.addDatabaseObject(this.session, aggregate);
        }
        return 0;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setJavaClassMethod(String string) {
        this.javaClassMethod = string;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void setForce(boolean force) {
        this.force = force;
    }
}

