/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.ivy.util.url.URLHandler;

public abstract class AbstractURLHandler
implements URLHandler {
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("%25([0-9a-fA-F][0-9a-fA-F])");
    private static int requestMethod = 2;

    public final void setRequestMethod(int n) {
        requestMethod = n;
    }

    public static int getRequestMethod() {
        return requestMethod;
    }

    protected static String normalizeToString(URL uRL) {
        if (!"http".equals(uRL.getProtocol()) && !"https".equals(uRL.getProtocol())) {
            return uRL.toExternalForm();
        }
        try {
            String string = new URI(uRL.getProtocol(), uRL.getAuthority(), uRL.getPath(), uRL.getQuery(), uRL.getRef()).toASCIIString().replaceAll("\\+", "%2B");
            return ESCAPE_PATTERN.matcher(string).replaceAll("%$1");
        }
        catch (URISyntaxException uRISyntaxException) {
            MalformedURLException malformedURLException = new MalformedURLException("Couldn't convert '" + uRL.toString() + "' to a valid URI");
            malformedURLException.initCause(uRISyntaxException);
            throw malformedURLException;
        }
    }

    protected static URL normalizeToURL(URL uRL) {
        if (!"http".equals(uRL.getProtocol()) && !"https".equals(uRL.getProtocol())) {
            return uRL;
        }
        return new URL(AbstractURLHandler.normalizeToString(uRL));
    }

    protected static InputStream getDecodingInputStream(String string, InputStream inputStream) {
        InputStream inputStream2;
        if ("gzip".equals(string)) {
            inputStream2 = new GZIPInputStream(inputStream);
        } else if ("deflate".equals(string)) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            bufferedInputStream.mark(100);
            byte[] byArray = new byte[100];
            int n = bufferedInputStream.read(byArray);
            bufferedInputStream.reset();
            Inflater inflater = new Inflater();
            inflater.setInput(byArray, 0, n);
            try {
                inflater.inflate(new byte[1000]);
                inputStream2 = new InflaterInputStream(bufferedInputStream);
            }
            catch (DataFormatException dataFormatException) {
                inputStream2 = new InflaterInputStream(bufferedInputStream, new Inflater(true));
            }
            finally {
                inflater.end();
            }
        } else {
            inputStream2 = inputStream;
        }
        return inputStream2;
    }
}

